/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.references;

import com.intellij.lang.properties.PropertiesReferenceProvider;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PatternCondition;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.patterns.PsiJavaElementPattern;
import com.intellij.patterns.PsiJavaPatterns;
import com.intellij.patterns.StandardPatterns;
import com.intellij.patterns.XmlAttributeValuePattern;
import com.intellij.patterns.XmlPatterns;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.psi.PsiReferenceContributor;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.PsiReferenceRegistrar;
import com.intellij.psi.filters.AndFilter;
import com.intellij.psi.filters.ElementFilter;
import com.intellij.psi.filters.PsiMethodCallFilter;
import com.intellij.psi.filters.ScopeFilter;
import com.intellij.psi.filters.TextFilter;
import com.intellij.psi.filters.XmlTagFilter;
import com.intellij.psi.filters.position.FilterPattern;
import com.intellij.psi.filters.position.NamespaceFilter;
import com.intellij.psi.filters.position.ParentElementFilter;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlFile;
import com.intellij.spring.dom.SpringDomUtils;
import com.intellij.spring.model.utils.resources.SpringResourcesBuilder;
import com.intellij.spring.model.utils.resources.SpringResourcesUtil;
import com.intellij.spring.model.values.PlaceholderInfo;
import com.intellij.spring.model.values.PlaceholderPropertyReference;
import com.intellij.spring.model.xml.CustomBean;
import com.intellij.spring.model.xml.CustomBeanWrapper;
import com.intellij.spring.references.SpringBeanReference;
import com.intellij.util.ProcessingContext;
import com.intellij.util.xml.DomUtil;
import com.intellij.xml.util.XmlUtil;
import org.jetbrains.annotations.NotNull;

public class SpringReferenceContributor
extends PsiReferenceContributor {
    public void registerReferenceProviders(@NotNull PsiReferenceRegistrar registrar) {
        if (registrar == null) {
            SpringReferenceContributor.$$$reportNull$$$0(0);
        }
        SpringReferenceContributor.registerPsiClassReferences(registrar);
        SpringReferenceContributor.registerXmlContextReferenceProviders(registrar);
        SpringReferenceContributor.registerAnnoReferenceProviders(registrar);
    }

    private static void registerAnnoReferenceProviders(PsiReferenceRegistrar registrar) {
        registrar.registerReferenceProvider((ElementPattern)PsiJavaPatterns.literalExpression().annotationParam("org.springframework.scheduling.annotation.Async"), new PsiReferenceProvider(){

            @NotNull
            public PsiReference[] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context) {
                if (element == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (context == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (!(element instanceof PsiLiteralExpression)) {
                    if (PsiReference.EMPTY_ARRAY == null) {
                        1.$$$reportNull$$$0(2);
                    }
                    return PsiReference.EMPTY_ARRAY;
                }
                PsiClass executorClass = JavaPsiFacade.getInstance((Project)element.getProject()).findClass("java.util.concurrent.Executor", element.getResolveScope());
                PsiReference[] psiReferenceArray = new PsiReference[]{new SpringBeanReference(element, ElementManipulators.getValueTextRange((PsiElement)element), executorClass, false)};
                if (psiReferenceArray == null) {
                    1.$$$reportNull$$$0(3);
                }
                return psiReferenceArray;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 2: 
                    case 3: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 2: 
                    case 3: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "element";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "context";
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/spring/references/SpringReferenceContributor$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/spring/references/SpringReferenceContributor$1";
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getReferencesByElement";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "getReferencesByElement";
                        break;
                    }
                    case 2: 
                    case 3: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 2: 
                    case 3: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        }, 100.0);
    }

    private static void registerXmlContextReferenceProviders(PsiReferenceRegistrar registrar) {
        PropertiesReferenceProvider propertiesReferenceProvider = new PropertiesReferenceProvider(false);
        XmlUtil.registerXmlAttributeValueReferenceProvider((PsiReferenceRegistrar)registrar, (String[])new String[]{"code"}, (ElementFilter)new ScopeFilter((ElementFilter)new ParentElementFilter((ElementFilter)new AndFilter((ElementFilter)new NamespaceFilter(new String[]{"http://www.springframework.org/tags"}), (ElementFilter)new AndFilter((ElementFilter)XmlTagFilter.INSTANCE, (ElementFilter)new TextFilter("message", "theme"))), 2)), (PsiReferenceProvider)propertiesReferenceProvider);
        PatternCondition<XmlAttributeValue> customBeanPattern = new PatternCondition<XmlAttributeValue>("customBeanId"){

            public boolean accepts(@NotNull XmlAttributeValue attributeValue, ProcessingContext context) {
                CustomBeanWrapper element;
                if (attributeValue == null) {
                    2.$$$reportNull$$$0(0);
                }
                if ((element = (CustomBeanWrapper)DomUtil.findDomElement((PsiElement)attributeValue, CustomBeanWrapper.class)) == null) {
                    return false;
                }
                for (CustomBean customBean : element.getCustomBeans()) {
                    if (customBean.getIdAttribute() != attributeValue.getParent()) continue;
                    context.put((Object)"bean", (Object)customBean);
                    return true;
                }
                return false;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attributeValue", "com/intellij/spring/references/SpringReferenceContributor$2", "accepts"));
            }
        };
        registrar.registerReferenceProvider((ElementPattern)((XmlAttributeValuePattern)((XmlAttributeValuePattern)XmlPatterns.xmlAttributeValue().inVirtualFile((ElementPattern)PsiJavaPatterns.virtualFile().ofType((FileType)StdFileTypes.XML))).inFile((ElementPattern)PlatformPatterns.psiFile(XmlFile.class).with((PatternCondition)new PatternCondition<XmlFile>("isSpringXmlFile"){

            public boolean accepts(@NotNull XmlFile file, ProcessingContext context) {
                if (file == null) {
                    4.$$$reportNull$$$0(0);
                }
                return SpringDomUtils.isSpringXml(file);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/spring/references/SpringReferenceContributor$4", "accepts"));
            }
        }))).with((PatternCondition)customBeanPattern), new PsiReferenceProvider(){

            @NotNull
            public PsiReference[] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context) {
                if (element == null) {
                    3.$$$reportNull$$$0(0);
                }
                if (context == null) {
                    3.$$$reportNull$$$0(1);
                }
                CustomBean bean = (CustomBean)context.get((Object)"bean");
                PsiReference[] psiReferenceArray = new PsiReference[]{PsiReferenceBase.createSelfReference((PsiElement)element, (PsiElement)bean.getIdentifyingPsiElement())};
                if (psiReferenceArray == null) {
                    3.$$$reportNull$$$0(2);
                }
                return psiReferenceArray;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 2: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 2: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "element";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "context";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/spring/references/SpringReferenceContributor$3";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/spring/references/SpringReferenceContributor$3";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getReferencesByElement";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "getReferencesByElement";
                        break;
                    }
                    case 2: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 2: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        });
    }

    private static void registerPsiClassReferences(@NotNull PsiReferenceRegistrar registrar) {
        if (registrar == null) {
            SpringReferenceContributor.$$$reportNull$$$0(1);
        }
        PsiJavaElementPattern.Capture newExpressionCapture = PsiJavaPatterns.psiNewExpression((String[])new String[]{"org.springframework.context.support.ClassPathXmlApplicationContext", "org.springframework.core.io.ClassPathResource"});
        PsiJavaElementPattern.Capture capture = (PsiJavaElementPattern.Capture)PsiJavaPatterns.literalExpression().andOr(new ElementPattern[]{PsiJavaPatterns.psiExpression().withSuperParent(2, (ElementPattern)newExpressionCapture), PsiJavaPatterns.psiExpression().withSuperParent(4, (ElementPattern)newExpressionCapture)});
        registrar.registerReferenceProvider((ElementPattern)capture, (PsiReferenceProvider)new ClassPathResourceReferenceProvider());
        PsiJavaElementPattern.Capture elementPattern = (PsiJavaElementPattern.Capture)PsiJavaPatterns.literalExpression().and((ElementPattern)new FilterPattern((ElementFilter)new ParentElementFilter((ElementFilter)new PsiMethodCallFilter("org.springframework.core.env.PropertyResolver", new String[]{"getProperty"}), 2)));
        registrar.registerReferenceProvider((ElementPattern)elementPattern, new PsiReferenceProvider(){

            @NotNull
            public PsiReference[] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context) {
                if (element == null) {
                    5.$$$reportNull$$$0(0);
                }
                if (context == null) {
                    5.$$$reportNull$$$0(1);
                }
                PsiReference[] psiReferenceArray = new PsiReference[]{this.createPlaceholderReference(element)};
                if (psiReferenceArray == null) {
                    5.$$$reportNull$$$0(2);
                }
                return psiReferenceArray;
            }

            private PsiReference createPlaceholderReference(PsiElement element) {
                TextRange textRange = ElementManipulators.getValueTextRange((PsiElement)element);
                String text = ElementManipulators.getValueText((PsiElement)element);
                return PlaceholderPropertyReference.create(element, textRange, new PlaceholderInfo(text, (Pair<String, String>)Pair.create((Object)"", (Object)""), text, textRange));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 2: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 2: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "element";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "context";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/spring/references/SpringReferenceContributor$5";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/spring/references/SpringReferenceContributor$5";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getReferencesByElement";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "getReferencesByElement";
                        break;
                    }
                    case 2: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 2: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        }, 100.0);
        registrar.registerReferenceProvider((ElementPattern)PsiJavaPatterns.literalExpression().annotationParam((ElementPattern)PsiJavaPatterns.psiAnnotation().qName((ElementPattern)StandardPatterns.string().oneOf(new String[]{"org.springframework.beans.factory.annotation.Value"}))), (PsiReferenceProvider)new ClassPathResourceReferenceProvider(), 100.0);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "registrar";
        objectArray2[1] = "com/intellij/spring/references/SpringReferenceContributor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "registerReferenceProviders";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "registerPsiClassReferences";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class ClassPathResourceReferenceProvider
    extends PsiReferenceProvider {
        private ClassPathResourceReferenceProvider() {
        }

        @NotNull
        public PsiReference[] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context) {
            if (element == null) {
                ClassPathResourceReferenceProvider.$$$reportNull$$$0(0);
            }
            if (context == null) {
                ClassPathResourceReferenceProvider.$$$reportNull$$$0(1);
            }
            String s = ElementManipulators.getValueText((PsiElement)element);
            PsiReference[] psiReferenceArray = SpringResourcesUtil.getInstance().getClassPathReferences(SpringResourcesBuilder.create(element, s).fromRoot(s.startsWith("/")).soft(true));
            if (psiReferenceArray == null) {
                ClassPathResourceReferenceProvider.$$$reportNull$$$0(2);
            }
            return psiReferenceArray;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/spring/references/SpringReferenceContributor$ClassPathResourceReferenceProvider";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/spring/references/SpringReferenceContributor$ClassPathResourceReferenceProvider";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getReferencesByElement";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getReferencesByElement";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

