/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.profiles;

import com.intellij.CommonBundle;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.spring.CommonSpringModel;
import com.intellij.spring.SpringManager;
import com.intellij.spring.SpringModelVisitorUtils;
import com.intellij.spring.contexts.model.SpringModel;
import com.intellij.spring.facet.SpringFacet;
import com.intellij.spring.facet.SpringFileSet;
import com.intellij.spring.facet.SpringFileSetService;
import com.intellij.ui.CheckBoxList;
import com.intellij.ui.CheckBoxListListener;
import com.intellij.ui.ListSpeedSearch;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBRadioButton;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class ChangeActiveProfileDialog
extends DialogWrapper {
    @NotNull
    private final Project myProject;
    @Nullable
    private final Module myModule;
    @Nullable
    private final SpringModel mySpringModel;
    @Nullable
    private final SpringFileSet myFileSet;
    private JPanel myMainPanel;
    private JBRadioButton myProjectRadioButton;
    private JBRadioButton myModuleRadioButton;
    private JBRadioButton myContextRadioButton;
    private JBScrollPane myProfilesScrollPane;
    private CheckBoxList<ProfileEntry> myProfilesCheckBoxList;

    ChangeActiveProfileDialog(@NotNull Project project, @Nullable Module module, @Nullable SpringModel springModel) {
        if (project == null) {
            ChangeActiveProfileDialog.$$$reportNull$$$0(0);
        }
        super(project);
        this.myProject = project;
        this.myModule = module;
        this.mySpringModel = springModel;
        this.$$$setupUI$$$();
        this.myFileSet = springModel != null ? springModel.getFileSet() : null;
        this.setResizable(false);
        this.setTitle("Change Active Spring Profiles");
        this.setOKButtonText(CommonBundle.message((String)"button.apply", (Object[])new Object[0]));
        this.setOKActionEnabled(false);
        this.initScopeSelection();
        this.updateProfilesCheckBoxList();
        this.init();
        this.pack();
    }

    protected void doOKAction() {
        LinkedHashSet<String> activeProfiles = new LinkedHashSet<String>();
        for (int i = 0; i < this.myProfilesCheckBoxList.getItemsCount(); ++i) {
            if (!this.myProfilesCheckBoxList.isItemSelected(i)) continue;
            ProfileEntry entry = (ProfileEntry)this.myProfilesCheckBoxList.getItemAt(i);
            assert (entry != null);
            activeProfiles.add(entry.myName);
        }
        if (this.myContextRadioButton.isSelected() && this.myFileSet != null) {
            this.myFileSet.setActiveProfiles(activeProfiles);
        } else if (this.myModuleRadioButton.isSelected() && this.myModule != null) {
            ChangeActiveProfileDialog.setActiveProfilesForModule(this.myModule, activeProfiles);
        } else {
            for (Module module : ModuleManager.getInstance((Project)this.myProject).getModules()) {
                ChangeActiveProfileDialog.setActiveProfilesForModule(module, activeProfiles);
            }
        }
        super.doOKAction();
    }

    private static void setActiveProfilesForModule(Module module, Set<String> activeProfiles) {
        SpringFacet springFacet = SpringFacet.getInstance(module);
        if (springFacet == null) {
            return;
        }
        Set<SpringFileSet> sets = SpringFileSetService.getInstance().getAllSets(springFacet);
        for (SpringFileSet fileSet : sets) {
            fileSet.setActiveProfiles(activeProfiles);
        }
    }

    @Nullable
    protected String getHelpId() {
        return "change.active.spring.profiles";
    }

    @Nullable
    protected JComponent createCenterPanel() {
        return this.myMainPanel;
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        return this.myProfilesCheckBoxList;
    }

    private void initScopeSelection() {
        ActionListener updateProfilesListListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ChangeActiveProfileDialog.this.updateProfilesCheckBoxList();
            }
        };
        this.myProjectRadioButton.addActionListener(updateProfilesListListener);
        if (this.myModule == null) {
            this.myProjectRadioButton.setSelected(true);
            return;
        }
        this.myModuleRadioButton.setEnabled(true);
        this.myModuleRadioButton.addActionListener(updateProfilesListListener);
        this.myModuleRadioButton.setText("Module '" + this.myModule.getName() + "'");
        if (this.myFileSet == null) {
            this.myModuleRadioButton.setSelected(true);
            return;
        }
        this.myContextRadioButton.setEnabled(true);
        this.myContextRadioButton.addActionListener(updateProfilesListListener);
        this.myContextRadioButton.setText("Context '" + this.myFileSet.getName() + "'");
        this.myContextRadioButton.setSelected(true);
    }

    private void updateProfilesCheckBoxList() {
        List<ProfileEntry> profiles = this.getAllProfiles();
        Collections.sort(profiles, (o1, o2) -> StringUtil.naturalCompare((String)((ProfileEntry)o1).myName, (String)((ProfileEntry)o2).myName));
        this.myProfilesCheckBoxList.setItems(profiles, entry -> ((ProfileEntry)entry).myName);
        this.updateSelectedProfiles();
    }

    private void updateSelectedProfiles() {
        Set<Object> activeProfiles;
        if (this.myFileSet != null && this.myContextRadioButton.isSelected()) {
            activeProfiles = this.myFileSet.getActiveProfiles();
        } else if (this.myModule != null && this.myModuleRadioButton.isSelected()) {
            activeProfiles = SpringManager.getInstance(this.myProject).getCombinedModel(this.myModule).getActiveProfiles();
        } else {
            activeProfiles = ContainerUtil.newLinkedHashSet();
            for (Module module : ModuleManager.getInstance((Project)this.myProject).getModules()) {
                Set<String> profiles = SpringManager.getInstance(this.myProject).getCombinedModel(module).getActiveProfiles();
                if (profiles == null) continue;
                activeProfiles.addAll(profiles);
            }
        }
        this.updateActiveProfiles((Set<String>)activeProfiles);
    }

    private void updateActiveProfiles(@Nullable Set<String> activeProfiles) {
        for (int i = 0; i < this.myProfilesCheckBoxList.getItemsCount(); ++i) {
            ProfileEntry entry = (ProfileEntry)this.myProfilesCheckBoxList.getItemAt(i);
            assert (entry != null);
            this.myProfilesCheckBoxList.setItemSelected((Object)entry, activeProfiles != null && activeProfiles.contains(entry.myName));
        }
    }

    @NotNull
    private List<ProfileEntry> getAllProfiles() {
        HashSet<ProfileEntry> allProjectProfiles = new HashSet<ProfileEntry>();
        Set<String> myModelAllProfiles = this.mySpringModel == null ? Collections.emptySet() : ChangeActiveProfileDialog.getSanitizedProfileNames(this.mySpringModel);
        for (String modelProfile : myModelAllProfiles) {
            allProjectProfiles.add(new ProfileEntry(modelProfile, true));
        }
        for (Module module : ModuleManager.getInstance((Project)this.myProject).getModules()) {
            boolean available = this.myProjectRadioButton.isSelected() || this.myModuleRadioButton.isSelected() && module.equals(this.myModule);
            SpringModel combinedModel = SpringManager.getInstance(this.myProject).getCombinedModel(module);
            for (String profileName : ChangeActiveProfileDialog.getSanitizedProfileNames(combinedModel)) {
                if (myModelAllProfiles.contains(profileName)) continue;
                allProjectProfiles.add(new ProfileEntry(profileName, available));
            }
        }
        ArrayList<ProfileEntry> arrayList = new ArrayList<ProfileEntry>(allProjectProfiles);
        if (arrayList == null) {
            ChangeActiveProfileDialog.$$$reportNull$$$0(1);
        }
        return arrayList;
    }

    private static Set<String> getSanitizedProfileNames(CommonSpringModel model) {
        return ContainerUtil.map2SetNotNull(SpringModelVisitorUtils.getProfiles(model), s -> {
            if (s.equals("_DEFAULT_PROFILE_NAME_")) {
                return null;
            }
            return s.startsWith("!") ? s.substring(1) : s;
        });
    }

    private void createUIComponents() {
        this.myProfilesCheckBoxList = new CheckBoxList<ProfileEntry>(){

            protected JComponent adjustRendering(JComponent rootComponent, JCheckBox checkBox, int index, boolean selected, boolean hasFocus) {
                ProfileEntry profileEntry = (ProfileEntry)ChangeActiveProfileDialog.this.myProfilesCheckBoxList.getItemAt(index);
                assert (profileEntry != null);
                checkBox.setEnabled(profileEntry.myAvailable);
                return rootComponent;
            }
        };
        this.myProfilesCheckBoxList.setEmptyText("No profiles defined in selected scope");
        this.myProfilesCheckBoxList.setSelectionMode(2);
        this.myProfilesCheckBoxList.setBorder((Border)JBUI.Borders.empty());
        this.myProfilesCheckBoxList.setCheckBoxListListener(new CheckBoxListListener(){

            public void checkBoxSelectionChanged(int index, boolean value) {
                if (value) {
                    ProfileEntry entry = (ProfileEntry)ChangeActiveProfileDialog.this.myProfilesCheckBoxList.getItemAt(index);
                    assert (entry != null);
                    if (!entry.myAvailable) {
                        ChangeActiveProfileDialog.this.myProfilesCheckBoxList.setItemSelected((Object)entry, false);
                        return;
                    }
                }
                ChangeActiveProfileDialog.this.setOKActionEnabled(true);
            }
        });
        new ListSpeedSearch(this.myProfilesCheckBoxList, entry -> ((JCheckBox)entry).getText());
        this.myProfilesScrollPane = new JBScrollPane(this.myProfilesCheckBoxList, 20, 30);
        this.myProfilesScrollPane.setBorder((Border)JBUI.Borders.empty());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/profiles/ChangeActiveProfileDialog";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/profiles/ChangeActiveProfileDialog";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllProfiles";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JBRadioButton jBRadioButton;
        JBRadioButton jBRadioButton2;
        JBRadioButton jBRadioButton3;
        JPanel jPanel;
        this.createUIComponents();
        this.myMainPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(5, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(1, 2, 4, 1, 0, 1, 6, 1, null, null, null));
        this.myProjectRadioButton = jBRadioButton3 = new JBRadioButton();
        jBRadioButton3.setName("");
        jBRadioButton3.setText("Project");
        jPanel.add((Component)jBRadioButton3, new GridConstraints(1, 0, 1, 1, 8, 0, 3, 0, null, null, null, 1));
        this.myModuleRadioButton = jBRadioButton2 = new JBRadioButton();
        jBRadioButton2.setEnabled(false);
        jBRadioButton2.setText("Module");
        jPanel.add((Component)jBRadioButton2, new GridConstraints(2, 0, 1, 1, 8, 0, 3, 0, null, null, null, 1));
        this.myContextRadioButton = jBRadioButton = new JBRadioButton();
        jBRadioButton.setEnabled(false);
        jBRadioButton.setText("Context");
        jPanel.add((Component)jBRadioButton, new GridConstraints(3, 0, 1, 1, 8, 0, 3, 0, null, null, null, 1));
        JBLabel jBLabel = new JBLabel();
        jBLabel.setComponentStyle(UIUtil.ComponentStyle.SMALL);
        jBLabel.setText("Scope:");
        jPanel.add((Component)jBLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel.add((Component)spacer2, new GridConstraints(4, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        JBLabel jBLabel2 = new JBLabel();
        jBLabel2.setComponentStyle(UIUtil.ComponentStyle.SMALL);
        jBLabel2.setText("Profiles:");
        jPanel.add((Component)jBLabel2, new GridConstraints(0, 1, 1, 1, 8, 0, 0, 0, null, null, null, 1));
        JBScrollPane jBScrollPane = this.myProfilesScrollPane;
        jPanel.add((Component)jBScrollPane, new GridConstraints(1, 1, 4, 1, 9, 0, 3, 3, new Dimension(200, -1), null, null, 1));
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add((AbstractButton)jBRadioButton2);
        buttonGroup.add((AbstractButton)jBRadioButton3);
        buttonGroup.add((AbstractButton)jBRadioButton);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }

    private static class ProfileEntry {
        private final String myName;
        private final boolean myAvailable;

        private ProfileEntry(String name, boolean available) {
            this.myName = name;
            this.myAvailable = available;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ProfileEntry entry = (ProfileEntry)o;
            return this.myName.equals(entry.myName);
        }

        public int hashCode() {
            return this.myName.hashCode();
        }
    }
}

