/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.perspectives.diagrams;

import com.intellij.ProjectTopics;
import com.intellij.diagram.DiagramBuilder;
import com.intellij.diagram.DiagramEdge;
import com.intellij.diagram.DiagramNode;
import com.intellij.diagram.DiagramProvider;
import com.intellij.diagram.util.DiagramUtils;
import com.intellij.facet.ProjectWideFacetAdapter;
import com.intellij.facet.ProjectWideFacetListenersRegistry;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.psi.PsiManager;
import com.intellij.spring.CommonSpringModel;
import com.intellij.spring.SpringPresentationProvider;
import com.intellij.spring.facet.SpringFacet;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.spring.perspectives.diagrams.SpringDiagramBeansProcessingModel;
import com.intellij.spring.perspectives.diagrams.SpringDiagramCategoryManager;
import com.intellij.spring.perspectives.diagrams.beans.SpringBeanPointerWrapper;
import com.intellij.spring.perspectives.diagrams.beans.SpringElementWrapper;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.MessageHandler;
import com.intellij.util.xml.DomEventListener;
import com.intellij.util.xml.DomManager;
import com.intellij.util.xml.events.DomEvent;
import gnu.trove.THashSet;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpringDiagramDataModel
extends SpringDiagramBeansProcessingModel {
    private final SpringElementWrapper myElement;
    private final ProjectWideFacetAdapter<SpringFacet> myProjectWideFacetAdapter;

    public SpringDiagramDataModel(Project project, DiagramProvider<SpringElementWrapper> springBaseBeanPointerDiagramProvider, @Nullable SpringElementWrapper element) {
        super(project, springBaseBeanPointerDiagramProvider);
        this.myElement = element;
        DomEventListener domEventListener = new DomEventListener(){

            public void eventOccured(@NotNull DomEvent event) {
                if (event == null) {
                    1.$$$reportNull$$$0(0);
                }
                SpringDiagramDataModel.this.incModificationCount();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/spring/perspectives/diagrams/SpringDiagramDataModel$1", "eventOccured"));
            }
        };
        DomManager.getDomManager((Project)project).addDomEventListener(domEventListener, (Disposable)this);
        this.myProjectWideFacetAdapter = new ProjectWideFacetAdapter<SpringFacet>(){

            public void facetConfigurationChanged(@NotNull SpringFacet facet) {
                if (facet == null) {
                    2.$$$reportNull$$$0(0);
                }
                SpringDiagramDataModel.this.incModificationCount();
            }

            public void facetRemoved(@NotNull SpringFacet facet) {
                if (facet == null) {
                    2.$$$reportNull$$$0(1);
                }
                SpringDiagramDataModel.this.incModificationCount();
            }

            public void facetAdded(@NotNull SpringFacet facet) {
                if (facet == null) {
                    2.$$$reportNull$$$0(2);
                }
                SpringDiagramDataModel.this.incModificationCount();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "facet";
                objectArray2[1] = "com/intellij/spring/perspectives/diagrams/SpringDiagramDataModel$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "facetConfigurationChanged";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "facetRemoved";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "facetAdded";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        ProjectWideFacetListenersRegistry.getInstance((Project)this.getProject()).registerListener(SpringFacet.FACET_TYPE_ID, this.myProjectWideFacetAdapter, (Disposable)this);
        MessageBusConnection messageBusConnection = this.getProject().getMessageBus().connect((Disposable)this);
        messageBusConnection.setDefaultHandler(new MessageHandler(){

            public void handle(Method event, Object ... params) {
                SpringDiagramDataModel.this.incModificationCount();
            }
        });
        messageBusConnection.subscribe(ProjectTopics.PROJECT_ROOTS);
        messageBusConnection.subscribe(ProjectTopics.MODULES);
    }

    public void refreshDataModel() {
        if (DumbService.isDumb((Project)this.getProject())) {
            return;
        }
        this.clearAll();
        this.updateDataModel();
    }

    protected void updateDataModel() {
        CommonSpringModel applicationModel = this.getActualModel();
        if (applicationModel == null) {
            return;
        }
        Collection<SpringBeanPointer> pointers = applicationModel.getAllCommonBeans();
        THashSet pointerSet = new THashSet(pointers);
        for (SpringBeanPointer pointer : pointers) {
            DiagramNode<SpringElementWrapper> sourceNode = this.getOrCreateElement(pointer, applicationModel);
            if (sourceNode == null) continue;
            this.processDependencies(applicationModel, (Set<SpringBeanPointer>)pointerSet, pointer, sourceNode);
        }
        if (this.isSelectionMode()) {
            this.removeUnrelatedConnections();
        }
    }

    @Override
    protected CommonSpringModel getActualModel() {
        return this.getApplicationModel(this.getBuilder().getPresentation().isCategoryEnabled(SpringDiagramCategoryManager.LOCAL));
    }

    @Nullable
    public CommonSpringModel getApplicationModel(boolean isLocalModel) {
        return this.myElement == null ? null : this.myElement.getProcessingSpringModel(isLocalModel);
    }

    protected void removeUnrelatedConnections() {
        this.removeUnrelatedConnections(DiagramUtils.getSelectedNodes((DiagramBuilder)this.getBuilder()));
    }

    protected void removeUnrelatedConnections(@NotNull Collection<DiagramNode> selectedNodes) {
        if (selectedNodes == null) {
            SpringDiagramDataModel.$$$reportNull$$$0(0);
        }
        if (selectedNodes.isEmpty()) {
            return;
        }
        Set connections = this.getEdges().stream().filter(edge -> {
            if (selectedNodes == null) {
                SpringDiagramDataModel.$$$reportNull$$$0(4);
            }
            return selectedNodes.contains(edge.getSource()) || selectedNodes.contains(edge.getTarget());
        }).collect(Collectors.toSet());
        this.getEdges().clear();
        HashSet actualNodes = ContainerUtil.newHashSet();
        for (DiagramEdge connection : connections) {
            this.getEdges().add((DiagramEdge<SpringElementWrapper>)connection);
            actualNodes.add(connection.getSource());
            actualNodes.add(connection.getTarget());
        }
        this.getNodes().clear();
        for (DiagramNode node : selectedNodes) {
            this.getNodes().add((DiagramNode<SpringElementWrapper>)node);
        }
        this.getNodes().addAll(actualNodes);
    }

    protected boolean isSelectionMode() {
        return this.getBuilder().getPresentation().isCategoryEnabled(SpringDiagramCategoryManager.SELECTION_MODE);
    }

    @NotNull
    public ModificationTracker getModificationTracker() {
        SpringDiagramDataModel springDiagramDataModel = this;
        if (springDiagramDataModel == null) {
            SpringDiagramDataModel.$$$reportNull$$$0(1);
        }
        return springDiagramDataModel;
    }

    public void dispose() {
        ProjectWideFacetListenersRegistry.getInstance((Project)this.getProject()).unregisterListener(SpringFacet.FACET_TYPE_ID, this.myProjectWideFacetAdapter);
    }

    @Override
    public long getModificationCount() {
        return super.getModificationCount() + PsiManager.getInstance((Project)this.getProject()).getModificationTracker().getJavaStructureModificationCount();
    }

    @NotNull
    public String getNodeName(DiagramNode<SpringElementWrapper> n) {
        SpringElementWrapper identifyingElement = (SpringElementWrapper)n.getIdentifyingElement();
        if (identifyingElement instanceof SpringBeanPointerWrapper) {
            SpringBeanPointer beanPointer = (SpringBeanPointer)((SpringBeanPointerWrapper)identifyingElement).getWrapped();
            String string = beanPointer.isValid() ? SpringPresentationProvider.getSpringBeanName(beanPointer) : "";
            if (string == null) {
                SpringDiagramDataModel.$$$reportNull$$$0(2);
            }
            return string;
        }
        String string = identifyingElement.getName();
        if (string == null) {
            SpringDiagramDataModel.$$$reportNull$$$0(3);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selectedNodes";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/perspectives/diagrams/SpringDiagramDataModel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/perspectives/diagrams/SpringDiagramDataModel";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getModificationTracker";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getNodeName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "removeUnrelatedConnections";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "lambda$removeUnrelatedConnections$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

