/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.xml;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.spring.factories.CustomFactoryMethodTypeHandler;
import com.intellij.spring.factories.SpringFactoryBeansManager;
import com.intellij.spring.model.CommonSpringBean;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.spring.model.SpringProfile;
import com.intellij.spring.model.SpringQualifier;
import com.intellij.spring.model.xml.beans.Beans;
import com.intellij.spring.model.xml.beans.ConstructorArgDefinition;
import com.intellij.spring.model.xml.beans.ConstructorArgumentValues;
import com.intellij.spring.model.xml.beans.SpringBean;
import com.intellij.spring.model.xml.beans.SpringDomProfile;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomJavaUtil;
import com.intellij.util.xml.DomUtil;
import com.intellij.util.xml.GenericDomValue;
import com.intellij.util.xml.GenericValue;
import com.intellij.util.xml.NameValue;
import com.intellij.util.xml.converters.values.ClassValueConverter;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractDomSpringBean
implements CommonSpringBean {
    private CachedValue<PsiClass> myClassCachedValue;
    private CachedValue<PsiClass> myFactoriesClassCachedValue;

    @Override
    @NameValue
    @Nullable
    public abstract String getBeanName();

    @Nullable
    public GenericValue<PsiMethod> getFactoryMethod() {
        return null;
    }

    @Nullable
    public GenericValue<SpringBeanPointer> getFactoryBean() {
        return null;
    }

    @Nullable
    public abstract String getClassName();

    @Override
    @Nullable
    public final PsiType getBeanType() {
        PsiClass beanClass = this.getBeanClass(null, true);
        return beanClass != null ? PsiTypesUtil.getClassType((PsiClass)beanClass) : null;
    }

    @Override
    @Nullable
    public PsiType getBeanType(boolean considerFactories) {
        PsiClass beanClass = this.getBeanClass(null, considerFactories);
        return beanClass != null ? PsiTypesUtil.getClassType((PsiClass)beanClass) : null;
    }

    @Nullable
    public abstract Module getModule();

    @Override
    @NotNull
    public abstract PsiFile getContainingFile();

    @Nullable
    public PsiClass getBeanClass(@Nullable Set<AbstractDomSpringBean> visited, boolean considerFactories) {
        if (visited != null && visited.contains(this)) {
            return null;
        }
        if (considerFactories) {
            if (this.myFactoriesClassCachedValue == null) {
                this.myFactoriesClassCachedValue = CachedValuesManager.getManager((Project)this.getContainingFile().getProject()).createCachedValue(() -> {
                    PsiClass beanClass = AbstractDomSpringBean.calculateFactoriesBeanClass(this);
                    return CachedValueProvider.Result.createSingleDependency((Object)beanClass, (Object)PsiModificationTracker.JAVA_STRUCTURE_MODIFICATION_COUNT);
                });
            }
            return (PsiClass)this.myFactoriesClassCachedValue.getValue();
        }
        return this.getClassAttributeValue();
    }

    public PsiClass getClassAttributeValue() {
        if (this.myClassCachedValue == null) {
            this.myClassCachedValue = CachedValuesManager.getManager((Project)this.getContainingFile().getProject()).createCachedValue(() -> {
                PsiClass beanClass = AbstractDomSpringBean.calculateBeanClass(this);
                return CachedValueProvider.Result.createSingleDependency((Object)beanClass, (Object)PsiModificationTracker.JAVA_STRUCTURE_MODIFICATION_COUNT);
            });
        }
        return (PsiClass)this.myClassCachedValue.getValue();
    }

    @Nullable
    private static PsiClass calculateFactoriesBeanClass(@NotNull AbstractDomSpringBean springBean) {
        GenericValue<PsiMethod> value;
        PsiMethod factoryMethod;
        if (springBean == null) {
            AbstractDomSpringBean.$$$reportNull$$$0(0);
        }
        PsiMethod psiMethod = factoryMethod = (value = springBean.getFactoryMethod()) == null ? null : (PsiMethod)value.getValue();
        if (factoryMethod == null) {
            return AbstractDomSpringBean.calculateBeanClass(springBean);
        }
        GenericValue<SpringBeanPointer> factoryBean = springBean.getFactoryBean();
        if (!SpringFactoryBeansManager.getInstance().isValidFactoryMethod(factoryMethod, factoryBean != null && factoryBean.getValue() != null)) {
            return AbstractDomSpringBean.calculateBeanClass(springBean);
        }
        for (CustomFactoryMethodTypeHandler typeHandler : (CustomFactoryMethodTypeHandler[])CustomFactoryMethodTypeHandler.EP_NAME.getExtensions()) {
            PsiType factoryMethodType = typeHandler.getFactoryMethodType(factoryMethod, springBean);
            if (!(factoryMethodType instanceof PsiClassType)) continue;
            return ((PsiClassType)factoryMethodType).resolve();
        }
        PsiType returnType = factoryMethod.getReturnType();
        if (returnType instanceof PsiClassType) {
            PsiTypeParameter[] typeParameters = factoryMethod.getTypeParameters();
            PsiClass resolve = ((PsiClassType)returnType).resolve();
            if (resolve == null) {
                return null;
            }
            if (!(springBean instanceof SpringBean)) {
                return resolve;
            }
            for (PsiTypeParameter typeParameter : typeParameters) {
                if (!typeParameter.equals(resolve)) continue;
                String text = "java.lang.Class<" + typeParameter.getName() + ">";
                PsiParameter[] parameters = factoryMethod.getParameterList().getParameters();
                int length = parameters.length;
                for (int i = 0; i < length; ++i) {
                    String rawText;
                    PsiParameter psiParameter = parameters[i];
                    PsiType type = psiParameter.getType();
                    if (!type.getCanonicalText().equals(text)) continue;
                    ConstructorArgumentValues values = new ConstructorArgumentValues();
                    values.init((SpringBean)((Object)springBean));
                    ConstructorArgDefinition definition = values.resolve(i, psiParameter, null);
                    if (definition == null) continue;
                    GenericDomValue<?> valueElement = definition.getValueElement();
                    String string = rawText = valueElement == null ? null : valueElement.getRawText();
                    if (rawText == null) continue;
                    return DomJavaUtil.findClass((String)rawText, (PsiFile)springBean.getContainingFile(), (Module)springBean.getModule(), null);
                }
                return resolve;
            }
            return resolve;
        }
        return AbstractDomSpringBean.calculateBeanClass(springBean);
    }

    @Nullable
    private static PsiClass calculateBeanClass(@NotNull AbstractDomSpringBean springBean) {
        String className;
        if (springBean == null) {
            AbstractDomSpringBean.$$$reportNull$$$0(1);
        }
        if ((className = springBean.getClassName()) == null) {
            return null;
        }
        PsiFile containingFile = springBean.getContainingFile();
        GlobalSearchScope scope = ClassValueConverter.getScope((Project)containingFile.getProject(), (Module)springBean.getModule(), (PsiFile)containingFile);
        return DomJavaUtil.findClass((String)className.trim(), (PsiFile)containingFile, null, (GlobalSearchScope)scope);
    }

    @Override
    @NotNull
    public Collection<SpringQualifier> getSpringQualifiers() {
        Set<SpringQualifier> set = Collections.emptySet();
        if (set == null) {
            AbstractDomSpringBean.$$$reportNull$$$0(2);
        }
        return set;
    }

    @Override
    @NotNull
    public SpringProfile getProfile() {
        SpringDomProfile profile;
        Beans beans = this.getBeansParent();
        if (beans != null && DomUtil.hasXml((DomElement)(profile = beans.getProfile()))) {
            SpringDomProfile springDomProfile = profile;
            if (springDomProfile == null) {
                AbstractDomSpringBean.$$$reportNull$$$0(3);
            }
            return springDomProfile;
        }
        SpringProfile springProfile = SpringProfile.DEFAULT;
        if (springProfile == null) {
            AbstractDomSpringBean.$$$reportNull$$$0(4);
        }
        return springProfile;
    }

    @Nullable
    public abstract Beans getBeansParent();

    @Override
    public boolean isPrimary() {
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "springBean";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/model/xml/AbstractDomSpringBean";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/model/xml/AbstractDomSpringBean";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getSpringQualifiers";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getProfile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "calculateFactoriesBeanClass";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "calculateBeanClass";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

