/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.utils.search.executors;

import com.intellij.openapi.application.QueryExecutorBase;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.spring.index.SpringXmlBeansIndex;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.spring.model.utils.search.SpringBeanSearchParameters;
import com.intellij.spring.model.xml.beans.Alias;
import com.intellij.util.Processor;
import gnu.trove.THashSet;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public class XmlBeanNameQueryExecutor
extends QueryExecutorBase<SpringBeanPointer, SpringBeanSearchParameters.BeanName> {
    public static final XmlBeanNameQueryExecutor INSTANCE = new XmlBeanNameQueryExecutor();

    public void processQuery(@NotNull SpringBeanSearchParameters.BeanName params, @NotNull Processor<? super SpringBeanPointer> consumer) {
        if (params == null) {
            XmlBeanNameQueryExecutor.$$$reportNull$$$0(0);
        }
        if (consumer == null) {
            XmlBeanNameQueryExecutor.$$$reportNull$$$0(1);
        }
        XmlBeanNameQueryExecutor.processBeans(params, consumer, (Collection<String>)new THashSet(1));
    }

    private static boolean processBeans(@NotNull SpringBeanSearchParameters.BeanName params, @NotNull Processor<? super SpringBeanPointer> processor, @NotNull Collection<String> processed) {
        String beanName;
        if (params == null) {
            XmlBeanNameQueryExecutor.$$$reportNull$$$0(2);
        }
        if (processor == null) {
            XmlBeanNameQueryExecutor.$$$reportNull$$$0(3);
        }
        if (processed == null) {
            XmlBeanNameQueryExecutor.$$$reportNull$$$0(4);
        }
        if (processed.contains(beanName = params.getBeanName())) {
            return true;
        }
        processed.add(beanName);
        if (!SpringXmlBeansIndex.processBeansByName(params, processor)) {
            return false;
        }
        Processor aliasProcessor = alias -> {
            String aliasedBeanName;
            if (params == null) {
                XmlBeanNameQueryExecutor.$$$reportNull$$$0(5);
            }
            if (processor == null) {
                XmlBeanNameQueryExecutor.$$$reportNull$$$0(6);
            }
            if (processed == null) {
                XmlBeanNameQueryExecutor.$$$reportNull$$$0(7);
            }
            return !StringUtil.isNotEmpty((String)(aliasedBeanName = alias.getAliasedBean().getStringValue())) || XmlBeanNameQueryExecutor.processBeans(XmlBeanNameQueryExecutor.copyFrom(params, aliasedBeanName), processor, processed);
        };
        return SpringXmlBeansIndex.processAliases(params, (Processor<? super Alias>)aliasProcessor);
    }

    private static SpringBeanSearchParameters.BeanName copyFrom(SpringBeanSearchParameters.BeanName params, String aliasedBeanName) {
        SpringBeanSearchParameters.BeanName wrappedParams = SpringBeanSearchParameters.byName(params.getProject(), aliasedBeanName);
        wrappedParams.setSearchScope(params.getSearchScope());
        wrappedParams.setVirtualFile(params.getVirtualFile());
        return wrappedParams;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "params";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processed";
                break;
            }
        }
        objectArray2[1] = "com/intellij/spring/model/utils/search/executors/XmlBeanNameQueryExecutor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "processQuery";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "processBeans";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$processBeans$0";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

