/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.utils.search.executors;

import com.intellij.openapi.application.QueryExecutorBase;
import com.intellij.spring.index.SpringXmlBeansIndex;
import com.intellij.spring.model.BeanService;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.spring.model.utils.search.SpringBeanSearchParameters;
import com.intellij.spring.model.xml.CustomBean;
import com.intellij.spring.model.xml.CustomBeanWrapper;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public abstract class CustomBeanWrappersQueryExecutor<Params extends SpringBeanSearchParameters>
extends QueryExecutorBase<SpringBeanPointer, Params> {
    public final void processQuery(@NotNull Params params, @NotNull Processor<? super SpringBeanPointer> consumer) {
        if (params == null) {
            CustomBeanWrappersQueryExecutor.$$$reportNull$$$0(0);
        }
        if (consumer == null) {
            CustomBeanWrappersQueryExecutor.$$$reportNull$$$0(1);
        }
        CommonProcessors.CollectProcessor collectProcessor = new CommonProcessors.CollectProcessor();
        SpringXmlBeansIndex.processCustomBeans(params, (Processor<? super CustomBeanWrapper>)collectProcessor);
        for (CustomBeanWrapper customBeanWrapper : collectProcessor.getResults()) {
            if (this.processCustomBeanWrapper(params, consumer, customBeanWrapper)) continue;
            return;
        }
    }

    private boolean processCustomBeanWrapper(@NotNull Params params, @NotNull Processor<? super SpringBeanPointer> consumer, @NotNull CustomBeanWrapper wrapper) {
        if (params == null) {
            CustomBeanWrappersQueryExecutor.$$$reportNull$$$0(2);
        }
        if (consumer == null) {
            CustomBeanWrappersQueryExecutor.$$$reportNull$$$0(3);
        }
        if (wrapper == null) {
            CustomBeanWrappersQueryExecutor.$$$reportNull$$$0(4);
        }
        List<CustomBean> customBeans = wrapper.getCustomBeans();
        for (CustomBean bean : customBeans) {
            if (!this.accept(params, bean) || !bean.isValid() || consumer.process((Object)BeanService.getInstance().createSpringBeanPointer(bean))) continue;
            return false;
        }
        return !this.acceptWrapper(params, wrapper) || consumer.process((Object)BeanService.getInstance().createSpringBeanPointer(wrapper));
    }

    protected abstract boolean accept(@NotNull Params var1, @NotNull CustomBean var2);

    protected abstract boolean acceptWrapper(@NotNull Params var1, @NotNull CustomBeanWrapper var2);

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "params";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "wrapper";
                break;
            }
        }
        objectArray2[1] = "com/intellij/spring/model/utils/search/executors/CustomBeanWrappersQueryExecutor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "processQuery";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "processCustomBeanWrapper";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class BeanName
    extends CustomBeanWrappersQueryExecutor<SpringBeanSearchParameters.BeanName> {
        public static final BeanName INSTANCE = new BeanName();

        @Override
        protected boolean accept(@NotNull SpringBeanSearchParameters.BeanName parameters, @NotNull CustomBean bean) {
            if (parameters == null) {
                BeanName.$$$reportNull$$$0(0);
            }
            if (bean == null) {
                BeanName.$$$reportNull$$$0(1);
            }
            return parameters.getBeanName().equals(bean.getBeanName());
        }

        @Override
        protected boolean acceptWrapper(@NotNull SpringBeanSearchParameters.BeanName parameters, @NotNull CustomBeanWrapper bean) {
            if (parameters == null) {
                BeanName.$$$reportNull$$$0(2);
            }
            if (bean == null) {
                BeanName.$$$reportNull$$$0(3);
            }
            return parameters.getBeanName().equals(bean.getBeanName());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parameters";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "bean";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/spring/model/utils/search/executors/CustomBeanWrappersQueryExecutor$BeanName";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "accept";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "acceptWrapper";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class AllWrappers
    extends CustomBeanWrappersQueryExecutor<SpringBeanSearchParameters.BeanName> {
        public static final AllWrappers INSTANCE = new AllWrappers();

        @Override
        protected boolean accept(@NotNull SpringBeanSearchParameters.BeanName name, @NotNull CustomBean bean) {
            if (name == null) {
                AllWrappers.$$$reportNull$$$0(0);
            }
            if (bean == null) {
                AllWrappers.$$$reportNull$$$0(1);
            }
            return false;
        }

        @Override
        protected boolean acceptWrapper(@NotNull SpringBeanSearchParameters.BeanName name, @NotNull CustomBeanWrapper bean) {
            if (name == null) {
                AllWrappers.$$$reportNull$$$0(2);
            }
            if (bean == null) {
                AllWrappers.$$$reportNull$$$0(3);
            }
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "bean";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/spring/model/utils/search/executors/CustomBeanWrappersQueryExecutor$AllWrappers";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "accept";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "acceptWrapper";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class BeanClass
    extends CustomBeanWrappersQueryExecutor<SpringBeanSearchParameters.BeanClass> {
        public static final BeanClass INSTANCE = new BeanClass();

        @Override
        protected boolean accept(@NotNull SpringBeanSearchParameters.BeanClass parameters, @NotNull CustomBean bean) {
            if (parameters == null) {
                BeanClass.$$$reportNull$$$0(0);
            }
            if (bean == null) {
                BeanClass.$$$reportNull$$$0(1);
            }
            return parameters.matchesClass(bean.getBeanType());
        }

        @Override
        protected boolean acceptWrapper(@NotNull SpringBeanSearchParameters.BeanClass aClass, @NotNull CustomBeanWrapper bean) {
            if (aClass == null) {
                BeanClass.$$$reportNull$$$0(2);
            }
            if (bean == null) {
                BeanClass.$$$reportNull$$$0(3);
            }
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parameters";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "bean";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "aClass";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/spring/model/utils/search/executors/CustomBeanWrappersQueryExecutor$BeanClass";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "accept";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "acceptWrapper";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

