/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.utils;

import com.intellij.codeInsight.MetaAnnotationUtil;
import com.intellij.jam.JamService;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleFileIndex;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlFile;
import com.intellij.spring.CommonSpringModel;
import com.intellij.spring.SpringLocalModelFactory;
import com.intellij.spring.SpringManager;
import com.intellij.spring.SpringModelVisitorUtils;
import com.intellij.spring.contexts.model.CombinedSpringModel;
import com.intellij.spring.contexts.model.CombinedSpringModelImpl;
import com.intellij.spring.contexts.model.LocalAnnotationModel;
import com.intellij.spring.contexts.model.SpringModel;
import com.intellij.spring.dom.SpringDomUtils;
import com.intellij.spring.facet.SpringFileSetService;
import com.intellij.spring.impl.SpringAutoConfiguredModels;
import com.intellij.spring.model.CommonSpringBean;
import com.intellij.spring.model.SpringModelSearchParameters;
import com.intellij.spring.model.jam.testContexts.ContextConfiguration;
import com.intellij.spring.model.jam.testContexts.SpringTestContextUtil;
import com.intellij.spring.model.utils.SpringCommonUtils;
import com.intellij.spring.model.utils.SpringModelSearchers;
import com.intellij.spring.model.utils.SpringModelUtils;
import com.intellij.spring.model.xml.SpringModelElement;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomUtil;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UastUtils;

public class SpringModelUtilsImpl
extends SpringModelUtils {
    @Override
    @NotNull
    public CommonSpringModel getSpringModel(@NotNull SpringModelElement modelElement) {
        Project project;
        SpringModel file;
        if (modelElement == null) {
            SpringModelUtilsImpl.$$$reportNull$$$0(0);
        }
        CommonSpringModel commonSpringModel = (file = SpringManager.getInstance(project = modelElement.getManager().getProject()).getSpringModelByFile((PsiFile)DomUtil.getFile((DomElement)modelElement))) != null ? file : SpringModel.UNKNOWN;
        if (commonSpringModel == null) {
            SpringModelUtilsImpl.$$$reportNull$$$0(1);
        }
        return commonSpringModel;
    }

    @Override
    @NotNull
    public CommonSpringModel getSpringModel(@Nullable PsiElement element) {
        if (element == null) {
            CommonSpringModel commonSpringModel = SpringModel.UNKNOWN;
            if (commonSpringModel == null) {
                SpringModelUtilsImpl.$$$reportNull$$$0(2);
            }
            return commonSpringModel;
        }
        if (element instanceof XmlElement) {
            SpringModel modelForFile;
            PsiFile file = element.getContainingFile();
            if (file instanceof XmlFile && SpringDomUtils.isSpringXml((XmlFile)file) && (modelForFile = SpringManager.getInstance(element.getProject()).getSpringModelByFile(file)) != null) {
                SpringModel springModel = modelForFile;
                if (springModel == null) {
                    SpringModelUtilsImpl.$$$reportNull$$$0(3);
                }
                return springModel;
            }
        } else {
            UClass psiClass = (UClass)UastUtils.findContaining((PsiElement)element, UClass.class);
            if (psiClass != null) {
                CommonSpringModel commonSpringModel = this.getPsiClassSpringModel(psiClass.getJavaPsi());
                if (commonSpringModel == null) {
                    SpringModelUtilsImpl.$$$reportNull$$$0(4);
                }
                return commonSpringModel;
            }
        }
        CommonSpringModel commonSpringModel = this.getModuleCombinedSpringModel(element);
        if (commonSpringModel == null) {
            SpringModelUtilsImpl.$$$reportNull$$$0(5);
        }
        return commonSpringModel;
    }

    @Override
    @NotNull
    public CommonSpringModel getPsiClassSpringModel(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            SpringModelUtilsImpl.$$$reportNull$$$0(6);
        }
        if (!psiClass.isValid()) {
            CommonSpringModel commonSpringModel = SpringModel.UNKNOWN;
            if (commonSpringModel == null) {
                SpringModelUtilsImpl.$$$reportNull$$$0(7);
            }
            return commonSpringModel;
        }
        if (SpringTestContextUtil.getInstance().isTestContextConfigurationClass(psiClass)) {
            CommonSpringModel commonSpringModel = SpringTestContextUtil.getInstance().getSpringTestingModel(psiClass);
            if (commonSpringModel == null) {
                SpringModelUtilsImpl.$$$reportNull$$$0(8);
            }
            return commonSpringModel;
        }
        if (SpringCommonUtils.isConfigurationOrMeta(psiClass)) {
            CommonSpringModel commonSpringModel = this.getAnnoConfigurationSpringModel(psiClass);
            if (commonSpringModel == null) {
                SpringModelUtilsImpl.$$$reportNull$$$0(9);
            }
            return commonSpringModel;
        }
        VirtualFile virtualFile = psiClass.getContainingFile().getOriginalFile().getVirtualFile();
        if (virtualFile == null || virtualFile.getFileSystem() instanceof JarFileSystem) {
            Project project = psiClass.getProject();
            CombinedSpringModel combinedSpringModel = SpringModelUtilsImpl.getCombinedModelForProject(project);
            if (combinedSpringModel == null) {
                SpringModelUtilsImpl.$$$reportNull$$$0(10);
            }
            return combinedSpringModel;
        }
        CommonSpringModel commonSpringModel = this.getModuleCombinedSpringModel((PsiElement)psiClass);
        if (commonSpringModel == null) {
            SpringModelUtilsImpl.$$$reportNull$$$0(11);
        }
        return commonSpringModel;
    }

    @NotNull
    private CommonSpringModel getAnnoConfigurationSpringModel(@NotNull PsiClass psiClass) {
        SpringModelSearchParameters.BeanClass params;
        CommonSpringModel springModel;
        if (psiClass == null) {
            SpringModelUtilsImpl.$$$reportNull$$$0(12);
        }
        if (SpringModelSearchers.doesBeanExist(springModel = this.getModuleCombinedSpringModel((PsiElement)psiClass), params = SpringModelSearchParameters.byClass(psiClass))) {
            CommonSpringModel commonSpringModel = springModel;
            if (commonSpringModel == null) {
                SpringModelUtilsImpl.$$$reportNull$$$0(13);
            }
            return commonSpringModel;
        }
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)psiClass);
        if (module == null) {
            CommonSpringModel commonSpringModel = SpringModel.UNKNOWN;
            if (commonSpringModel == null) {
                SpringModelUtilsImpl.$$$reportNull$$$0(14);
            }
            return commonSpringModel;
        }
        LocalAnnotationModel model = SpringLocalModelFactory.getInstance().getOrCreateLocalAnnotationModel(psiClass, module, Collections.emptySet());
        CommonSpringModel commonSpringModel = model != null ? model : SpringModel.UNKNOWN;
        if (commonSpringModel == null) {
            SpringModelUtilsImpl.$$$reportNull$$$0(15);
        }
        return commonSpringModel;
    }

    @Override
    @NotNull
    public CommonSpringModel getModuleCombinedSpringModel(@NotNull PsiElement element) {
        Module module;
        if (element == null) {
            SpringModelUtilsImpl.$$$reportNull$$$0(16);
        }
        if ((module = ModuleUtilCore.findModuleForPsiElement((PsiElement)element)) == null || module.isDisposed()) {
            CommonSpringModel commonSpringModel = SpringModel.UNKNOWN;
            if (commonSpringModel == null) {
                SpringModelUtilsImpl.$$$reportNull$$$0(17);
            }
            return commonSpringModel;
        }
        SpringModel springModel = SpringManager.getInstance(module.getProject()).getCombinedModel(module);
        if (springModel == null) {
            SpringModelUtilsImpl.$$$reportNull$$$0(18);
        }
        return springModel;
    }

    @Override
    @NotNull
    public CommonSpringModel getSpringModelByBean(@Nullable CommonSpringBean springBean) {
        if (springBean == null) {
            CommonSpringModel commonSpringModel = SpringModel.UNKNOWN;
            if (commonSpringModel == null) {
                SpringModelUtilsImpl.$$$reportNull$$$0(19);
            }
            return commonSpringModel;
        }
        if (springBean instanceof SpringModelElement) {
            CommonSpringModel commonSpringModel = this.getSpringModel((SpringModelElement)((Object)springBean));
            if (commonSpringModel == null) {
                SpringModelUtilsImpl.$$$reportNull$$$0(20);
            }
            return commonSpringModel;
        }
        Module module = springBean.getModule();
        if (module != null) {
            SpringModel springModel = SpringManager.getInstance(module.getProject()).getCombinedModel(module);
            if (springModel == null) {
                SpringModelUtilsImpl.$$$reportNull$$$0(21);
            }
            return springModel;
        }
        CommonSpringModel commonSpringModel = SpringModel.UNKNOWN;
        if (commonSpringModel == null) {
            SpringModelUtilsImpl.$$$reportNull$$$0(22);
        }
        return commonSpringModel;
    }

    @Override
    public boolean isTestContext(Module module, PsiFile file) {
        for (PsiClass contextConfigurationAnno : MetaAnnotationUtil.getAnnotationTypesWithChildren((Module)module, (String)"org.springframework.test.context.ContextConfiguration", (boolean)true)) {
            String qualifiedName = contextConfigurationAnno.getQualifiedName();
            if (StringUtil.isEmptyOrSpaces((String)qualifiedName)) continue;
            List configurations = JamService.getJamService((Project)module.getProject()).getJamClassElements(ContextConfiguration.CONTEXT_CONFIGURATION_JAM_KEY, qualifiedName, GlobalSearchScope.moduleScope((Module)module));
            for (ContextConfiguration configuration : configurations) {
                CommonSpringModel model = SpringTestContextUtil.getInstance().getSpringTestingModel(configuration.getPsiElement());
                if (!SpringModelVisitorUtils.hasConfigFile(model, file)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isUsedConfigurationFile(@NotNull PsiFile configurationFile, boolean checkTestFiles) {
        Project project;
        if (configurationFile == null) {
            SpringModelUtilsImpl.$$$reportNull$$$0(23);
        }
        if (DumbService.isDumb((Project)(project = configurationFile.getProject()))) {
            return false;
        }
        VirtualFile virtualFile = configurationFile.getVirtualFile();
        if (virtualFile == null) {
            return false;
        }
        Module module = ModuleUtilCore.findModuleForFile((VirtualFile)virtualFile, (Project)project);
        if (module == null) {
            return false;
        }
        ModuleFileIndex moduleFileIndex = ModuleRootManager.getInstance((Module)module).getFileIndex();
        if (!moduleFileIndex.isInContent(virtualFile)) {
            return false;
        }
        if (!checkTestFiles && moduleFileIndex.isInTestSourceContent(virtualFile)) {
            return true;
        }
        Ref result = Ref.create((Object)Boolean.FALSE);
        ModuleUtilCore.visitMeAndDependentModules((Module)module, depModule -> {
            if (configurationFile == null) {
                SpringModelUtilsImpl.$$$reportNull$$$0(25);
            }
            boolean found = SpringFileSetService.getInstance().findFileSet(depModule, configurationFile) != null || checkTestFiles && this.isTestContext(depModule, configurationFile);
            result.set((Object)found);
            return !found;
        });
        return (Boolean)result.get();
    }

    @NotNull
    private static CombinedSpringModel getCombinedModelForProject(Project project) {
        LinkedHashSet allCombinedModels = ContainerUtil.newLinkedHashSet();
        for (Module module : ModuleManager.getInstance((Project)project).getModules()) {
            Set<SpringModel> allModels = SpringManager.getInstance(project).getAllModelsWithoutDependencies(module);
            allCombinedModels.addAll(allModels);
        }
        CombinedSpringModelImpl combinedSpringModelImpl = new CombinedSpringModelImpl(allCombinedModels, null);
        if (combinedSpringModelImpl == null) {
            SpringModelUtilsImpl.$$$reportNull$$$0(24);
        }
        return combinedSpringModelImpl;
    }

    @Override
    public boolean hasAutoConfiguredModels(@Nullable Module module) {
        return module != null && SpringAutoConfiguredModels.hasAutoConfiguredModels(module);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 24: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 24: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modelElement";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/model/utils/SpringModelUtilsImpl";
                break;
            }
            case 6: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiClass";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 23: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configurationFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/model/utils/SpringModelUtilsImpl";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getSpringModel";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getPsiClassSpringModel";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getAnnoConfigurationSpringModel";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getModuleCombinedSpringModel";
                break;
            }
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getSpringModelByBean";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getCombinedModelForProject";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getSpringModel";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 24: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getPsiClassSpringModel";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getAnnoConfigurationSpringModel";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getModuleCombinedSpringModel";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "isUsedConfigurationFile";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "lambda$isUsedConfigurationFile$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 24: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

