/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.utils;

import com.intellij.codeInsight.AnnotationTargetUtil;
import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInsight.MetaAnnotationUtil;
import com.intellij.jam.JamService;
import com.intellij.jam.model.util.JamCommonUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiConstantEvaluationHelper;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.impl.cache.CacheManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.AnnotatedMembersSearch;
import com.intellij.psi.util.ClassUtil;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PropertyUtilBase;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.spring.CommonSpringModel;
import com.intellij.spring.SpringLibraryUtil;
import com.intellij.spring.SpringManager;
import com.intellij.spring.SpringModelVisitorUtils;
import com.intellij.spring.contexts.model.CombinedSpringModel;
import com.intellij.spring.contexts.model.CombinedSpringModelImpl;
import com.intellij.spring.contexts.model.SpringModel;
import com.intellij.spring.facet.SpringFileSet;
import com.intellij.spring.model.CommonSpringBean;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.spring.model.SpringImplicitBeanMarker;
import com.intellij.spring.model.SpringModelSearchParameters;
import com.intellij.spring.model.SpringObjectFactoryEffectiveTypeProvider;
import com.intellij.spring.model.highlighting.xml.SpringConstructorArgResolveUtil;
import com.intellij.spring.model.jam.javaConfig.ContextJavaBean;
import com.intellij.spring.model.jam.qualifiers.SpringJamQualifier;
import com.intellij.spring.model.jam.testContexts.SpringTestContextUtil;
import com.intellij.spring.model.jam.utils.JamAnnotationTypeUtil;
import com.intellij.spring.model.utils.ExplicitRedefinitionAwareBeansCollector;
import com.intellij.spring.model.utils.SpringBeanCoreUtils;
import com.intellij.spring.model.utils.SpringBeanUtils;
import com.intellij.spring.model.utils.SpringCommonUtils;
import com.intellij.spring.model.utils.SpringConstructorArgUtils;
import com.intellij.spring.model.utils.SpringModelSearchers;
import com.intellij.spring.model.utils.SpringModelUtils;
import com.intellij.spring.model.utils.SpringPropertyUtils;
import com.intellij.spring.model.xml.beans.Autowire;
import com.intellij.spring.model.xml.beans.Beans;
import com.intellij.spring.model.xml.beans.ConstructorArg;
import com.intellij.spring.model.xml.beans.DefaultableBoolean;
import com.intellij.spring.model.xml.beans.SpringBean;
import com.intellij.spring.model.xml.beans.SpringProperty;
import com.intellij.spring.model.xml.beans.SpringPropertyDefinition;
import com.intellij.spring.model.xml.beans.SpringValue;
import com.intellij.spring.references.SpringBeanReference;
import com.intellij.util.ArrayUtil;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Function;
import com.intellij.util.NullableFunction;
import com.intellij.util.Processor;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.DomService;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpringAutowireUtil {
    private static final Set<String> AUTOWIRED_ANNOTATIONS = Collections.unmodifiableSet(new LinkedHashSet<String>(Arrays.asList("org.springframework.beans.factory.annotation.Autowired", "javax.inject.Inject", "javax.annotation.Resource")));
    @NonNls
    private static final Set<String> STANDARD_AUTOWIRED_TYPES = ContainerUtil.immutableSet((Object[])new String[]{"org.springframework.beans.factory.BeanFactory", "org.springframework.context.ApplicationContext", "org.springframework.context.ApplicationEventPublisher", "org.springframework.context.MessageSource", "org.springframework.core.io.ResourceLoader", "org.springframework.core.env.Environment"});

    protected SpringAutowireUtil() {
    }

    public static Map<PsiMethod, Collection<SpringBeanPointer>> getByTypeAutowiredProperties(SpringBean springBean, CommonSpringModel model) {
        HashMap<PsiMethod, Collection<SpringBeanPointer>> autowiredMap = new HashMap<PsiMethod, Collection<SpringBeanPointer>>();
        PsiClass beanClass = PsiTypesUtil.getPsiClass((PsiType)springBean.getBeanType());
        if (beanClass != null && model != null && SpringAutowireUtil.isByTypeAutowired(springBean)) {
            for (PsiMethod psiMethod : beanClass.getAllMethods()) {
                if (!SpringAutowireUtil.isPropertyAutowired(psiMethod, springBean)) continue;
                PsiParameter parameter = psiMethod.getParameterList().getParameters()[0];
                HashSet list = ContainerUtil.newHashSet();
                PsiAnnotation qualifiedAnnotation = SpringAutowireUtil.getQualifiedAnnotation((PsiModifierListOwner)psiMethod);
                if (qualifiedAnnotation != null) {
                    list.addAll(SpringAutowireUtil.getQualifiedBeans(qualifiedAnnotation, model));
                } else {
                    list.addAll(SpringAutowireUtil.autowireByType(model, parameter.getType(), parameter.getName()));
                    list.addAll(SpringAutowireUtil.autowireByType(model, SpringAutowireUtil.getAutowiredEffectiveBeanTypes(parameter.getType()), parameter.getName()));
                }
                if (list.size() <= 0) continue;
                autowiredMap.put(psiMethod, list);
            }
        }
        return autowiredMap;
    }

    @NotNull
    public static Set<SpringBeanPointer> excludeAutowireCandidates(@NotNull List<SpringBeanPointer> beans, @Nullable CommonSpringModel model) {
        if (beans == null) {
            SpringAutowireUtil.$$$reportNull$$$0(0);
        }
        Set<SpringBeanPointer> set = SpringAutowireUtil.excludeAutowireCandidates(beans, null, model);
        if (set == null) {
            SpringAutowireUtil.$$$reportNull$$$0(1);
        }
        return set;
    }

    @NotNull
    public static Set<SpringBeanPointer> excludeAutowireCandidates(@NotNull Collection<SpringBeanPointer> beans, @Nullable String primaryCandidateName, @Nullable CommonSpringModel model) {
        Collection<SpringBeanPointer> primaryBeans;
        if (beans == null) {
            SpringAutowireUtil.$$$reportNull$$$0(2);
        }
        LinkedHashSet<SpringBeanPointer> pointers = new LinkedHashSet<SpringBeanPointer>();
        Collection<SpringBeanPointer> collection = primaryBeans = beans.size() > 1 ? SpringAutowireUtil.getPrimaryBeans(beans, primaryCandidateName, model) : beans;
        if (!primaryBeans.isEmpty()) {
            for (SpringBeanPointer primaryBean : primaryBeans) {
                if (!SpringAutowireUtil.isAutowireCandidate(primaryBean)) continue;
                pointers.add(primaryBean);
            }
            LinkedHashSet<SpringBeanPointer> linkedHashSet = pointers;
            if (linkedHashSet == null) {
                SpringAutowireUtil.$$$reportNull$$$0(3);
            }
            return linkedHashSet;
        }
        for (SpringBeanPointer beanPointer : beans) {
            if (!SpringAutowireUtil.isAutowireCandidate(beanPointer)) continue;
            pointers.add(beanPointer);
        }
        LinkedHashSet<SpringBeanPointer> linkedHashSet = pointers;
        if (linkedHashSet == null) {
            SpringAutowireUtil.$$$reportNull$$$0(4);
        }
        return linkedHashSet;
    }

    @NotNull
    private static List<SpringBeanPointer> getPrimaryBeans(@NotNull Collection<? extends SpringBeanPointer> beans, @Nullable String primaryCandidateName, @Nullable CommonSpringModel model) {
        if (beans == null) {
            SpringAutowireUtil.$$$reportNull$$$0(5);
        }
        if (primaryCandidateName == null) {
            List<SpringBeanPointer> list = SpringAutowireUtil.emptyList();
            if (list == null) {
                SpringAutowireUtil.$$$reportNull$$$0(6);
            }
            return list;
        }
        SmartList byPrimary = new SmartList();
        SmartList byName = new SmartList();
        for (SpringBeanPointer springBeanPointer : beans) {
            if (!springBeanPointer.isValid()) continue;
            Object springBean = springBeanPointer.getSpringBean();
            if (springBean.isPrimary()) {
                if (SpringAutowireUtil.isMyName(primaryCandidateName, springBeanPointer, model)) {
                    List<SpringBeanPointer> list = Collections.singletonList(springBeanPointer);
                    if (list == null) {
                        SpringAutowireUtil.$$$reportNull$$$0(7);
                    }
                    return list;
                }
                byPrimary.add(springBeanPointer);
                continue;
            }
            if (!SpringAutowireUtil.isMyName(primaryCandidateName, springBeanPointer, model)) continue;
            byName.add(springBeanPointer);
        }
        SmartList smartList = byPrimary.isEmpty() ? byName : byPrimary;
        if (smartList == null) {
            SpringAutowireUtil.$$$reportNull$$$0(8);
        }
        return smartList;
    }

    private static boolean isMyName(@Nullable String name, @NotNull SpringBeanPointer springBeanPointer, @Nullable CommonSpringModel model) {
        if (springBeanPointer == null) {
            SpringAutowireUtil.$$$reportNull$$$0(9);
        }
        if (name == null) {
            return false;
        }
        String beanName = springBeanPointer.getName();
        if (name.equals(beanName)) {
            return true;
        }
        if (beanName != null && model != null) {
            for (String aliasName : SpringModelVisitorUtils.getAllBeanNames(model, springBeanPointer)) {
                if (!name.equals(aliasName)) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean isAutowireCandidate(@Nullable SpringBeanPointer pointer) {
        if (pointer == null || !pointer.isValid()) {
            return false;
        }
        Object springBean = pointer.getSpringBean();
        if (!(springBean instanceof SpringBean)) {
            return true;
        }
        if (((SpringBean)springBean).isAbstract()) {
            return false;
        }
        DefaultableBoolean autoWireCandidate = (DefaultableBoolean)((Object)((SpringBean)springBean).getAutowireCandidate().getValue());
        return (autoWireCandidate == null || autoWireCandidate.getBooleanValue() != false) && SpringAutowireUtil.isDefaultAutowireCandidate(springBean);
    }

    private static boolean isDefaultAutowireCandidate(CommonSpringBean springBean) {
        String autowireCandidates;
        Beans beans;
        if (springBean instanceof SpringBean && (beans = (Beans)((SpringBean)springBean).getParentOfType(Beans.class, false)) != null && StringUtil.isNotEmpty((String)(autowireCandidates = (String)beans.getDefaultAutowireCandidates().getValue()))) {
            String beanName = springBean.getBeanName();
            String[] aliases = springBean.getAliases();
            for (String patternText : StringUtil.split((String)autowireCandidates, (String)",")) {
                Pattern pattern = Pattern.compile(FileUtil.convertAntToRegexp((String)patternText.trim()));
                if (SpringAutowireUtil.isMatched(pattern, beanName)) {
                    return true;
                }
                for (String alias : aliases) {
                    if (!SpringAutowireUtil.isMatched(pattern, alias)) continue;
                    return true;
                }
            }
            return false;
        }
        return true;
    }

    private static boolean isMatched(Pattern pattern, @Nullable String beanName) {
        return beanName != null && pattern.matcher(beanName).matches();
    }

    public static Map<PsiType, Collection<SpringBeanPointer>> getConstructorAutowiredProperties(SpringBean springBean, CommonSpringModel model) {
        HashMap<PsiType, Collection<SpringBeanPointer>> autowiredMap = new HashMap<PsiType, Collection<SpringBeanPointer>>();
        PsiClass beanClass = PsiTypesUtil.getPsiClass((PsiType)springBean.getBeanType());
        if (beanClass != null && SpringAutowireUtil.isConstructorAutowire(springBean)) {
            PsiMethod checkedMethod;
            boolean instantiatedByFactory = SpringConstructorArgResolveUtil.isInstantiatedByFactory(springBean);
            PsiMethod psiMethod = checkedMethod = instantiatedByFactory ? (PsiMethod)springBean.getFactoryMethod().getValue() : SpringConstructorArgUtils.getInstance().getSpringBeanConstructor(springBean, model);
            if (checkedMethod != null) {
                List<ConstructorArg> list = springBean.getConstructorArgs();
                Map<Integer, ConstructorArg> indexedArgs = SpringConstructorArgResolveUtil.getIndexedConstructorArgs(list);
                PsiParameter[] parameters = checkedMethod.getParameterList().getParameters();
                List usedArgs = ContainerUtil.newSmartList();
                for (int i = 0; i < parameters.length; ++i) {
                    Collection<SpringBeanPointer> springBeans;
                    PsiParameter parameter = parameters[i];
                    if (SpringConstructorArgResolveUtil.acceptParameter(parameter, new ArrayList<ConstructorArg>(springBean.getConstructorArgs()), indexedArgs, i, usedArgs)) continue;
                    PsiType psiType = parameter.getType();
                    PsiAnnotation qualifiedAnnotation = SpringAutowireUtil.getQualifiedAnnotation((PsiModifierListOwner)parameter);
                    Collection<SpringBeanPointer> collection = springBeans = qualifiedAnnotation != null ? SpringAutowireUtil.getQualifiedBeans(qualifiedAnnotation, model) : SpringAutowireUtil.autowireByType(model, SpringAutowireUtil.getAutowiredEffectiveBeanTypes(psiType));
                    if (springBeans.isEmpty()) continue;
                    autowiredMap.put(psiType, springBeans);
                }
            }
        }
        return autowiredMap;
    }

    public static boolean isPropertyDefined(SpringBean springBean, String propertyName) {
        return springBean.getProperty(propertyName) != null;
    }

    public static Map<PsiMethod, SpringBeanPointer> getByNameAutowiredProperties(SpringBean springBean) {
        HashMap<PsiMethod, SpringBeanPointer> autowiredMap = new HashMap<PsiMethod, SpringBeanPointer>();
        PsiClass beanClass = PsiTypesUtil.getPsiClass((PsiType)springBean.getBeanType());
        if (beanClass != null) {
            CommonSpringModel model = SpringModelUtils.getInstance().getSpringModelByBean(springBean);
            if (SpringAutowireUtil.isByNameAutowired(springBean)) {
                for (PsiMethod psiMethod : beanClass.getAllMethods()) {
                    if (!PropertyUtilBase.isSimplePropertySetter((PsiMethod)psiMethod)) continue;
                    PsiParameter parameter = psiMethod.getParameterList().getParameters()[0];
                    Set<SpringBeanPointer> list = SpringAutowireUtil.autowireByType(model, SpringAutowireUtil.getAutowiredEffectiveBeanTypes(parameter.getType()));
                    String propertyName = PropertyUtilBase.getPropertyNameBySetter((PsiMethod)psiMethod);
                    for (SpringBeanPointer pointer : list) {
                        if (!pointer.isValid() || !SpringBeanUtils.getInstance().findBeanNames((CommonSpringBean)pointer.getSpringBean()).contains(propertyName) || SpringAutowireUtil.isPropertyDefined(springBean, propertyName)) continue;
                        autowiredMap.put(psiMethod, pointer);
                    }
                }
            }
        }
        return autowiredMap;
    }

    private static boolean isPropertyAutowired(PsiMethod psiMethod, SpringBean springBean) {
        PsiParameter parameter;
        PsiType psiType;
        if (PropertyUtilBase.isSimplePropertySetter((PsiMethod)psiMethod) && (psiType = (parameter = psiMethod.getParameterList().getParameters()[0]).getType()) instanceof PsiClassType) {
            PsiClass psiClass = ((PsiClassType)psiType).resolve();
            return psiClass != null && !SpringAutowireUtil.isPropertyDefined(springBean, PropertyUtilBase.getPropertyNameBySetter((PsiMethod)psiMethod));
        }
        return false;
    }

    public static boolean isByTypeAutowired(SpringBean springBean) {
        return springBean.getBeanAutowire().equals((Object)Autowire.BY_TYPE);
    }

    public static boolean isByNameAutowired(SpringBean springBean) {
        return springBean.getBeanAutowire().equals((Object)Autowire.BY_NAME);
    }

    public static boolean isConstructorAutowire(SpringBean springBean) {
        return springBean.getBeanAutowire().equals((Object)Autowire.CONSTRUCTOR);
    }

    public static Map<PsiMember, Set<SpringBeanPointer>> getAutowireAnnotationProperties(CommonSpringBean springBean, @NotNull CommonSpringModel model) {
        if (model == null) {
            SpringAutowireUtil.$$$reportNull$$$0(10);
        }
        HashMap<PsiMember, Set<SpringBeanPointer>> map = new HashMap<PsiMember, Set<SpringBeanPointer>>();
        PsiClass beanClass = PsiTypesUtil.getPsiClass((PsiType)springBean.getBeanType());
        if (beanClass != null) {
            for (PsiMethod psiMethod : SpringAutowireUtil.getAnnotatedAutowiredMethods(beanClass)) {
                for (PsiParameter parameter : psiMethod.getParameterList().getParameters()) {
                    PsiAnnotation psiAnnotation = SpringAutowireUtil.getQualifiedAnnotation((PsiModifierListOwner)parameter);
                    if (psiAnnotation != null) {
                        SpringAutowireUtil.addAutowiredBeans(map, (PsiMember)psiMethod, SpringAutowireUtil.getQualifiedBeans(psiAnnotation, model), model);
                        continue;
                    }
                    SpringAutowireUtil.addAutowiredBeans(map, (PsiMember)psiMethod, SpringBeanCoreUtils.getBeansByType(parameter.getType(), model), model);
                }
            }
            for (PsiField psiField : SpringAutowireUtil.getAnnotatedAutowiredFields(beanClass)) {
                PsiAnnotation psiAnnotation = SpringAutowireUtil.getQualifiedAnnotation((PsiModifierListOwner)psiField);
                if (psiAnnotation != null) {
                    SpringAutowireUtil.addAutowiredBeans(map, (PsiMember)psiField, SpringAutowireUtil.getQualifiedBeanPointers(psiAnnotation, model), model);
                    continue;
                }
                SpringAutowireUtil.addAutowiredBeans(map, (PsiMember)psiField, SpringAutowireUtil.getAutowiredBeansFor((PsiModifierListOwner)psiField, psiField.getType(), model), model);
            }
        }
        return map;
    }

    private static void addAutowiredBeans(@NotNull Map<PsiMember, Set<SpringBeanPointer>> map, @NotNull PsiMember psiMember, @NotNull Collection<SpringBeanPointer> beans, CommonSpringModel model) {
        Set<SpringBeanPointer> list;
        if (map == null) {
            SpringAutowireUtil.$$$reportNull$$$0(11);
        }
        if (psiMember == null) {
            SpringAutowireUtil.$$$reportNull$$$0(12);
        }
        if (beans == null) {
            SpringAutowireUtil.$$$reportNull$$$0(13);
        }
        if (!(list = SpringAutowireUtil.excludeAutowireCandidates(beans, null, model)).isEmpty()) {
            if (!map.containsKey(psiMember)) {
                map.put(psiMember, list);
            } else {
                map.get(psiMember).addAll(list);
            }
        }
    }

    @NotNull
    public static List<SpringBeanPointer> getQualifiedBeans(@NotNull PsiAnnotation psiAnnotation, @Nullable CommonSpringModel model) {
        if (psiAnnotation == null) {
            SpringAutowireUtil.$$$reportNull$$$0(14);
        }
        if (model == null) {
            List<SpringBeanPointer> list = SpringAutowireUtil.emptyList();
            if (list == null) {
                SpringAutowireUtil.$$$reportNull$$$0(15);
            }
            return list;
        }
        SpringJamQualifier qualifier = SpringAutowireUtil.getQualifier(null, psiAnnotation);
        List<SpringBeanPointer> list = SpringModelVisitorUtils.findQualifiedBeans(model, qualifier);
        if (list == null) {
            SpringAutowireUtil.$$$reportNull$$$0(16);
        }
        return list;
    }

    @Nullable
    public static PsiAnnotation getQualifiedAnnotation(@NotNull PsiModifierListOwner modifierListOwner) {
        if (modifierListOwner == null) {
            SpringAutowireUtil.$$$reportNull$$$0(17);
        }
        return SpringAutowireUtil.getQualifiedAnnotation(modifierListOwner, ModuleUtilCore.findModuleForPsiElement((PsiElement)modifierListOwner));
    }

    @Nullable
    private static PsiAnnotation getQualifiedAnnotation(@NotNull PsiModifierListOwner modifierListOwner, @Nullable Module module) {
        PsiMethod psiMethod;
        if (modifierListOwner == null) {
            SpringAutowireUtil.$$$reportNull$$$0(18);
        }
        if (module == null) {
            return null;
        }
        JamAnnotationTypeUtil jamAnnotationTypeUtil = JamAnnotationTypeUtil.getInstance(module);
        List<PsiClass> annotationTypeClasses = jamAnnotationTypeUtil.getQualifierAnnotationTypesWithChildren();
        for (PsiClass annotationTypeClass : annotationTypeClasses) {
            PsiAnnotation annotation;
            if (!(modifierListOwner instanceof PsiField && AnnotationTargetUtil.findAnnotationTarget((PsiClass)annotationTypeClass, (PsiAnnotation.TargetType[])new PsiAnnotation.TargetType[]{PsiAnnotation.TargetType.FIELD}) != null || modifierListOwner instanceof PsiParameter && AnnotationTargetUtil.findAnnotationTarget((PsiClass)annotationTypeClass, (PsiAnnotation.TargetType[])new PsiAnnotation.TargetType[]{PsiAnnotation.TargetType.PARAMETER}) != null) && (!(modifierListOwner instanceof PsiMethod) || AnnotationTargetUtil.findAnnotationTarget((PsiClass)annotationTypeClass, (PsiAnnotation.TargetType[])new PsiAnnotation.TargetType[]{PsiAnnotation.TargetType.METHOD}) == null) || (annotation = AnnotationUtil.findAnnotation((PsiModifierListOwner)modifierListOwner, (boolean)true, (String[])new String[]{annotationTypeClass.getQualifiedName()})) == null) continue;
            return annotation;
        }
        if (modifierListOwner instanceof PsiParameter && (psiMethod = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)modifierListOwner, PsiMethod.class)) != null && SpringAutowireUtil.isAutowiredByAnnotation((PsiModifierListOwner)psiMethod)) {
            for (PsiClass annotationTypeClass : annotationTypeClasses) {
                PsiAnnotation annotation;
                if (AnnotationTargetUtil.findAnnotationTarget((PsiClass)annotationTypeClass, (PsiAnnotation.TargetType[])new PsiAnnotation.TargetType[]{PsiAnnotation.TargetType.METHOD}) == null || (annotation = AnnotationUtil.findAnnotation((PsiModifierListOwner)psiMethod, (boolean)true, (String[])new String[]{annotationTypeClass.getQualifiedName()})) == null) continue;
                return annotation;
            }
        }
        return null;
    }

    @Nullable
    public static PsiAnnotation getAutowiredAnnotation(@NotNull PsiModifierListOwner owner) {
        PsiModifierList modifierList;
        if (owner == null) {
            SpringAutowireUtil.$$$reportNull$$$0(19);
        }
        if ((modifierList = owner.getModifierList()) != null) {
            for (String annotation : AUTOWIRED_ANNOTATIONS) {
                PsiAnnotation autowireAnnotation = modifierList.findAnnotation(annotation);
                if (autowireAnnotation == null) continue;
                return autowireAnnotation;
            }
        }
        return null;
    }

    @Nullable
    public static PsiAnnotation getResourceAnnotation(@NotNull PsiModifierListOwner owner) {
        PsiModifierList modifierList;
        if (owner == null) {
            SpringAutowireUtil.$$$reportNull$$$0(20);
        }
        if ((modifierList = owner.getModifierList()) != null) {
            return modifierList.findAnnotation("javax.annotation.Resource");
        }
        return null;
    }

    public static boolean isAutowiredByAnnotation(@NotNull PsiModifierListOwner owner) {
        PsiModifierList modifierList;
        if (owner == null) {
            SpringAutowireUtil.$$$reportNull$$$0(21);
        }
        if ((modifierList = owner.getModifierList()) == null || modifierList.hasModifierProperty("static") || modifierList.getAnnotations().length == 0) {
            return false;
        }
        Set<String> autowireAnnotations = SpringAutowireUtil.getAutowiredAnnotations(ModuleUtilCore.findModuleForPsiElement((PsiElement)owner));
        return AnnotationUtil.isAnnotated((PsiModifierListOwner)owner, autowireAnnotations, (int)0);
    }

    public static boolean isInjectionPoint(@NotNull PsiMethod psiMethod) {
        if (psiMethod == null) {
            SpringAutowireUtil.$$$reportNull$$$0(22);
        }
        boolean hasParameters = psiMethod.getParameterList().getParametersCount() != 0;
        return hasParameters && SpringAutowireUtil.isAutowiredByAnnotation((PsiModifierListOwner)psiMethod) || SpringAutowireUtil.isStereotypeBean(psiMethod) || hasParameters && SpringAutowireUtil.isDefaultStereotypeComponentConstructor(psiMethod);
    }

    private static boolean isDefaultStereotypeComponentConstructor(@NotNull PsiMethod method) {
        if (method == null) {
            SpringAutowireUtil.$$$reportNull$$$0(23);
        }
        if (!method.isConstructor()) {
            return false;
        }
        PsiClass containingClass = method.getContainingClass();
        return containingClass != null && containingClass.getConstructors().length == 1 && SpringCommonUtils.isStereotypeComponentOrMeta(containingClass);
    }

    private static boolean isStereotypeBean(@NotNull PsiMethod method) {
        if (method == null) {
            SpringAutowireUtil.$$$reportNull$$$0(24);
        }
        return JamService.getJamService((Project)method.getProject()).getJamElement(ContextJavaBean.BEAN_JAM_KEY, (PsiElement)method) != null;
    }

    public static boolean isRequired(@NotNull PsiModifierListOwner owner) {
        PsiModifierList modifierList;
        if (owner == null) {
            SpringAutowireUtil.$$$reportNull$$$0(25);
        }
        if ((modifierList = owner.getModifierList()) != null) {
            PsiAnnotation required = modifierList.findAnnotation("org.springframework.beans.factory.annotation.Required");
            if (required != null) {
                return true;
            }
            PsiAnnotation autowiredAnnotation = SpringAutowireUtil.getAutowiredAnnotation(owner);
            if (autowiredAnnotation != null) {
                Boolean value = (Boolean)JamCommonUtil.getObjectValue((PsiAnnotationMemberValue)autowiredAnnotation.findAttributeValue("required"), Boolean.class);
                return value == null || value != false;
            }
        }
        return true;
    }

    @NotNull
    public static List<PsiMethod> getAnnotatedAutowiredMethods(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            SpringAutowireUtil.$$$reportNull$$$0(26);
        }
        SmartList methods = new SmartList();
        for (PsiMethod psiMethod : psiClass.getAllMethods()) {
            if (!SpringAutowireUtil.isAutowiredByAnnotation((PsiModifierListOwner)psiMethod)) continue;
            methods.add(psiMethod);
        }
        SmartList smartList = methods;
        if (smartList == null) {
            SpringAutowireUtil.$$$reportNull$$$0(27);
        }
        return smartList;
    }

    @NotNull
    public static List<PsiField> getAnnotatedAutowiredFields(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            SpringAutowireUtil.$$$reportNull$$$0(28);
        }
        SmartList fields = new SmartList();
        for (PsiField psiField : psiClass.getAllFields()) {
            if (!SpringAutowireUtil.isAutowiredByAnnotation((PsiModifierListOwner)psiField)) continue;
            fields.add(psiField);
        }
        SmartList smartList = fields;
        if (smartList == null) {
            SpringAutowireUtil.$$$reportNull$$$0(29);
        }
        return smartList;
    }

    @NotNull
    public static Set<SpringBeanPointer> autowireByType(@NotNull CommonSpringModel model, PsiType psiType) {
        if (model == null) {
            SpringAutowireUtil.$$$reportNull$$$0(30);
        }
        Set<SpringBeanPointer> set = SpringAutowireUtil.autowireByType(model, psiType, null);
        if (set == null) {
            SpringAutowireUtil.$$$reportNull$$$0(31);
        }
        return set;
    }

    @NotNull
    public static Set<SpringBeanPointer> autowireByType(@NotNull CommonSpringModel model, PsiType psiType, @Nullable String primaryCandidateName) {
        if (model == null) {
            SpringAutowireUtil.$$$reportNull$$$0(32);
        }
        Set<SpringBeanPointer> set = SpringAutowireUtil.autowireByType(model, psiType, primaryCandidateName, true);
        if (set == null) {
            SpringAutowireUtil.$$$reportNull$$$0(33);
        }
        return set;
    }

    @NotNull
    public static Set<SpringBeanPointer> autowireByType(@NotNull CommonSpringModel model, PsiType psiType, @Nullable String primaryCandidateName, boolean filterByGenerics) {
        if (model == null) {
            SpringAutowireUtil.$$$reportNull$$$0(34);
        }
        if (psiType instanceof PsiTypeParameter) {
            Set<SpringBeanPointer> set = Collections.emptySet();
            if (set == null) {
                SpringAutowireUtil.$$$reportNull$$$0(35);
            }
            return set;
        }
        PsiClass psiClass = PsiTypesUtil.getPsiClass((PsiType)psiType);
        if (psiClass != null && psiClass.getQualifiedName() == null) {
            Set<SpringBeanPointer> set = Collections.emptySet();
            if (set == null) {
                SpringAutowireUtil.$$$reportNull$$$0(36);
            }
            return set;
        }
        SpringModelSearchParameters.BeanClass searchParameters = SpringModelSearchParameters.byType(psiType).withInheritors().effectiveBeanTypes();
        List<SpringBeanPointer> beans = SpringModelSearchers.findBeans(model, searchParameters);
        Set<SpringBeanPointer> pointers = SpringAutowireUtil.excludeAutowireCandidates(beans, primaryCandidateName, model);
        pointers = SpringAutowireUtil.excludeOverridenDefaultBeans(pointers);
        pointers = SpringAutowireUtil.excludeTheSameIdentifyingElements(pointers);
        pointers = SpringAutowireUtil.excludeExplicitlyRedefined(pointers);
        Set<SpringBeanPointer> set = filterByGenerics ? SpringAutowireUtil.filterByGenerics(pointers, psiType) : pointers;
        if (set == null) {
            SpringAutowireUtil.$$$reportNull$$$0(37);
        }
        return set;
    }

    @NotNull
    private static Set<SpringBeanPointer> filterByGenerics(@NotNull Set<? extends SpringBeanPointer> pointers, @NotNull PsiType type) {
        if (pointers == null) {
            SpringAutowireUtil.$$$reportNull$$$0(38);
        }
        if (type == null) {
            SpringAutowireUtil.$$$reportNull$$$0(39);
        }
        HashSet filtered = ContainerUtil.newHashSet();
        block0: for (SpringBeanPointer springBeanPointer : pointers) {
            if (SpringAutowireUtil.isAssignable(type, springBeanPointer.getBeanClass())) {
                filtered.add(springBeanPointer);
                continue;
            }
            for (PsiType psiType : springBeanPointer.getEffectiveBeanTypes()) {
                if (!type.isAssignableFrom(psiType)) continue;
                filtered.add(springBeanPointer);
                continue block0;
            }
        }
        HashSet hashSet = filtered;
        if (hashSet == null) {
            SpringAutowireUtil.$$$reportNull$$$0(40);
        }
        return hashSet;
    }

    private static boolean isAssignable(@NotNull PsiType type, @Nullable PsiClass beanClass) {
        if (type == null) {
            SpringAutowireUtil.$$$reportNull$$$0(41);
        }
        if (beanClass == null) {
            return false;
        }
        PsiClassType psiClassType = JavaPsiFacade.getInstance((Project)beanClass.getProject()).getElementFactory().createType(beanClass);
        return type.isAssignableFrom((PsiType)psiClassType);
    }

    public static PsiType getAutowiredEffectiveBeanTypes(@NotNull PsiType psiType) {
        if (psiType == null) {
            SpringAutowireUtil.$$$reportNull$$$0(42);
        }
        if (psiType instanceof PsiArrayType) {
            return SpringAutowireUtil.getAutowiredEffectiveBeanTypes(((PsiArrayType)psiType).getComponentType());
        }
        PsiType beanType = PsiUtil.extractIterableTypeParameter((PsiType)psiType, (boolean)false);
        if (beanType != null) {
            return beanType;
        }
        if (psiType instanceof PsiClassType) {
            PsiType objectFactoryType;
            if (SpringObjectFactoryEffectiveTypeProvider.isInjectProvider((PsiClassType)psiType)) {
                PsiType injectProviderType = SpringObjectFactoryEffectiveTypeProvider.getInjectProviderType((PsiClassType)psiType);
                if (injectProviderType != null) {
                    return injectProviderType;
                }
            } else if (SpringObjectFactoryEffectiveTypeProvider.isObjectFactory((PsiClassType)psiType) && (objectFactoryType = SpringObjectFactoryEffectiveTypeProvider.getObjectFactoryType((PsiClassType)psiType)) != null) {
                return objectFactoryType;
            }
        }
        return psiType;
    }

    private static List<SpringBeanPointer> emptyList() {
        return new ArrayList<SpringBeanPointer>();
    }

    public static boolean isAutowiredByDefault(@NotNull PsiType psiType) {
        if (psiType == null) {
            SpringAutowireUtil.$$$reportNull$$$0(43);
        }
        if (!(psiType instanceof PsiClassType)) {
            return false;
        }
        String text = psiType.getCanonicalText();
        if (STANDARD_AUTOWIRED_TYPES.contains(text)) {
            return true;
        }
        for (String standardAutowiredType : STANDARD_AUTOWIRED_TYPES) {
            if (!InheritanceUtil.isInheritor((PsiType)psiType, (String)standardAutowiredType)) continue;
            return true;
        }
        return false;
    }

    public static boolean isAutowired(SpringBean springBean, CommonSpringModel springModel, PsiMethod psiMethod) {
        Autowire autowire = springBean.getBeanAutowire();
        switch (autowire) {
            case BY_TYPE: {
                PsiClass psiClass;
                PsiType psiType = psiMethod.getParameterList().getParameters()[0].getType();
                return psiType instanceof PsiClassType && (psiClass = ((PsiClassType)psiType).resolve()) != null && SpringModelSearchers.doesBeanExist(springModel, psiClass);
            }
            case BY_NAME: {
                String propertyName = PropertyUtilBase.getPropertyNameBySetter((PsiMethod)psiMethod);
                SpringBeanPointer bean = SpringModelSearchers.findBean(springModel, propertyName);
                return bean != null && !bean.isReferenceTo(springBean);
            }
        }
        return false;
    }

    public static Set<String> getAutowiredAnnotations(@Nullable Module module) {
        if (module == null) {
            return AUTOWIRED_ANNOTATIONS;
        }
        LinkedHashSet<String> annotations = new LinkedHashSet<String>();
        annotations.addAll(AUTOWIRED_ANNOTATIONS);
        annotations.addAll(SpringAutowireUtil.getMetaAutowiredAnnotations(module));
        if (SpringAutowireUtil.isUsingAutowiredPostProcessor(module)) {
            annotations.addAll(SpringAutowireUtil.getCustomAnnotationsFromPostProcessors(module));
        }
        return annotations;
    }

    @NotNull
    private static List<String> getMetaAutowiredAnnotations(@NotNull Module module) {
        if (module == null) {
            SpringAutowireUtil.$$$reportNull$$$0(44);
        }
        List list = ContainerUtil.mapNotNull((Collection)MetaAnnotationUtil.getAnnotationTypesWithChildren((Module)module, (String)"org.springframework.beans.factory.annotation.Autowired", (boolean)false), (Function)((NullableFunction)PsiClass::getQualifiedName));
        if (list == null) {
            SpringAutowireUtil.$$$reportNull$$$0(45);
        }
        return list;
    }

    public static Set<PsiModifierListOwner> getAutowiredMembers(@NotNull PsiType type, @Nullable Module module, @NotNull PsiMethod method) {
        if (type == null) {
            SpringAutowireUtil.$$$reportNull$$$0(46);
        }
        if (method == null) {
            SpringAutowireUtil.$$$reportNull$$$0(47);
        }
        if (module == null) {
            return Collections.emptySet();
        }
        LinkedHashSet membersCandidate = ContainerUtil.newLinkedHashSet();
        GlobalSearchScope scope = method.getResolveScope();
        Set<PsiType> effectiveTypes = SpringAutowireUtil.getEffectiveTypes(type);
        Processor processor = member -> {
            block5: {
                block4: {
                    if (!(member instanceof PsiField)) break block4;
                    for (PsiType effectiveType : effectiveTypes) {
                        PsiType psiType = ((PsiField)member).getType();
                        if ("java.lang.Object".equals(psiType.getCanonicalText()) || !psiType.isAssignableFrom(effectiveType)) continue;
                        membersCandidate.add(member);
                    }
                    break block5;
                }
                if (!(member instanceof PsiMethod)) break block5;
                block1: for (PsiParameter psiParameter : ((PsiMethod)member).getParameterList().getParameters()) {
                    for (PsiType effectiveType : effectiveTypes) {
                        PsiType psiType = psiParameter.getType();
                        if ("java.lang.Object".equals(psiType.getCanonicalText())) continue;
                        if (psiType.isAssignableFrom(effectiveType)) {
                            membersCandidate.add(psiParameter);
                            continue block1;
                        }
                        PsiType objectFactoryEffectiveType = SpringObjectFactoryEffectiveTypeProvider.getObjectFactoryEffectiveType(psiType);
                        if (objectFactoryEffectiveType == null || !objectFactoryEffectiveType.isAssignableFrom(effectiveType)) continue;
                        membersCandidate.add(psiParameter);
                        continue block1;
                    }
                }
            }
            return true;
        };
        HashSet annotations = ContainerUtil.newHashSet(SpringAutowireUtil.getAutowiredAnnotations(module));
        annotations.add("org.springframework.context.annotation.Bean");
        for (String annotation : annotations) {
            PsiClass annoClass = JavaPsiFacade.getInstance((Project)module.getProject()).findClass(annotation, scope);
            if (annoClass == null) continue;
            AnnotatedMembersSearch.search((PsiClass)annoClass, (SearchScope)scope).forEach(processor);
        }
        return SpringAutowireUtil.filterCandidates(method, membersCandidate, module);
    }

    @NotNull
    public static Set<PsiModifierListOwner> filterCandidates(@NotNull PsiMethod method, @NotNull Set<? extends PsiModifierListOwner> all, @Nullable Module module) {
        if (method == null) {
            SpringAutowireUtil.$$$reportNull$$$0(48);
        }
        if (all == null) {
            SpringAutowireUtil.$$$reportNull$$$0(49);
        }
        SpringJamQualifier qualifier = SpringAutowireUtil.getQualifier((PsiModifierListOwner)method, SpringAutowireUtil.getQualifiedAnnotation((PsiModifierListOwner)method, module));
        Set<PsiModifierListOwner> set = all.stream().filter(owner -> {
            SpringJamQualifier candidateQualifier;
            if (method == null) {
                SpringAutowireUtil.$$$reportNull$$$0(114);
            }
            if ((candidateQualifier = SpringAutowireUtil.getQualifier(owner)) != null) {
                if (qualifier != null && qualifier.compareQualifiers(candidateQualifier, module)) {
                    return true;
                }
                return method.getName().equals(candidateQualifier.getQualifierValue());
            }
            return true;
        }).collect(Collectors.toSet());
        if (set == null) {
            SpringAutowireUtil.$$$reportNull$$$0(50);
        }
        return set;
    }

    @Nullable
    public static SpringJamQualifier getQualifier(@Nullable PsiModifierListOwner modifierListOwner) {
        return modifierListOwner == null ? null : SpringAutowireUtil.getQualifier(modifierListOwner, SpringAutowireUtil.getQualifiedAnnotation(modifierListOwner));
    }

    @Nullable
    public static SpringJamQualifier getQualifier(@Nullable PsiModifierListOwner modifierListOwner, @Nullable PsiAnnotation qualifiedAnnotation) {
        return qualifiedAnnotation == null ? null : new SpringJamQualifier(qualifiedAnnotation, modifierListOwner);
    }

    @NotNull
    private static Set<PsiType> getEffectiveTypes(@NotNull PsiType type) {
        if (type == null) {
            SpringAutowireUtil.$$$reportNull$$$0(51);
        }
        LinkedHashSet types = ContainerUtil.newLinkedHashSet();
        types.add(type);
        types.addAll(SpringBeanCoreUtils.getFactoryBeanTypes(type, null));
        LinkedHashSet linkedHashSet = types;
        if (linkedHashSet == null) {
            SpringAutowireUtil.$$$reportNull$$$0(52);
        }
        return linkedHashSet;
    }

    private static Set<String> getCustomAnnotationsFromPostProcessors(@Nullable Module module) {
        if (module == null) {
            return Collections.emptySet();
        }
        PsiClass autowiredPostProcessor = SpringCommonUtils.findLibraryClass(module, "org.springframework.beans.factory.annotation.AutowiredAnnotationBeanPostProcessor");
        if (autowiredPostProcessor == null) {
            return Collections.emptySet();
        }
        HashSet<String> annotations = new HashSet<String>();
        SpringModel springModel = SpringManager.getInstance(module.getProject()).getCombinedModel(module);
        SpringModelSearchParameters.BeanClass searchParameters = SpringModelSearchParameters.byClass(autowiredPostProcessor).withInheritors();
        for (SpringBeanPointer pointer : SpringModelSearchers.findBeans(springModel, searchParameters)) {
            Object springBean = pointer.getSpringBean();
            if (!(springBean instanceof SpringBean)) continue;
            SpringAutowireUtil.addAutowiredAnnotationType(annotations, springBean);
            SpringAutowireUtil.addAutowiredAnnotationTypes(annotations, springBean);
        }
        return annotations;
    }

    private static boolean isUsingAutowiredPostProcessor(@NotNull Module module) {
        if (module == null) {
            SpringAutowireUtil.$$$reportNull$$$0(53);
        }
        GlobalSearchScope scope = GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)module);
        Project project = module.getProject();
        Collection springXmlCandidates = DomService.getInstance().getDomFileCandidates(Beans.class, project, scope);
        if (springXmlCandidates.isEmpty()) {
            return false;
        }
        String className = ClassUtil.extractClassName((String)"org.springframework.beans.factory.annotation.AutowiredAnnotationBeanPostProcessor");
        CommonProcessors.FindFirstProcessor processor = new CommonProcessors.FindFirstProcessor();
        CacheManager.SERVICE.getInstance((Project)project).processFilesWithWord((Processor)processor, className, (short)255, GlobalSearchScope.filesWithLibrariesScope((Project)project, (Collection)springXmlCandidates), true);
        return processor.isFound();
    }

    private static void addAutowiredAnnotationType(@NotNull Set<? super String> annotations, @NotNull CommonSpringBean springBean) {
        String value;
        SpringPropertyDefinition autowiredTypeProperty;
        if (annotations == null) {
            SpringAutowireUtil.$$$reportNull$$$0(54);
        }
        if (springBean == null) {
            SpringAutowireUtil.$$$reportNull$$$0(55);
        }
        if ((autowiredTypeProperty = SpringPropertyUtils.findPropertyByName(springBean, "autowiredAnnotationType")) != null && !StringUtil.isEmptyOrSpaces((String)(value = autowiredTypeProperty.getValueAsString()))) {
            annotations.add(value);
        }
    }

    private static void addAutowiredAnnotationTypes(@NotNull Set<? super String> annotations, @NotNull CommonSpringBean springBean) {
        SpringPropertyDefinition autowiredTypes;
        if (annotations == null) {
            SpringAutowireUtil.$$$reportNull$$$0(56);
        }
        if (springBean == null) {
            SpringAutowireUtil.$$$reportNull$$$0(57);
        }
        if ((autowiredTypes = SpringPropertyUtils.findPropertyByName(springBean, "autowiredAnnotationTypes")) instanceof SpringProperty) {
            SpringProperty springProperty = (SpringProperty)autowiredTypes;
            SpringAutowireUtil.addNotNullValues(annotations, springProperty.getList().getValues());
            SpringAutowireUtil.addNotNullValues(annotations, springProperty.getSet().getValues());
            SpringAutowireUtil.addNotNullValues(annotations, springProperty.getArray().getValues());
        }
    }

    private static void addNotNullValues(@NotNull Collection<? super String> annotations, @NotNull Collection<? extends SpringValue> values) {
        if (annotations == null) {
            SpringAutowireUtil.$$$reportNull$$$0(58);
        }
        if (values == null) {
            SpringAutowireUtil.$$$reportNull$$$0(59);
        }
        for (SpringValue springValue : values) {
            String stringValue = springValue.getStringValue();
            if (StringUtil.isEmptyOrSpaces((String)stringValue)) continue;
            annotations.add(stringValue);
        }
    }

    @Nullable
    public static CommonSpringModel getProcessingSpringModel(@Nullable PsiClass psiClass) {
        if (psiClass == null || psiClass.getQualifiedName() == null) {
            return null;
        }
        if (psiClass instanceof PsiAnonymousClass) {
            return SpringModelUtils.getInstance().getModuleCombinedSpringModel((PsiElement)psiClass);
        }
        CommonSpringModel model = SpringModelUtils.getInstance().getPsiClassSpringModel(psiClass);
        if (model instanceof CombinedSpringModel) {
            model = SpringAutowireUtil.filterClassRelatedModels((CombinedSpringModel)model, psiClass);
        }
        return SpringAutowireUtil.isEmptyModel(model) ? null : model;
    }

    @NotNull
    private static CommonSpringModel filterClassRelatedModels(@NotNull CombinedSpringModel model, @NotNull PsiClass aClass) {
        if (model == null) {
            SpringAutowireUtil.$$$reportNull$$$0(60);
        }
        if (aClass == null) {
            SpringAutowireUtil.$$$reportNull$$$0(61);
        }
        HashSet models = ContainerUtil.newHashSet();
        for (CommonSpringModel commonSpringModel : model.getUnderlyingModels()) {
            SpringFileSet fileSet;
            if (!SpringModelSearchers.doesBeanExist(commonSpringModel, SpringModelSearchParameters.byClass(aClass).withInheritors())) continue;
            if (commonSpringModel instanceof SpringModel && (fileSet = ((SpringModel)commonSpringModel).getFileSet()) != null && fileSet.isAutodetected()) {
                CombinedSpringModel combinedSpringModel = model;
                if (combinedSpringModel == null) {
                    SpringAutowireUtil.$$$reportNull$$$0(62);
                }
                return combinedSpringModel;
            }
            models.add(commonSpringModel);
        }
        CombinedSpringModelImpl combinedSpringModelImpl = new CombinedSpringModelImpl(models, model.getModule());
        if (combinedSpringModelImpl == null) {
            SpringAutowireUtil.$$$reportNull$$$0(63);
        }
        return combinedSpringModelImpl;
    }

    private static boolean isEmptyModel(@NotNull CommonSpringModel model) {
        if (model == null) {
            SpringAutowireUtil.$$$reportNull$$$0(64);
        }
        return model.equals(SpringModel.UNKNOWN) || model instanceof CombinedSpringModel && ((CombinedSpringModel)model).getUnderlyingModels().isEmpty();
    }

    @NotNull
    private static Set<SpringBeanPointer> excludeOverridenDefaultBeans(@NotNull Set<SpringBeanPointer> pointers) {
        SpringBeanPointer[] objects;
        if (pointers == null) {
            SpringAutowireUtil.$$$reportNull$$$0(65);
        }
        if (pointers.size() == 1) {
            Set<SpringBeanPointer> set = pointers;
            if (set == null) {
                SpringAutowireUtil.$$$reportNull$$$0(66);
            }
            return set;
        }
        LinkedHashSet beans = ContainerUtil.newLinkedHashSet();
        for (SpringBeanPointer pointer : objects = (SpringBeanPointer[])ArrayUtil.toObjectArray(pointers, SpringBeanPointer.class)) {
            Object bean = pointer.getSpringBean();
            if (SpringAutowireUtil.isOverridden(bean, objects)) continue;
            beans.add(pointer);
        }
        LinkedHashSet linkedHashSet = beans;
        if (linkedHashSet == null) {
            SpringAutowireUtil.$$$reportNull$$$0(67);
        }
        return linkedHashSet;
    }

    @NotNull
    private static Set<SpringBeanPointer> excludeTheSameIdentifyingElements(@NotNull Set<? extends SpringBeanPointer> pointers) {
        if (pointers == null) {
            SpringAutowireUtil.$$$reportNull$$$0(68);
        }
        LinkedHashSet filtered = ContainerUtil.newLinkedHashSet();
        HashSet identifyingElements = ContainerUtil.newHashSet();
        for (SpringBeanPointer springBeanPointer : pointers) {
            PsiElement element = springBeanPointer.getSpringBean().getIdentifyingPsiElement();
            if (identifyingElements.contains(element)) continue;
            filtered.add(springBeanPointer);
            ContainerUtil.addIfNotNull((Collection)identifyingElements, (Object)element);
        }
        LinkedHashSet linkedHashSet = filtered;
        if (linkedHashSet == null) {
            SpringAutowireUtil.$$$reportNull$$$0(69);
        }
        return linkedHashSet;
    }

    @NotNull
    private static Set<SpringBeanPointer> excludeExplicitlyRedefined(@NotNull Set<SpringBeanPointer> pointers) {
        if (pointers == null) {
            SpringAutowireUtil.$$$reportNull$$$0(70);
        }
        if (pointers.size() <= 1) {
            Set<SpringBeanPointer> set = pointers;
            if (set == null) {
                SpringAutowireUtil.$$$reportNull$$$0(71);
            }
            return set;
        }
        ExplicitRedefinitionAwareBeansCollector collector = new ExplicitRedefinitionAwareBeansCollector();
        for (SpringBeanPointer pointer : pointers) {
            collector.process(pointer);
        }
        Set<SpringBeanPointer> set = collector.getResult();
        if (set == null) {
            SpringAutowireUtil.$$$reportNull$$$0(72);
        }
        return set;
    }

    private static boolean isOverridden(CommonSpringBean bean, SpringBeanPointer[] objects) {
        if (bean instanceof SpringImplicitBeanMarker) {
            String beanName = bean.getBeanName();
            PsiType beanType = bean.getBeanType();
            if (beanType != null && beanName != null) {
                for (SpringBeanPointer pointer : objects) {
                    if (bean.equals(pointer.getSpringBean()) || !beanName.equals(pointer.getName())) continue;
                    for (PsiType psiType : pointer.getEffectiveBeanTypes()) {
                        if (!psiType.isAssignableFrom(beanType)) continue;
                        return true;
                    }
                }
            }
        }
        return false;
    }

    public static boolean isJavaUtilOptional(@NotNull PsiType type) {
        PsiClass psiClass;
        if (type == null) {
            SpringAutowireUtil.$$$reportNull$$$0(73);
        }
        return (psiClass = PsiTypesUtil.getPsiClass((PsiType)type)) != null && "java.util.Optional".equals(psiClass.getQualifiedName());
    }

    @NotNull
    public static Set<SpringBeanPointer> getAutowiredBeansFor(@NotNull PsiModifierListOwner injectionPointOwner, @NotNull PsiType psiType, @NotNull CommonSpringModel springModel) {
        if (injectionPointOwner == null) {
            SpringAutowireUtil.$$$reportNull$$$0(74);
        }
        if (psiType == null) {
            SpringAutowireUtil.$$$reportNull$$$0(75);
        }
        if (springModel == null) {
            SpringAutowireUtil.$$$reportNull$$$0(76);
        }
        if (psiType instanceof PsiTypeParameter) {
            Set<SpringBeanPointer> set = Collections.emptySet();
            if (set == null) {
                SpringAutowireUtil.$$$reportNull$$$0(77);
            }
            return set;
        }
        PsiAnnotation resourceAnnotation = SpringAutowireUtil.getResourceAnnotation(injectionPointOwner);
        if (resourceAnnotation != null && injectionPointOwner instanceof PsiMember) {
            SpringBeanPointer bean = SpringAutowireUtil.getResourceAutowiredBean(injectionPointOwner, springModel, resourceAnnotation);
            Set<SpringBeanPointer> set = bean != null ? Collections.singleton(bean) : Collections.emptySet();
            if (set == null) {
                SpringAutowireUtil.$$$reportNull$$$0(78);
            }
            return set;
        }
        PsiAnnotation qualifiedAnnotation = SpringAutowireUtil.getEffectiveQualifiedAnnotation(injectionPointOwner);
        if (qualifiedAnnotation != null) {
            Set<SpringBeanPointer> set = SpringAutowireUtil.getQualifiedAutowiredBeans(psiType, qualifiedAnnotation, springModel);
            if (set == null) {
                SpringAutowireUtil.$$$reportNull$$$0(79);
            }
            return set;
        }
        Set<SpringBeanPointer> set = SpringAutowireUtil.getByTypeAutowiredBeans((PsiNameIdentifierOwner)injectionPointOwner, psiType, springModel);
        if (set == null) {
            SpringAutowireUtil.$$$reportNull$$$0(80);
        }
        return set;
    }

    @NotNull
    private static Set<SpringBeanPointer> getByTypeAutowiredBeans(@NotNull PsiNameIdentifierOwner psiNameIdentifierOwner, @NotNull PsiType searchType, CommonSpringModel model) {
        if (psiNameIdentifierOwner == null) {
            SpringAutowireUtil.$$$reportNull$$$0(81);
        }
        if (searchType == null) {
            SpringAutowireUtil.$$$reportNull$$$0(82);
        }
        if (searchType instanceof PsiTypeParameter) {
            Set<SpringBeanPointer> set = Collections.emptySet();
            if (set == null) {
                SpringAutowireUtil.$$$reportNull$$$0(83);
            }
            return set;
        }
        String primaryCandidateName = psiNameIdentifierOwner.getName();
        Set<SpringBeanPointer> iterableBeanPointers = SpringAutowireUtil.getIterableBeanPointers(searchType, model, primaryCandidateName);
        Set<SpringBeanPointer> set = iterableBeanPointers.isEmpty() ? SpringAutowireUtil.autowireByType(model, searchType, primaryCandidateName) : iterableBeanPointers;
        if (set == null) {
            SpringAutowireUtil.$$$reportNull$$$0(84);
        }
        return set;
    }

    @NotNull
    private static Set<SpringBeanPointer> getQualifiedAutowiredBeans(@NotNull PsiType type, @NotNull PsiAnnotation annotation, @NotNull CommonSpringModel model) {
        if (type == null) {
            SpringAutowireUtil.$$$reportNull$$$0(85);
        }
        if (annotation == null) {
            SpringAutowireUtil.$$$reportNull$$$0(86);
        }
        if (model == null) {
            SpringAutowireUtil.$$$reportNull$$$0(87);
        }
        Set<SpringBeanPointer> set = SpringAutowireUtil.filterPointersByAutowiredType(type, SpringAutowireUtil.getQualifiedBeanPointers(annotation, model));
        if (set == null) {
            SpringAutowireUtil.$$$reportNull$$$0(88);
        }
        return set;
    }

    @Nullable
    private static SpringBeanPointer getResourceAutowiredBean(@NotNull PsiModifierListOwner injectionPointOwner, @NotNull CommonSpringModel springModel, @NotNull PsiAnnotation resourceAnnotation) {
        PsiAnnotationMemberValue attributeValue;
        if (injectionPointOwner == null) {
            SpringAutowireUtil.$$$reportNull$$$0(89);
        }
        if (springModel == null) {
            SpringAutowireUtil.$$$reportNull$$$0(90);
        }
        if (resourceAnnotation == null) {
            SpringAutowireUtil.$$$reportNull$$$0(91);
        }
        if ((attributeValue = resourceAnnotation.findDeclaredAttributeValue("name")) != null) {
            return SpringAutowireUtil.getByNameAutowiredBean(attributeValue, springModel);
        }
        return SpringAutowireUtil.findBeanByImplicitInjectionPointName(injectionPointOwner, springModel);
    }

    @Nullable
    private static SpringBeanPointer findBeanByImplicitInjectionPointName(@NotNull PsiModifierListOwner injectionPointOwner, @NotNull CommonSpringModel springModel) {
        SpringBeanPointer bean;
        if (injectionPointOwner == null) {
            SpringAutowireUtil.$$$reportNull$$$0(92);
        }
        if (springModel == null) {
            SpringAutowireUtil.$$$reportNull$$$0(93);
        }
        String name = null;
        if (injectionPointOwner instanceof PsiMethod) {
            name = PropertyUtilBase.getPropertyNameBySetter((PsiMethod)((PsiMethod)injectionPointOwner));
        } else if (injectionPointOwner instanceof PsiField) {
            name = ((PsiField)injectionPointOwner).getName();
        }
        if (name != null && (bean = SpringModelSearchers.findBean(springModel, name)) != null) {
            return bean.getBasePointer();
        }
        return null;
    }

    @Nullable
    public static PsiAnnotation getEffectiveQualifiedAnnotation(@NotNull PsiModifierListOwner modifierListOwner) {
        if (modifierListOwner == null) {
            SpringAutowireUtil.$$$reportNull$$$0(94);
        }
        return modifierListOwner instanceof PsiMethod ? null : SpringAutowireUtil.getQualifiedAnnotation(modifierListOwner);
    }

    @Nullable
    private static SpringBeanPointer getByNameAutowiredBean(@NotNull PsiAnnotationMemberValue annotationMemberValue, @NotNull CommonSpringModel model) {
        if (annotationMemberValue == null) {
            SpringAutowireUtil.$$$reportNull$$$0(95);
        }
        if (model == null) {
            SpringAutowireUtil.$$$reportNull$$$0(96);
        }
        for (PsiReference reference : annotationMemberValue.getReferences()) {
            PsiConstantEvaluationHelper helper;
            Object o;
            PsiElement element;
            if (reference instanceof SpringBeanReference) {
                SpringBeanReference sbReference = (SpringBeanReference)reference;
                String beanName = sbReference.getValue();
                if (!StringUtil.isNotEmpty((String)beanName)) continue;
                return SpringModelSearchers.findBean(model, beanName);
            }
            if (!(reference instanceof PsiReferenceExpression) || !((element = reference.resolve()) instanceof PsiField) || !((o = (helper = JavaPsiFacade.getInstance((Project)element.getProject()).getConstantEvaluationHelper()).computeConstantExpression((PsiElement)((PsiField)element).getInitializer())) instanceof String)) continue;
            return SpringModelSearchers.findBean(model, (String)o);
        }
        return null;
    }

    @NotNull
    public static Set<SpringBeanPointer> filterPointersByAutowiredType(@NotNull PsiType searchType, @NotNull Set<? extends SpringBeanPointer> beanPointers) {
        if (searchType == null) {
            SpringAutowireUtil.$$$reportNull$$$0(97);
        }
        if (beanPointers == null) {
            SpringAutowireUtil.$$$reportNull$$$0(98);
        }
        HashSet autowiredPointers = ContainerUtil.newHashSet();
        block0: for (SpringBeanPointer springBeanPointer : beanPointers) {
            PsiType[] psiTypes;
            for (PsiType psiType : psiTypes = springBeanPointer.getEffectiveBeanTypes()) {
                if (!SpringAutowireUtil.canBeAutowiredByType(searchType, psiType)) continue;
                autowiredPointers.add(springBeanPointer);
                continue block0;
            }
        }
        HashSet hashSet = autowiredPointers;
        if (hashSet == null) {
            SpringAutowireUtil.$$$reportNull$$$0(99);
        }
        return hashSet;
    }

    @NotNull
    public static Set<SpringBeanPointer> getQualifiedBeanPointers(@NotNull PsiAnnotation qualifiedAnnotation, @NotNull CommonSpringModel model) {
        SpringBeanPointer pointer;
        if (qualifiedAnnotation == null) {
            SpringAutowireUtil.$$$reportNull$$$0(100);
        }
        if (model == null) {
            SpringAutowireUtil.$$$reportNull$$$0(101);
        }
        List<SpringBeanPointer> candidates = SpringAutowireUtil.getQualifiedBeans(qualifiedAnnotation, model);
        String name = SpringAutowireUtil.getQualifiedBeanName(qualifiedAnnotation);
        if (name != null && (pointer = SpringModelSearchers.findBean(model, name)) != null) {
            candidates = new ArrayList<SpringBeanPointer>(candidates);
            candidates.add(pointer.getBasePointer());
        }
        Set<SpringBeanPointer> set = SpringAutowireUtil.excludeAutowireCandidates(candidates, model);
        if (set == null) {
            SpringAutowireUtil.$$$reportNull$$$0(102);
        }
        return set;
    }

    public static boolean canBeAutowiredByType(@NotNull PsiType psiType, @NotNull PsiType searchType) {
        if (psiType == null) {
            SpringAutowireUtil.$$$reportNull$$$0(103);
        }
        if (searchType == null) {
            SpringAutowireUtil.$$$reportNull$$$0(104);
        }
        if (psiType.isAssignableFrom(searchType)) {
            return true;
        }
        PsiType iterableType = SpringAutowireUtil.getIterableType(psiType);
        if (iterableType != null && iterableType.isAssignableFrom(searchType)) {
            return true;
        }
        return SpringAutowireUtil.isObjectFactoryEffectiveType(psiType, searchType);
    }

    private static boolean isObjectFactoryEffectiveType(@NotNull PsiType psiType, @NotNull PsiType aType) {
        PsiType objectFactoryEffectiveType;
        if (psiType == null) {
            SpringAutowireUtil.$$$reportNull$$$0(105);
        }
        if (aType == null) {
            SpringAutowireUtil.$$$reportNull$$$0(106);
        }
        return (objectFactoryEffectiveType = SpringObjectFactoryEffectiveTypeProvider.getObjectFactoryEffectiveType(aType)) != null && psiType.isAssignableFrom(objectFactoryEffectiveType);
    }

    @NotNull
    public static Set<SpringBeanPointer> getIterableBeanPointers(@NotNull PsiType searchType, @NotNull CommonSpringModel model, String primaryCandidateName) {
        PsiType secondarySearchType;
        if (searchType == null) {
            SpringAutowireUtil.$$$reportNull$$$0(107);
        }
        if (model == null) {
            SpringAutowireUtil.$$$reportNull$$$0(108);
        }
        Set<SpringBeanPointer> set = (secondarySearchType = SpringAutowireUtil.getIterableSearchType(searchType)) != null ? SpringAutowireUtil.autowireByType(model, secondarySearchType, primaryCandidateName) : Collections.emptySet();
        if (set == null) {
            SpringAutowireUtil.$$$reportNull$$$0(109);
        }
        return set;
    }

    @Nullable
    public static PsiType getIterableSearchType(@NotNull PsiType searchType) {
        PsiType iterableType;
        if (searchType == null) {
            SpringAutowireUtil.$$$reportNull$$$0(110);
        }
        if ((iterableType = SpringAutowireUtil.getIterableType(searchType)) != null) {
            return iterableType;
        }
        if (SpringAutowireUtil.isTypedMapWithStringKey(searchType)) {
            return PsiUtil.substituteTypeParameter((PsiType)searchType, (String)"java.util.Map", (int)1, (boolean)false);
        }
        return SpringObjectFactoryEffectiveTypeProvider.getObjectFactoryEffectiveType(searchType);
    }

    @Nullable
    private static PsiType getIterableType(@NotNull PsiType psiType) {
        if (psiType == null) {
            SpringAutowireUtil.$$$reportNull$$$0(111);
        }
        return psiType instanceof PsiArrayType ? ((PsiArrayType)psiType).getComponentType() : PsiUtil.extractIterableTypeParameter((PsiType)psiType, (boolean)true);
    }

    @Nullable
    public static String getQualifiedBeanName(@NotNull PsiAnnotation qualifiedAnnotation) {
        PsiAnnotationMemberValue attributeValue;
        if (qualifiedAnnotation == null) {
            SpringAutowireUtil.$$$reportNull$$$0(112);
        }
        return (attributeValue = qualifiedAnnotation.findDeclaredAttributeValue("value")) == null ? null : (String)JamCommonUtil.getObjectValue((PsiAnnotationMemberValue)attributeValue, String.class);
    }

    public static boolean isTypedMapWithStringKey(@NotNull PsiType psiType) {
        if (psiType == null) {
            SpringAutowireUtil.$$$reportNull$$$0(113);
        }
        if (psiType instanceof PsiClassType && InheritanceUtil.isInheritor((PsiType)psiType, (String)"java.util.Map")) {
            PsiType keyType = PsiUtil.substituteTypeParameter((PsiType)psiType, (String)"java.util.Map", (int)0, (boolean)false);
            return keyType != null && InheritanceUtil.isInheritor((PsiType)keyType, (String)"java.lang.String");
        }
        return false;
    }

    public static boolean isAutowiringRelevantClass(@Nullable PsiClass psiClass) {
        return psiClass != null && SpringLibraryUtil.hasSpringLibrary(ModuleUtilCore.findModuleForPsiElement((PsiElement)psiClass)) && (SpringCommonUtils.isSpringBeanCandidateClass(psiClass) || SpringTestContextUtil.getInstance().isTestContextConfigurationClass(psiClass));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 15: 
            case 16: 
            case 27: 
            case 29: 
            case 31: 
            case 33: 
            case 35: 
            case 36: 
            case 37: 
            case 40: 
            case 45: 
            case 50: 
            case 52: 
            case 62: 
            case 63: 
            case 66: 
            case 67: 
            case 69: 
            case 71: 
            case 72: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 83: 
            case 84: 
            case 88: 
            case 99: 
            case 102: 
            case 109: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 15: 
            case 16: 
            case 27: 
            case 29: 
            case 31: 
            case 33: 
            case 35: 
            case 36: 
            case 37: 
            case 40: 
            case 45: 
            case 50: 
            case 52: 
            case 62: 
            case 63: 
            case 66: 
            case 67: 
            case 69: 
            case 71: 
            case 72: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 83: 
            case 84: 
            case 88: 
            case 99: 
            case 102: 
            case 109: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "beans";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 15: 
            case 16: 
            case 27: 
            case 29: 
            case 31: 
            case 33: 
            case 35: 
            case 36: 
            case 37: 
            case 40: 
            case 45: 
            case 50: 
            case 52: 
            case 62: 
            case 63: 
            case 66: 
            case 67: 
            case 69: 
            case 71: 
            case 72: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 83: 
            case 84: 
            case 88: 
            case 99: 
            case 102: 
            case 109: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/model/utils/SpringAutowireUtil";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "springBeanPointer";
                break;
            }
            case 10: 
            case 30: 
            case 32: 
            case 34: 
            case 60: 
            case 64: 
            case 87: 
            case 96: 
            case 101: 
            case 108: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "map";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiMember";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiAnnotation";
                break;
            }
            case 17: 
            case 18: 
            case 94: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modifierListOwner";
                break;
            }
            case 19: 
            case 20: 
            case 21: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "owner";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiMethod";
                break;
            }
            case 23: 
            case 24: 
            case 47: 
            case 48: 
            case 114: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 26: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiClass";
                break;
            }
            case 38: 
            case 65: 
            case 68: 
            case 70: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pointers";
                break;
            }
            case 39: 
            case 41: 
            case 46: 
            case 51: 
            case 73: 
            case 85: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 42: 
            case 43: 
            case 75: 
            case 103: 
            case 105: 
            case 111: 
            case 113: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiType";
                break;
            }
            case 44: 
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "all";
                break;
            }
            case 54: 
            case 56: 
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotations";
                break;
            }
            case 55: 
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "springBean";
                break;
            }
            case 59: {
                objectArray2 = objectArray3;
                objectArray3[0] = "values";
                break;
            }
            case 61: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 74: 
            case 89: 
            case 92: {
                objectArray2 = objectArray3;
                objectArray3[0] = "injectionPointOwner";
                break;
            }
            case 76: 
            case 90: 
            case 93: {
                objectArray2 = objectArray3;
                objectArray3[0] = "springModel";
                break;
            }
            case 81: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiNameIdentifierOwner";
                break;
            }
            case 82: 
            case 97: 
            case 104: 
            case 107: 
            case 110: {
                objectArray2 = objectArray3;
                objectArray3[0] = "searchType";
                break;
            }
            case 86: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotation";
                break;
            }
            case 91: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resourceAnnotation";
                break;
            }
            case 95: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotationMemberValue";
                break;
            }
            case 98: {
                objectArray2 = objectArray3;
                objectArray3[0] = "beanPointers";
                break;
            }
            case 100: 
            case 112: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifiedAnnotation";
                break;
            }
            case 106: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/model/utils/SpringAutowireUtil";
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "excludeAutowireCandidates";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getPrimaryBeans";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getQualifiedBeans";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "getAnnotatedAutowiredMethods";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "getAnnotatedAutowiredFields";
                break;
            }
            case 31: 
            case 33: 
            case 35: 
            case 36: 
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "autowireByType";
                break;
            }
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "filterByGenerics";
                break;
            }
            case 45: {
                objectArray = objectArray2;
                objectArray2[1] = "getMetaAutowiredAnnotations";
                break;
            }
            case 50: {
                objectArray = objectArray2;
                objectArray2[1] = "filterCandidates";
                break;
            }
            case 52: {
                objectArray = objectArray2;
                objectArray2[1] = "getEffectiveTypes";
                break;
            }
            case 62: 
            case 63: {
                objectArray = objectArray2;
                objectArray2[1] = "filterClassRelatedModels";
                break;
            }
            case 66: 
            case 67: {
                objectArray = objectArray2;
                objectArray2[1] = "excludeOverridenDefaultBeans";
                break;
            }
            case 69: {
                objectArray = objectArray2;
                objectArray2[1] = "excludeTheSameIdentifyingElements";
                break;
            }
            case 71: 
            case 72: {
                objectArray = objectArray2;
                objectArray2[1] = "excludeExplicitlyRedefined";
                break;
            }
            case 77: 
            case 78: 
            case 79: 
            case 80: {
                objectArray = objectArray2;
                objectArray2[1] = "getAutowiredBeansFor";
                break;
            }
            case 83: 
            case 84: {
                objectArray = objectArray2;
                objectArray2[1] = "getByTypeAutowiredBeans";
                break;
            }
            case 88: {
                objectArray = objectArray2;
                objectArray2[1] = "getQualifiedAutowiredBeans";
                break;
            }
            case 99: {
                objectArray = objectArray2;
                objectArray2[1] = "filterPointersByAutowiredType";
                break;
            }
            case 102: {
                objectArray = objectArray2;
                objectArray2[1] = "getQualifiedBeanPointers";
                break;
            }
            case 109: {
                objectArray = objectArray2;
                objectArray2[1] = "getIterableBeanPointers";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "excludeAutowireCandidates";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 15: 
            case 16: 
            case 27: 
            case 29: 
            case 31: 
            case 33: 
            case 35: 
            case 36: 
            case 37: 
            case 40: 
            case 45: 
            case 50: 
            case 52: 
            case 62: 
            case 63: 
            case 66: 
            case 67: 
            case 69: 
            case 71: 
            case 72: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 83: 
            case 84: 
            case 88: 
            case 99: 
            case 102: 
            case 109: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getPrimaryBeans";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isMyName";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getAutowireAnnotationProperties";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "addAutowiredBeans";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getQualifiedBeans";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getQualifiedAnnotation";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getAutowiredAnnotation";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getResourceAnnotation";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "isAutowiredByAnnotation";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "isInjectionPoint";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "isDefaultStereotypeComponentConstructor";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "isStereotypeBean";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "isRequired";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "getAnnotatedAutowiredMethods";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "getAnnotatedAutowiredFields";
                break;
            }
            case 30: 
            case 32: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "autowireByType";
                break;
            }
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "filterByGenerics";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "isAssignable";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "getAutowiredEffectiveBeanTypes";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "isAutowiredByDefault";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "getMetaAutowiredAnnotations";
                break;
            }
            case 46: 
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "getAutowiredMembers";
                break;
            }
            case 48: 
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "filterCandidates";
                break;
            }
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "getEffectiveTypes";
                break;
            }
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "isUsingAutowiredPostProcessor";
                break;
            }
            case 54: 
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "addAutowiredAnnotationType";
                break;
            }
            case 56: 
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "addAutowiredAnnotationTypes";
                break;
            }
            case 58: 
            case 59: {
                objectArray = objectArray;
                objectArray[2] = "addNotNullValues";
                break;
            }
            case 60: 
            case 61: {
                objectArray = objectArray;
                objectArray[2] = "filterClassRelatedModels";
                break;
            }
            case 64: {
                objectArray = objectArray;
                objectArray[2] = "isEmptyModel";
                break;
            }
            case 65: {
                objectArray = objectArray;
                objectArray[2] = "excludeOverridenDefaultBeans";
                break;
            }
            case 68: {
                objectArray = objectArray;
                objectArray[2] = "excludeTheSameIdentifyingElements";
                break;
            }
            case 70: {
                objectArray = objectArray;
                objectArray[2] = "excludeExplicitlyRedefined";
                break;
            }
            case 73: {
                objectArray = objectArray;
                objectArray[2] = "isJavaUtilOptional";
                break;
            }
            case 74: 
            case 75: 
            case 76: {
                objectArray = objectArray;
                objectArray[2] = "getAutowiredBeansFor";
                break;
            }
            case 81: 
            case 82: {
                objectArray = objectArray;
                objectArray[2] = "getByTypeAutowiredBeans";
                break;
            }
            case 85: 
            case 86: 
            case 87: {
                objectArray = objectArray;
                objectArray[2] = "getQualifiedAutowiredBeans";
                break;
            }
            case 89: 
            case 90: 
            case 91: {
                objectArray = objectArray;
                objectArray[2] = "getResourceAutowiredBean";
                break;
            }
            case 92: 
            case 93: {
                objectArray = objectArray;
                objectArray[2] = "findBeanByImplicitInjectionPointName";
                break;
            }
            case 94: {
                objectArray = objectArray;
                objectArray[2] = "getEffectiveQualifiedAnnotation";
                break;
            }
            case 95: 
            case 96: {
                objectArray = objectArray;
                objectArray[2] = "getByNameAutowiredBean";
                break;
            }
            case 97: 
            case 98: {
                objectArray = objectArray;
                objectArray[2] = "filterPointersByAutowiredType";
                break;
            }
            case 100: 
            case 101: {
                objectArray = objectArray;
                objectArray[2] = "getQualifiedBeanPointers";
                break;
            }
            case 103: 
            case 104: {
                objectArray = objectArray;
                objectArray[2] = "canBeAutowiredByType";
                break;
            }
            case 105: 
            case 106: {
                objectArray = objectArray;
                objectArray[2] = "isObjectFactoryEffectiveType";
                break;
            }
            case 107: 
            case 108: {
                objectArray = objectArray;
                objectArray[2] = "getIterableBeanPointers";
                break;
            }
            case 110: {
                objectArray = objectArray;
                objectArray[2] = "getIterableSearchType";
                break;
            }
            case 111: {
                objectArray = objectArray;
                objectArray[2] = "getIterableType";
                break;
            }
            case 112: {
                objectArray = objectArray;
                objectArray[2] = "getQualifiedBeanName";
                break;
            }
            case 113: {
                objectArray = objectArray;
                objectArray[2] = "isTypedMapWithStringKey";
                break;
            }
            case 114: {
                objectArray = objectArray;
                objectArray[2] = "lambda$filterCandidates$1";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 15: 
            case 16: 
            case 27: 
            case 29: 
            case 31: 
            case 33: 
            case 35: 
            case 36: 
            case 37: 
            case 40: 
            case 45: 
            case 50: 
            case 52: 
            case 62: 
            case 63: 
            case 66: 
            case 67: 
            case 69: 
            case 71: 
            case 72: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 83: 
            case 84: 
            case 88: 
            case 99: 
            case 102: 
            case 109: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

