/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.jam.testContexts;

import com.intellij.jam.JamService;
import com.intellij.jam.reflect.JamMemberMeta;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.xml.XmlFile;
import com.intellij.semantic.SemService;
import com.intellij.spring.CommonSpringModel;
import com.intellij.spring.SpringLocalModelFactory;
import com.intellij.spring.contexts.model.SpringModel;
import com.intellij.spring.contexts.model.XmlSpringModel;
import com.intellij.spring.impl.SpringCombinedModelFactory;
import com.intellij.spring.model.custom.CustomComponentsDiscovererHelper;
import com.intellij.spring.model.jam.testContexts.ContextConfiguration;
import com.intellij.spring.model.jam.testContexts.SpringContextConfiguration;
import com.intellij.spring.model.jam.testContexts.SpringContextHierarchy;
import com.intellij.spring.model.jam.testContexts.SpringTestContextUtil;
import com.intellij.spring.model.jam.testContexts.SpringTestingImplicitContextsProvider;
import com.intellij.spring.model.jam.testContexts.profiles.SpringActiveProfile;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

class SpringTestingModel
extends SpringModel {
    private Set<String> myActiveProfiles;
    private final PsiClass myTestClass;

    SpringTestingModel(@NotNull PsiClass testClass, @NotNull Module module) {
        if (testClass == null) {
            SpringTestingModel.$$$reportNull$$$0(0);
        }
        if (module == null) {
            SpringTestingModel.$$$reportNull$$$0(1);
        }
        super(module);
        this.myTestClass = testClass;
    }

    @Override
    @NotNull
    public Module getModule() {
        Module module = super.getModule();
        if (module == null) {
            SpringTestingModel.$$$reportNull$$$0(2);
        }
        return module;
    }

    @Override
    @NotNull
    public Set<String> getActiveProfiles() {
        if (this.myActiveProfiles == null) {
            this.myActiveProfiles = this.discoverTestContextActiveProfiles();
        }
        Set<String> set = this.myActiveProfiles;
        if (set == null) {
            SpringTestingModel.$$$reportNull$$$0(3);
        }
        return set;
    }

    @Override
    @NotNull
    public Set<CommonSpringModel> getRelatedModels(boolean checkActiveProfiles) {
        LinkedHashSet testConfigurations = ContainerUtil.newLinkedHashSet();
        LinkedHashSet appContexts = ContainerUtil.newLinkedHashSet();
        LinkedHashSet configurationContexts = ContainerUtil.newLinkedHashSet();
        SpringTestContextUtil testContextUtil = SpringTestContextUtil.getInstance();
        InheritanceUtil.processSupers((PsiClass)this.myTestClass, (boolean)true, psiClass -> {
            ProgressManager.checkCanceled();
            if ("java.lang.Object".equals(psiClass.getQualifiedName())) {
                return true;
            }
            testConfigurations.addAll(SpringTestingModel.getConfigurations(psiClass));
            return true;
        });
        for (ContextConfiguration contextConfiguration : testConfigurations) {
            testContextUtil.discoverConfigFiles(contextConfiguration, appContexts, configurationContexts, contextConfiguration.getPsiElement(), this.myTestClass);
        }
        Set<String> activeProfiles = this.getActiveProfiles();
        LinkedHashSet models = ContainerUtil.newLinkedHashSet();
        Module module = this.getModule();
        if (!appContexts.isEmpty()) {
            XmlSpringModel xmlModel = SpringCombinedModelFactory.createXmlModel((Collection<XmlFile>)appContexts, module, activeProfiles);
            ContainerUtil.addIfNotNull((Collection)models, (Object)xmlModel);
        }
        for (PsiClass context : configurationContexts) {
            ContainerUtil.addIfNotNull((Collection)models, (Object)SpringLocalModelFactory.getInstance().getOrCreateLocalAnnotationModel(context, this.getModule(), activeProfiles));
        }
        if (!module.isDisposed()) {
            ContainerUtil.addAllNotNull((Collection)models, CustomComponentsDiscovererHelper.getInstance(module).getCustomModels());
        }
        for (ContextConfiguration configuration : testConfigurations) {
            for (SpringTestingImplicitContextsProvider provider : SpringTestingImplicitContextsProvider.EP_NAME.getExtensionList()) {
                models.addAll(provider.getModels(this.getModule(), configuration));
            }
        }
        LinkedHashSet linkedHashSet = models;
        if (linkedHashSet == null) {
            SpringTestingModel.$$$reportNull$$$0(4);
        }
        return linkedHashSet;
    }

    @NotNull
    private static Set<ContextConfiguration> getConfigurations(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            SpringTestingModel.$$$reportNull$$$0(5);
        }
        LinkedHashSet<ContextConfiguration> configurations = new LinkedHashSet<ContextConfiguration>(2);
        configurations.addAll(SemService.getSemService((Project)psiClass.getProject()).getSemElements(ContextConfiguration.CONTEXT_CONFIGURATION_JAM_KEY, (PsiElement)psiClass));
        SpringContextHierarchy hierarchyConfiguration = (SpringContextHierarchy)JamService.getJamService((Project)psiClass.getProject()).getJamElement((PsiElement)psiClass, new JamMemberMeta[]{SpringContextHierarchy.META});
        if (hierarchyConfiguration != null) {
            configurations.addAll(hierarchyConfiguration.getContextConfigurations());
        }
        LinkedHashSet<ContextConfiguration> linkedHashSet = configurations;
        if (linkedHashSet == null) {
            SpringTestingModel.$$$reportNull$$$0(6);
        }
        return linkedHashSet;
    }

    @NotNull
    private Set<String> discoverTestContextActiveProfiles() {
        LinkedHashSet<String> activeProfiles = new LinkedHashSet<String>();
        InheritanceUtil.processSupers((PsiClass)this.myTestClass, (boolean)true, psiClass -> {
            if ("java.lang.Object".equals(psiClass.getQualifiedName())) {
                return true;
            }
            SpringActiveProfile profiles = SpringContextConfiguration.getSpringActiveProfiles(psiClass);
            if (profiles != null) {
                activeProfiles.addAll(profiles.getActiveProfiles());
            }
            return true;
        });
        LinkedHashSet<String> linkedHashSet = activeProfiles;
        if (linkedHashSet == null) {
            SpringTestingModel.$$$reportNull$$$0(7);
        }
        return linkedHashSet;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testClass";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/model/jam/testContexts/SpringTestingModel";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiClass";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/model/jam/testContexts/SpringTestingModel";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getModule";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getActiveProfiles";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getRelatedModels";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfigurations";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "discoverTestContextActiveProfiles";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getConfigurations";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

