/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.highlighting.jam;

import com.intellij.codeInspection.AbstractBaseUastLocalInspectionTool;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.spring.SpringLibraryUtil;
import com.intellij.spring.model.utils.SpringCommonUtils;
import com.intellij.spring.model.utils.SpringModelUtils;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UElement;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u0010\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u000eH\u0004J\u0012\u0010\u000f\u001a\u00020\b2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0004\u00a8\u0006\u0012"}, d2={"Lcom/intellij/spring/model/highlighting/jam/SpringUastInspectionBase;", "Lcom/intellij/codeInspection/AbstractBaseUastLocalInspectionTool;", "()V", "buildVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "isEnabledForProject", "project", "Lcom/intellij/openapi/project/Project;", "isInSpringEnabledModule", "uElement", "Lorg/jetbrains/uast/UElement;", "isSpringEnabledModule", "module", "Lcom/intellij/openapi/module/Module;", "intellij.spring"})
public abstract class SpringUastInspectionBase
extends AbstractBaseUastLocalInspectionTool {
    @NotNull
    public final PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        Intrinsics.checkParameterIsNotNull((Object)holder, (String)"holder");
        Project project = holder.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"holder.project");
        if (!this.isEnabledForProject(project)) {
            PsiElementVisitor psiElementVisitor = PsiElementVisitor.EMPTY_VISITOR;
            Intrinsics.checkExpressionValueIsNotNull((Object)psiElementVisitor, (String)"PsiElementVisitor.EMPTY_VISITOR");
            return psiElementVisitor;
        }
        PsiElementVisitor psiElementVisitor = super.buildVisitor(holder, isOnTheFly);
        Intrinsics.checkExpressionValueIsNotNull((Object)psiElementVisitor, (String)"super.buildVisitor(holder, isOnTheFly)");
        return psiElementVisitor;
    }

    public boolean isEnabledForProject(@NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        return SpringLibraryUtil.hasSpringLibrary(project);
    }

    protected final boolean isInSpringEnabledModule(@NotNull UElement uElement) {
        Intrinsics.checkParameterIsNotNull((Object)uElement, (String)"uElement");
        PsiElement psiElement = uElement.getJavaPsi();
        if (psiElement == null) {
            return false;
        }
        PsiElement psi = psiElement;
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)psi);
        if (module == null) {
            return false;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)module, (String)"ModuleUtilCore.findModul\u2026ment(psi) ?: return false");
        Module module2 = module;
        return this.isSpringEnabledModule(module2);
    }

    protected final boolean isSpringEnabledModule(@Nullable Module module) {
        if (module == null) {
            return false;
        }
        return SpringCommonUtils.hasSpringFacet(module) || SpringModelUtils.getInstance().hasAutoConfiguredModels(module);
    }
}

