/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.highlighting.config;

import com.intellij.codeInspection.LocalQuickFixOnPsiElement;
import com.intellij.facet.Facet;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ui.configuration.ModulesConfigurator;
import com.intellij.openapi.ui.Messages;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.spring.facet.SpringFacet;
import com.intellij.spring.facet.SpringFileSet;
import com.intellij.spring.facet.SpringFileSetService;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

class SetupProgrammaticContextFix
extends LocalQuickFixOnPsiElement {
    SetupProgrammaticContextFix(@NotNull PsiElement element) {
        if (element == null) {
            SetupProgrammaticContextFix.$$$reportNull$$$0(0);
        }
        super(element);
    }

    public boolean startInWriteAction() {
        return false;
    }

    @NotNull
    public String getText() {
        if ("Setup Spring context..." == null) {
            SetupProgrammaticContextFix.$$$reportNull$$$0(1);
        }
        return "Setup Spring context...";
    }

    @NotNull
    public String getFamilyName() {
        String string = this.getText();
        if (string == null) {
            SetupProgrammaticContextFix.$$$reportNull$$$0(2);
        }
        return string;
    }

    public void invoke(@NotNull Project project, @NotNull PsiFile file, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        if (project == null) {
            SetupProgrammaticContextFix.$$$reportNull$$$0(3);
        }
        if (file == null) {
            SetupProgrammaticContextFix.$$$reportNull$$$0(4);
        }
        if (startElement == null) {
            SetupProgrammaticContextFix.$$$reportNull$$$0(5);
        }
        if (endElement == null) {
            SetupProgrammaticContextFix.$$$reportNull$$$0(6);
        }
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)file);
        assert (module != null);
        SpringFacet springFacet = SpringFacet.getInstance(module);
        assert (springFacet != null);
        SpringFileSet fileSet = SetupProgrammaticContextFix.createFileSet(startElement, springFacet);
        int dialog = Messages.showYesNoDialog((Project)project, (String)("Context with name '" + fileSet.getName() + "' has been created.\nPlease use inspection suppression to disable highlighting.\n\nTo re-modelVisitor context, delete it in Spring facet and remove inspection suppression.\n\nDo you want to open Spring facet now?"), (String)"Spring", null);
        if (dialog == 0) {
            ModulesConfigurator.showFacetSettingsDialog((Facet)springFacet, null);
        }
    }

    private static SpringFileSet createFileSet(PsiElement startElement, SpringFacet springFacet) {
        SpringFileSetService fileSetService = SpringFileSetService.getInstance();
        Set<SpringFileSet> existingFileSets = springFacet.getFileSets();
        String id = fileSetService.getUniqueId(existingFileSets);
        PsiClass psiClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)startElement, PsiClass.class);
        PsiMethod psiMethod = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)startElement, PsiMethod.class);
        String codeLocation = (psiClass != null ? psiClass.getName() : startElement.getContainingFile().getName()) + (psiMethod != null ? ":" + psiMethod.getName() : "");
        String name = fileSetService.getUniqueName("Programmatic Context " + codeLocation, existingFileSets);
        return springFacet.addFileSet(id, name);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/model/highlighting/config/SetupProgrammaticContextFix";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "startElement";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "endElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/model/highlighting/config/SetupProgrammaticContextFix";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

