/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.highlighting.autowire;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInspection.AbstractBaseUastLocalInspectionTool;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.jam.JamService;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.search.searches.ClassInheritorsSearch;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.spring.SpringBundle;
import com.intellij.spring.java.SpringJavaClassInfo;
import com.intellij.spring.model.jam.testContexts.ContextConfiguration;
import com.intellij.spring.model.jam.testContexts.SpringTestContextUtil;
import com.intellij.spring.model.utils.SpringCommonUtils;
import com.intellij.spring.model.utils.SpringModelUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UAnnotation;
import org.jetbrains.uast.UAnnotationKt;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UElementKt;
import org.jetbrains.uast.UastContextKt;

public class SpringUastAutowiredMembersInspection
extends AbstractBaseUastLocalInspectionTool {
    @Nullable
    public ProblemDescriptor[] checkClass(@NotNull UClass uClass, @NotNull InspectionManager manager, boolean isOnTheFly) {
        PsiClass aClass;
        if (uClass == null) {
            SpringUastAutowiredMembersInspection.$$$reportNull$$$0(0);
        }
        if (manager == null) {
            SpringUastAutowiredMembersInspection.$$$reportNull$$$0(1);
        }
        if ((aClass = (PsiClass)UElementKt.getAsJavaPsiElement((UElement)uClass, PsiClass.class)) == null) {
            return null;
        }
        PsiElement sourcePsiElement = UElementKt.getSourcePsiElement((UElement)uClass);
        if (sourcePsiElement == null) {
            return null;
        }
        if (!SpringCommonUtils.isSpringBeanCandidateClassInSpringProject(aClass)) {
            return null;
        }
        if (InheritanceUtil.isInheritor((PsiClass)aClass, (String)"org.springframework.web.context.support.SpringBeanAutowiringSupport")) {
            return null;
        }
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)aClass);
        if (module != null && (SpringCommonUtils.hasSpringFacet(module) || SpringModelUtils.getInstance().hasAutoConfiguredModels(module))) {
            ProblemsHolder holder = new ProblemsHolder(manager, sourcePsiElement.getContainingFile(), isOnTheFly);
            SpringJavaClassInfo info = SpringJavaClassInfo.getSpringJavaClassInfo(aClass);
            if (!(info.isStereotypeJavaBean() || SpringUastAutowiredMembersInspection.isSpringComponent(aClass, info) || SpringTestContextUtil.getInstance().isTestContextConfigurationClass(aClass) || SpringUastAutowiredMembersInspection.constraintValidator(aClass))) {
                for (PsiField psiField : aClass.getFields()) {
                    SpringUastAutowiredMembersInspection.checkMemberIsNotAutowired(holder, (PsiMember)psiField);
                }
                for (PsiField psiField : aClass.getMethods()) {
                    SpringUastAutowiredMembersInspection.checkMemberIsNotAutowired(holder, (PsiMember)psiField);
                }
            }
            return holder.getResultsArray();
        }
        return null;
    }

    private static boolean constraintValidator(@NotNull PsiClass aClass) {
        if (aClass == null) {
            SpringUastAutowiredMembersInspection.$$$reportNull$$$0(2);
        }
        return InheritanceUtil.isInheritor((PsiClass)aClass, (String)"javax.validation.ConstraintValidator");
    }

    private static void checkMemberIsNotAutowired(ProblemsHolder holder, PsiMember psiMember) {
        PsiAnnotation annotation = AnnotationUtil.findAnnotation((PsiModifierListOwner)psiMember, (boolean)true, (String[])new String[]{"org.springframework.beans.factory.annotation.Autowired"});
        if (annotation == null) {
            return;
        }
        PsiElement elementToReport = UAnnotationKt.getNamePsiElement((UAnnotation)((UAnnotation)UastContextKt.toUElement((PsiElement)annotation, UAnnotation.class)));
        if (elementToReport == null) {
            return;
        }
        holder.registerProblem(elementToReport, SpringBundle.message("class.is.not.spring.bean.autowired", new Object[0]), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[0]);
    }

    private static boolean isSpringComponent(@NotNull PsiClass aClass, @NotNull SpringJavaClassInfo info) {
        if (aClass == null) {
            SpringUastAutowiredMembersInspection.$$$reportNull$$$0(3);
        }
        if (info == null) {
            SpringUastAutowiredMembersInspection.$$$reportNull$$$0(4);
        }
        return info.isMapped() || SpringUastAutowiredMembersInspection.isJamSpringComponent(aClass) || SpringUastAutowiredMembersInspection.isAbstractBaseComponent(aClass);
    }

    private static boolean isJamSpringComponent(@NotNull PsiClass aClass) {
        if (aClass == null) {
            SpringUastAutowiredMembersInspection.$$$reportNull$$$0(5);
        }
        JamService jamService = JamService.getJamService((Project)aClass.getProject());
        return SpringCommonUtils.isStereotypeComponentOrMeta(aClass) || jamService.getJamElement(ContextConfiguration.CONTEXT_CONFIGURATION_JAM_KEY, (PsiElement)aClass) != null || SpringUastAutowiredMembersInspection.isAbstractConfiguration(aClass) || AnnotationUtil.isAnnotated((PsiModifierListOwner)aClass, (String)"javax.servlet.annotation.WebServlet", (int)1) || AnnotationUtil.isAnnotated((PsiModifierListOwner)aClass, (String)"org.springframework.test.context.ContextHierarchy", (int)1) || AnnotationUtil.isAnnotated((PsiModifierListOwner)aClass, (String)"org.springframework.beans.factory.annotation.Configurable", (int)1) || InheritanceUtil.isInheritor((PsiClass)aClass, (String)"org.springframework.data.repository.Repository");
    }

    private static boolean isAbstractConfiguration(@NotNull PsiClass aClass) {
        if (aClass == null) {
            SpringUastAutowiredMembersInspection.$$$reportNull$$$0(6);
        }
        return aClass.hasModifierProperty("abstract") && AnnotationUtil.isAnnotated((PsiModifierListOwner)aClass, (String)"org.springframework.context.annotation.Configuration", (int)1);
    }

    private static boolean isAbstractBaseComponent(@NotNull PsiClass aClass) {
        if (aClass == null) {
            SpringUastAutowiredMembersInspection.$$$reportNull$$$0(7);
        }
        Ref ref = new Ref();
        ref.set((Object)false);
        PsiModifierList modifierList = aClass.getModifierList();
        if (modifierList != null && modifierList.hasModifierProperty("abstract")) {
            ClassInheritorsSearch.search((PsiClass)aClass).forEach(psiClass -> {
                if (SpringUastAutowiredMembersInspection.isJamSpringComponent(psiClass)) {
                    ref.set((Object)true);
                    return false;
                }
                return true;
            });
        }
        return (Boolean)ref.get();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "uClass";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
        }
        objectArray2[1] = "com/intellij/spring/model/highlighting/autowire/SpringUastAutowiredMembersInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "checkClass";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "constraintValidator";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "isSpringComponent";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "isJamSpringComponent";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "isAbstractConfiguration";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "isAbstractBaseComponent";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

