/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.events.jam;

import com.intellij.jam.JamService;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiType;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.MethodReferencesSearch;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.spring.model.events.beans.PublishEventPointDescriptor;
import com.intellij.spring.model.events.jam.CustomSpringEventListener;
import com.intellij.spring.model.events.jam.SpringEventListener;
import com.intellij.spring.model.events.jam.SpringJamEventListener;
import com.intellij.spring.model.jam.utils.JamAnnotationTypeUtil;
import com.intellij.spring.model.utils.SpringCommonUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UastContextKt;
import org.jetbrains.uast.UastUtils;

public class SpringEventModelUtils {
    private static final String PUBLISH_EVENT_METHOD = "publishEvent";

    @NotNull
    public static Collection<PublishEventPointDescriptor> getPublishPoints(@NotNull Module module, @NotNull GlobalSearchScope scope, @NotNull PsiType handledType) {
        if (module == null) {
            SpringEventModelUtils.$$$reportNull$$$0(0);
        }
        if (scope == null) {
            SpringEventModelUtils.$$$reportNull$$$0(1);
        }
        if (handledType == null) {
            SpringEventModelUtils.$$$reportNull$$$0(2);
        }
        List<PublishEventPointDescriptor> list = SpringEventModelUtils.filter(SpringEventModelUtils.getPublishPoints(module, scope), handledType);
        if (list == null) {
            SpringEventModelUtils.$$$reportNull$$$0(3);
        }
        return list;
    }

    @NotNull
    private static Set<PublishEventPointDescriptor> getPublishPoints(@NotNull Module module, @NotNull GlobalSearchScope scope) {
        if (module == null) {
            SpringEventModelUtils.$$$reportNull$$$0(4);
        }
        if (scope == null) {
            SpringEventModelUtils.$$$reportNull$$$0(5);
        }
        LinkedHashSet descriptors = ContainerUtil.newLinkedHashSet();
        for (PsiMethod publishEventMethod : SpringEventModelUtils.getPublishEventMethods(module)) {
            descriptors.addAll(SpringEventModelUtils.searchAndCachePublishPoints(publishEventMethod, (SearchScope)scope));
        }
        descriptors.addAll(SpringEventModelUtils.searchEventListenerDescriptors(module, scope));
        LinkedHashSet linkedHashSet = descriptors;
        if (linkedHashSet == null) {
            SpringEventModelUtils.$$$reportNull$$$0(6);
        }
        return linkedHashSet;
    }

    private static PsiMethod[] getPublishEventMethods(@NotNull Module module) {
        PsiClass eventPublisherClass;
        if (module == null) {
            SpringEventModelUtils.$$$reportNull$$$0(7);
        }
        if ((eventPublisherClass = SpringCommonUtils.findLibraryClass(module, "org.springframework.context.ApplicationEventPublisher")) != null) {
            return eventPublisherClass.findMethodsByName(PUBLISH_EVENT_METHOD, false);
        }
        return PsiMethod.EMPTY_ARRAY;
    }

    private static List<PublishEventPointDescriptor> filter(@NotNull Set<PublishEventPointDescriptor> allDescriptors, @NotNull PsiType eventType) {
        if (allDescriptors == null) {
            SpringEventModelUtils.$$$reportNull$$$0(8);
        }
        if (eventType == null) {
            SpringEventModelUtils.$$$reportNull$$$0(9);
        }
        return ContainerUtil.filter(allDescriptors, descriptor -> {
            PsiType publishType;
            if (eventType == null) {
                SpringEventModelUtils.$$$reportNull$$$0(34);
            }
            return (publishType = descriptor.getEventType()) != null && eventType.isAssignableFrom(publishType);
        });
    }

    @NotNull
    public static List<SpringEventListener> getEventListeners(@NotNull Module module, @NotNull GlobalSearchScope scope, @NotNull PsiType publishType) {
        if (module == null) {
            SpringEventModelUtils.$$$reportNull$$$0(10);
        }
        if (scope == null) {
            SpringEventModelUtils.$$$reportNull$$$0(11);
        }
        if (publishType == null) {
            SpringEventModelUtils.$$$reportNull$$$0(12);
        }
        List list = ContainerUtil.filter(SpringEventModelUtils.getEventListeners(module, scope), listener2 -> {
            if (publishType == null) {
                SpringEventModelUtils.$$$reportNull$$$0(33);
            }
            for (PsiType eventType : SpringEventModelUtils.getEventListenerHandledType(listener2)) {
                if (!eventType.isAssignableFrom(publishType)) continue;
                return true;
            }
            return false;
        });
        if (list == null) {
            SpringEventModelUtils.$$$reportNull$$$0(13);
        }
        return list;
    }

    @NotNull
    private static List<SpringEventListener> getEventListeners(@NotNull Module module, @NotNull GlobalSearchScope scope) {
        if (module == null) {
            SpringEventModelUtils.$$$reportNull$$$0(14);
        }
        if (scope == null) {
            SpringEventModelUtils.$$$reportNull$$$0(15);
        }
        LinkedList result = ContainerUtil.newLinkedList();
        JamService service = JamService.getJamService((Project)module.getProject());
        result.addAll(service.getJamMethodElements(SpringJamEventListener.SEM_KEY, "org.springframework.context.event.EventListener", scope));
        List customAnnos = ContainerUtil.mapNotNull(JamAnnotationTypeUtil.getInstance(module).getAnnotationTypesWithChildren("org.springframework.context.event.EventListener"), PsiClass::getQualifiedName);
        for (String customAnno : customAnnos) {
            result.addAll(service.getJamMethodElements(CustomSpringEventListener.JAM_KEY, customAnno, scope));
        }
        LinkedList linkedList = result;
        if (linkedList == null) {
            SpringEventModelUtils.$$$reportNull$$$0(16);
        }
        return linkedList;
    }

    @NotNull
    private static Set<PublishEventPointDescriptor> searchEventListenerDescriptors(@NotNull Module module, GlobalSearchScope scope) {
        if (module == null) {
            SpringEventModelUtils.$$$reportNull$$$0(17);
        }
        HashSet descriptors = ContainerUtil.newHashSet();
        for (SpringEventListener listener2 : SpringEventModelUtils.getEventListeners(module, scope)) {
            PsiMethod psiMethod = listener2.getPsiElement();
            PsiType returnType = psiMethod.getReturnType();
            if (returnType == null || PsiType.VOID.equals((Object)returnType)) continue;
            descriptors.add(PublishEventPointDescriptor.create(psiMethod));
        }
        HashSet hashSet = descriptors;
        if (hashSet == null) {
            SpringEventModelUtils.$$$reportNull$$$0(18);
        }
        return hashSet;
    }

    @NotNull
    private static Set<PublishEventPointDescriptor> searchAndCachePublishPoints(@NotNull PsiMethod publishEventMethod, @NotNull SearchScope searchScope) {
        if (publishEventMethod == null) {
            SpringEventModelUtils.$$$reportNull$$$0(19);
        }
        if (searchScope == null) {
            SpringEventModelUtils.$$$reportNull$$$0(20);
        }
        Set set = (Set)CachedValuesManager.getCachedValue((PsiElement)publishEventMethod, () -> {
            if (publishEventMethod == null) {
                SpringEventModelUtils.$$$reportNull$$$0(31);
            }
            if (searchScope == null) {
                SpringEventModelUtils.$$$reportNull$$$0(32);
            }
            return CachedValueProvider.Result.create(SpringEventModelUtils.searchPublishPoints(publishEventMethod, searchScope), (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT});
        });
        if (set == null) {
            SpringEventModelUtils.$$$reportNull$$$0(21);
        }
        return set;
    }

    @NotNull
    private static Set<PublishEventPointDescriptor> searchPublishPoints(@NotNull PsiMethod publishEventMethod, @NotNull SearchScope searchScope) {
        if (publishEventMethod == null) {
            SpringEventModelUtils.$$$reportNull$$$0(22);
        }
        if (searchScope == null) {
            SpringEventModelUtils.$$$reportNull$$$0(23);
        }
        LinkedHashSet set = ContainerUtil.newLinkedHashSet();
        MethodReferencesSearch.search((PsiMethod)publishEventMethod, (SearchScope)searchScope, (boolean)true).forEach(psiReference -> {
            List arguments;
            UElement expression;
            UCallExpression callExpression;
            if (set == null) {
                SpringEventModelUtils.$$$reportNull$$$0(30);
            }
            if ((callExpression = UastUtils.getUCallExpression((UElement)(expression = UastContextKt.toUElement((PsiElement)psiReference.getElement())))) != null && (arguments = callExpression.getValueArguments()).size() == 1) {
                set.add(PublishEventPointDescriptor.create((UExpression)arguments.get(0)));
            }
            return true;
        });
        LinkedHashSet linkedHashSet = set;
        if (linkedHashSet == null) {
            SpringEventModelUtils.$$$reportNull$$$0(24);
        }
        return linkedHashSet;
    }

    @NotNull
    public static Collection<PsiType> getEventListenerHandledType(@NotNull SpringEventListener eventListener) {
        PsiMethod psiMethod;
        if (eventListener == null) {
            SpringEventModelUtils.$$$reportNull$$$0(25);
        }
        if ((psiMethod = eventListener.getPsiElement()) != null) {
            PsiParameter[] parameters = psiMethod.getParameterList().getParameters();
            if (parameters.length == 1) {
                Set<PsiType> set = Collections.singleton(parameters[0].getType());
                if (set == null) {
                    SpringEventModelUtils.$$$reportNull$$$0(26);
                }
                return set;
            }
            if (parameters.length == 0) {
                List list = ContainerUtil.mapNotNull(eventListener.getEventListenerClasses(), PsiTypesUtil::getClassType);
                if (list == null) {
                    SpringEventModelUtils.$$$reportNull$$$0(27);
                }
                return list;
            }
        }
        Set<PsiType> set = Collections.emptySet();
        if (set == null) {
            SpringEventModelUtils.$$$reportNull$$$0(28);
        }
        return set;
    }

    public static boolean isPublishEventExpression(@NotNull UCallExpression psiElement) {
        PsiMethod element;
        if (psiElement == null) {
            SpringEventModelUtils.$$$reportNull$$$0(29);
        }
        if (PUBLISH_EVENT_METHOD.equals(psiElement.getMethodName()) && (element = psiElement.resolve()) != null) {
            PsiClass containingClass = element.getContainingClass();
            return containingClass != null && InheritanceUtil.isInheritor((PsiClass)containingClass, (String)"org.springframework.context.ApplicationEventPublisher");
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 6: 
            case 13: 
            case 16: 
            case 18: 
            case 21: 
            case 24: 
            case 26: 
            case 27: 
            case 28: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 6: 
            case 13: 
            case 16: 
            case 18: 
            case 21: 
            case 24: 
            case 26: 
            case 27: 
            case 28: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 1: 
            case 5: 
            case 11: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "handledType";
                break;
            }
            case 3: 
            case 6: 
            case 13: 
            case 16: 
            case 18: 
            case 21: 
            case 24: 
            case 26: 
            case 27: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/model/events/jam/SpringEventModelUtils";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "allDescriptors";
                break;
            }
            case 9: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "eventType";
                break;
            }
            case 12: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "publishType";
                break;
            }
            case 19: 
            case 22: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "publishEventMethod";
                break;
            }
            case 20: 
            case 23: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "searchScope";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "eventListener";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "set";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/model/events/jam/SpringEventModelUtils";
                break;
            }
            case 3: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getPublishPoints";
                break;
            }
            case 13: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getEventListeners";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "searchEventListenerDescriptors";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "searchAndCachePublishPoints";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "searchPublishPoints";
                break;
            }
            case 26: 
            case 27: 
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "getEventListenerHandledType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getPublishPoints";
                break;
            }
            case 3: 
            case 6: 
            case 13: 
            case 16: 
            case 18: 
            case 21: 
            case 24: 
            case 26: 
            case 27: 
            case 28: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getPublishEventMethods";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "filter";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getEventListeners";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "searchEventListenerDescriptors";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "searchAndCachePublishPoints";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "searchPublishPoints";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getEventListenerHandledType";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "isPublishEventExpression";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "lambda$searchPublishPoints$3";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "lambda$searchAndCachePublishPoints$2";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getEventListeners$1";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "lambda$filter$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 6: 
            case 13: 
            case 16: 
            case 18: 
            case 21: 
            case 24: 
            case 26: 
            case 27: 
            case 28: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

