/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.converters;

import com.intellij.spring.model.converters.SpringBeanResolveConverterForDefiniteClasses;
import com.intellij.spring.model.xml.jms.Listener;
import com.intellij.util.xml.ConvertContext;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomUtil;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class JmsListenerResolveConverter
extends SpringBeanResolveConverterForDefiniteClasses {
    @NonNls
    public static final String MESSAGE_LISTENER = "javax.jms.MessageListener";
    @NonNls
    public static final String SESSION_AWARE_LISTENER = "org.springframework.jms.listener.SessionAwareMessageListener";

    @Override
    @NotNull
    protected String[] getClassNames(ConvertContext context) {
        Listener listener2 = (Listener)DomUtil.getParentOfType((DomElement)context.getInvocationElement(), Listener.class, (boolean)false);
        if (listener2 != null && DomUtil.hasXml(listener2.getMethod())) {
            String[] stringArray = new String[]{"java.lang.Object"};
            if (stringArray == null) {
                JmsListenerResolveConverter.$$$reportNull$$$0(0);
            }
            return stringArray;
        }
        String[] stringArray = new String[]{MESSAGE_LISTENER, SESSION_AWARE_LISTENER};
        if (stringArray == null) {
            JmsListenerResolveConverter.$$$reportNull$$$0(1);
        }
        return stringArray;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/converters/JmsListenerResolveConverter", "getClassNames"));
    }
}

