/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.converters;

import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.util.Condition;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.xml.Converter;
import com.intellij.util.xml.GenericDomValue;
import java.util.Collection;
import org.jetbrains.annotations.Nullable;

public class CustomConverterRegistry {
    private static final CustomConverterRegistry ourInstance = new CustomConverterRegistry();
    private final MultiMap<Class, Provider> myCustomConverters = new MultiMap();

    public static CustomConverterRegistry getRegistry() {
        return ourInstance;
    }

    private CustomConverterRegistry() {
        for (Provider provider : Provider.EXTENSION_POINT_NAME.getExtensionList()) {
            this.myCustomConverters.putValue((Object)provider.getConverterClass(), (Object)provider);
        }
    }

    @Nullable
    public Converter getCustomConverter(Class aClass, GenericDomValue context) {
        Collection providers = this.myCustomConverters.get((Object)aClass);
        for (Provider provider : providers) {
            if (!provider.value(context)) continue;
            return provider.getConverter();
        }
        return null;
    }

    public static interface Provider
    extends Condition<GenericDomValue> {
        public static final ExtensionPointName<Provider> EXTENSION_POINT_NAME = ExtensionPointName.create((String)"com.intellij.spring.customConverterProvider");

        public Converter getConverter();

        public Class getConverterClass();
    }
}

