/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.actions.patterns.frameworks.ui;

import com.intellij.facet.ui.FacetEditorsFactory;
import com.intellij.facet.ui.libraries.LibrariesValidationComponent;
import com.intellij.openapi.Disposable;
import com.intellij.spring.model.actions.patterns.frameworks.ui.LibrariesInfo;
import com.intellij.spring.model.actions.patterns.frameworks.ui.TemplateInfo;
import com.intellij.ui.HyperlinkLabel;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import org.jetbrains.annotations.NonNls;

public class ChooseTemplatesForm
implements Disposable {
    private JPanel myChoosePanel;
    private JPanel myTableViewPanel;
    private JPanel myLibsPanel;
    private final List<TemplateInfo> myTemplateInfos;
    private final LibrariesInfo myLibInfo;
    private LibrariesValidationComponent myLibrariesValidationComponent;
    @NonNls
    private static final String JAVADOC = "Javadoc";
    @NonNls
    private static final String DETAILS = "Details";

    public ChooseTemplatesForm(List<TemplateInfo> templates, LibrariesInfo libInfo) {
        this.myLibInfo = libInfo;
        this.$$$setupUI$$$();
        this.myTableViewPanel.setLayout(new GridLayout(templates.size(), 1));
        this.myTemplateInfos = templates;
        for (final TemplateInfo template : this.myTemplateInfos) {
            JPanel checkBoxPanel = new JPanel(new FlowLayout(1, 0, 0));
            final JCheckBox checkBox = new JCheckBox(template.getName());
            checkBox.setSelected(template.isAccepted());
            checkBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    template.setAccepted(checkBox.isSelected());
                }
            });
            checkBoxPanel.add(checkBox);
            if (template.getApiLink() != null || template.getReferenceLink() != null) {
                JBLabel comp = new JBLabel("(", UIUtil.ComponentStyle.SMALL);
                int width = comp.getFontMetrics(comp.getFont()).stringWidth("(");
                int height = comp.getFontMetrics(comp.getFont()).getHeight();
                comp.setPreferredSize(new Dimension(width, height));
                checkBoxPanel.add((Component)comp);
                if (template.getApiLink() != null) {
                    checkBoxPanel.add(ChooseTemplatesForm.getLink(template.getApiLink(), JAVADOC));
                    if (template.getReferenceLink() != null) {
                        checkBoxPanel.add((Component)new JBLabel(",", UIUtil.ComponentStyle.SMALL));
                    }
                }
                checkBoxPanel.add(ChooseTemplatesForm.getLink(template.getReferenceLink(), DETAILS));
                checkBoxPanel.add((Component)new JBLabel(")", UIUtil.ComponentStyle.SMALL));
            }
            JPanel comboPanelWrapper = new JPanel(new BorderLayout());
            comboPanelWrapper.add((Component)checkBoxPanel, "West");
            this.myTableViewPanel.add(comboPanelWrapper);
            FacetEditorsFactory facetEditorsFactory = FacetEditorsFactory.getInstance();
            this.myLibrariesValidationComponent = facetEditorsFactory.createLibrariesValidationComponent(this.myLibInfo.getLibs(), this.myLibInfo.getModule(), this.myLibInfo.getName());
            this.myLibsPanel.add((Component)this.myLibrariesValidationComponent.getComponent(), "Center");
            this.myLibrariesValidationComponent.addValidityListener(new LibrariesValidationComponent.ValidityListener(){

                public void validityChanged(boolean isValid) {
                }
            });
            this.myLibrariesValidationComponent.validate();
        }
    }

    private static JComponent getLink(String linkTarget, String linkText) {
        if (linkTarget == null) {
            return new JLabel();
        }
        HyperlinkLabel hyperlinkLabel = new HyperlinkLabel(linkText);
        hyperlinkLabel.setFont(UIUtil.getLabelFont((UIUtil.FontSize)UIUtil.FontSize.SMALL));
        hyperlinkLabel.setHyperlinkTarget(linkTarget);
        return hyperlinkLabel;
    }

    public void dispose() {
    }

    public List<TemplateInfo> getTemplateInfos() {
        return this.myTemplateInfos;
    }

    public JComponent getComponent() {
        return this.myChoosePanel;
    }

    public LibrariesValidationComponent getLibrariesValidationComponent() {
        return this.myLibrariesValidationComponent;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        JPanel jPanel2;
        JPanel jPanel3;
        this.myChoosePanel = jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(3, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        Spacer spacer = new Spacer();
        jPanel3.add((Component)spacer, new GridConstraints(2, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        this.myTableViewPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(5, 5, 5, 5), -1, -1, false, false));
        jPanel2.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithIndent");
        jPanel3.add((Component)jPanel2, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        jPanel2.setBorder(IdeBorderFactory.PlainSmallWithIndent.createTitledBorder((Border)BorderFactory.createEtchedBorder(), (String)"Beans", (int)0, (int)0, null, null));
        this.myLibsPanel = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        jPanel3.add((Component)jPanel, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myChoosePanel;
    }
}

