/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.actions;

import com.google.gson.GsonBuilder;
import com.intellij.jam.model.util.JamCommonUtil;
import com.intellij.json.JsonFileType;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.pointers.VirtualFilePointer;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassOwner;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.xml.XmlFile;
import com.intellij.spring.SpringLocalModelFactory;
import com.intellij.spring.contexts.model.LocalAnnotationModel;
import com.intellij.spring.contexts.model.LocalModel;
import com.intellij.spring.contexts.model.LocalXmlModel;
import com.intellij.spring.contexts.model.graph.LocalModelDependency;
import com.intellij.spring.dom.SpringDomUtils;
import com.intellij.spring.facet.SpringFacet;
import com.intellij.spring.facet.SpringFileSet;
import com.intellij.spring.facet.SpringFileSetService;
import com.intellij.spring.model.utils.SpringCommonUtils;
import com.intellij.spring.model.wrappers.SpringWFacet;
import com.intellij.spring.model.wrappers.WFileset;
import com.intellij.spring.model.wrappers.WModel;
import com.intellij.spring.model.wrappers.WModule;
import com.intellij.spring.model.wrappers.WProject;
import com.intellij.spring.model.wrappers.WSpringDependency;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.DateFormatUtil;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class DumpSpringConfigurationAction
extends AnAction {
    public void update(@NotNull AnActionEvent e) {
        Project project;
        if (e == null) {
            DumpSpringConfigurationAction.$$$reportNull$$$0(0);
        }
        boolean hasSpring = (project = e.getProject()) != null && SpringCommonUtils.hasSpringFacets(project);
        e.getPresentation().setEnabled(hasSpring);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Project project;
        if (e == null) {
            DumpSpringConfigurationAction.$$$reportNull$$$0(1);
        }
        if ((project = e.getProject()) == null) {
            return;
        }
        ThrowableComputable computable = () -> (String)ReadAction.compute(() -> DumpSpringConfigurationAction.getProjectDumpJson(project));
        String dump = (String)ProgressManager.getInstance().runProcessWithProgressSynchronously(computable, "Gathering Spring Models...", true, project);
        String fileName = String.format("SpringConfiguration-%s.txt", DateFormatUtil.formatDateTime((long)System.currentTimeMillis()));
        LightVirtualFile file = new LightVirtualFile(fileName, (FileType)JsonFileType.INSTANCE, (CharSequence)dump);
        OpenFileDescriptor descriptor = new OpenFileDescriptor(project, (VirtualFile)file);
        FileEditorManager.getInstance((Project)project).openEditor(descriptor, true);
    }

    @NotNull
    private static String getProjectDumpJson(@NotNull Project project) {
        if (project == null) {
            DumpSpringConfigurationAction.$$$reportNull$$$0(2);
        }
        ProgressIndicator pi = ProgressManager.getInstance().getProgressIndicator();
        pi.setIndeterminate(false);
        pi.setText("Scanning Spring models...");
        SpringLocalModelFactory localModelFactory = SpringLocalModelFactory.getInstance();
        WProject dumpProject = new WProject();
        Module[] modules = ModuleManager.getInstance((Project)project).getSortedModules();
        int processedModules = 0;
        for (Module module : modules) {
            SpringFacet springFacet = SpringFacet.getInstance(module);
            if (springFacet == null) continue;
            WModule dumpModule = new WModule(module.getName());
            dumpProject.modules.add(dumpModule);
            SpringWFacet dumpFacet = new SpringWFacet();
            dumpModule.facets.add(dumpFacet);
            Set<SpringFileSet> fileSets = SpringFileSetService.getInstance().getAllSets(springFacet);
            for (SpringFileSet fileSet : fileSets) {
                pi.checkCanceled();
                WFileset dumpFileSet = new WFileset(fileSet);
                dumpFacet.filesets.add(dumpFileSet);
                List<VirtualFilePointer> files = fileSet.getFiles();
                LinkedHashSet visited = ContainerUtil.newLinkedHashSet();
                for (VirtualFilePointer file : files) {
                    PsiClass[] psiClasses;
                    VirtualFile virtualFile = file.getFile();
                    if (virtualFile == null) continue;
                    PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(virtualFile);
                    if (JamCommonUtil.isPlainXmlFile((PsiElement)psiFile) && SpringDomUtils.isSpringXml((XmlFile)psiFile)) {
                        LocalXmlModel model = localModelFactory.getOrCreateLocalXmlModel((XmlFile)psiFile, module, Collections.emptySet());
                        if (model == null) continue;
                        DumpSpringConfigurationAction.visitRelated(model, visited, dumpFileSet);
                        continue;
                    }
                    if (!(psiFile instanceof PsiClassOwner)) continue;
                    for (PsiClass psiClass : psiClasses = ((PsiClassOwner)psiFile).getClasses()) {
                        LocalAnnotationModel model = localModelFactory.getOrCreateLocalAnnotationModel(psiClass, module, Collections.emptySet());
                        if (model == null) continue;
                        DumpSpringConfigurationAction.visitRelated(model, visited, dumpFileSet);
                    }
                }
            }
            pi.setFraction((double)(++processedModules) / (double)modules.length);
        }
        pi.setText("Generating JSON...");
        String string = new GsonBuilder().setPrettyPrinting().create().toJson((Object)dumpProject);
        if (string == null) {
            DumpSpringConfigurationAction.$$$reportNull$$$0(3);
        }
        return string;
    }

    private static void visitRelated(@NotNull LocalModel<?> model, @NotNull Set<LocalModel> visited, @NotNull WFileset dumpFileSet) {
        if (model == null) {
            DumpSpringConfigurationAction.$$$reportNull$$$0(4);
        }
        if (visited == null) {
            DumpSpringConfigurationAction.$$$reportNull$$$0(5);
        }
        if (dumpFileSet == null) {
            DumpSpringConfigurationAction.$$$reportNull$$$0(6);
        }
        WModel dumpModel = new WModel(model);
        dumpFileSet.models.add(dumpModel);
        visited.add(model);
        Set<Pair<LocalModel, LocalModelDependency>> dependentModels = model.getDependentLocalModels();
        for (Pair<LocalModel, LocalModelDependency> dependentModel : dependentModels) {
            WSpringDependency dependency = new WSpringDependency(dependentModel);
            dumpModel.dependencies.add(dependency);
            if (visited.contains(dependentModel.first)) continue;
            DumpSpringConfigurationAction.visitRelated((LocalModel)dependentModel.first, visited, dumpFileSet);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/model/actions/DumpSpringConfigurationAction";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visited";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dumpFileSet";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/model/actions/DumpSpringConfigurationAction";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getProjectDumpJson";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getProjectDumpJson";
                break;
            }
            case 3: {
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "visitRelated";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

