/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.gutter;

import com.intellij.codeInsight.daemon.GutterIconNavigationHandler;
import com.intellij.codeInsight.daemon.LineMarkerInfo;
import com.intellij.codeInsight.daemon.LineMarkerProviderDescriptor;
import com.intellij.facet.Facet;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.roots.ui.configuration.ModulesConfigurator;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.spring.SpringBundle;
import com.intellij.spring.facet.SpringFacet;
import com.intellij.spring.facet.SpringFileSet;
import com.intellij.spring.facet.SpringFileSetService;
import com.intellij.spring.gutter.groups.SpringGroupMergeableLineMarkerInfo;
import com.intellij.spring.model.utils.SpringCommonUtils;
import com.intellij.util.ConstantFunction;
import com.intellij.util.Function;
import icons.SpringApiIcons;
import java.awt.event.MouseEvent;
import java.util.Collection;
import java.util.List;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UastUtils;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J(\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0010\u0010\b\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\n0\tH\u0016J\u0016\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00070\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u001a\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\n\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0016J\b\u0010\u0017\u001a\u00020\u0018H\u0016J\u0016\u0010\u0019\u001a\b\u0012\u0002\b\u0003\u0018\u00010\n2\u0006\u0010\u001a\u001a\u00020\u0007H\u0016J\u0012\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J\n\u0010\u001f\u001a\u0004\u0018\u00010\u0018H\u0016\u00a8\u0006 "}, d2={"Lcom/intellij/spring/gutter/SpringClassFilesetLineMarkerProvider;", "Lcom/intellij/codeInsight/daemon/LineMarkerProviderDescriptor;", "()V", "collectSlowLineMarkers", "", "elements", "", "Lcom/intellij/psi/PsiElement;", "result", "", "Lcom/intellij/codeInsight/daemon/LineMarkerInfo;", "createNavigationHandler", "Lcom/intellij/codeInsight/daemon/GutterIconNavigationHandler;", "facet", "Lcom/intellij/spring/facet/SpringFacet;", "getFileset", "Lcom/intellij/spring/facet/SpringFileSet;", "psiFile", "Lcom/intellij/psi/PsiFile;", "module", "Lcom/intellij/openapi/module/Module;", "getIcon", "Ljavax/swing/Icon;", "getId", "", "getLineMarkerInfo", "element", "getMarkerForUClass", "Lcom/intellij/spring/gutter/groups/SpringGroupMergeableLineMarkerInfo;", "uClass", "Lorg/jetbrains/uast/UClass;", "getName", "intellij.spring.core"})
public final class SpringClassFilesetLineMarkerProvider
extends LineMarkerProviderDescriptor {
    @NotNull
    public String getId() {
        return "SpringClassFilesetLineMarkerProvider";
    }

    @Nullable
    public String getName() {
        return "Application Context Configuration";
    }

    @Nullable
    public Icon getIcon() {
        return SpringApiIcons.FileSet;
    }

    @Nullable
    public LineMarkerInfo<?> getLineMarkerInfo(@NotNull PsiElement element) {
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        return null;
    }

    public void collectSlowLineMarkers(@NotNull List<? extends PsiElement> elements, @NotNull Collection<LineMarkerInfo<?>> result) {
        Intrinsics.checkParameterIsNotNull(elements, (String)"elements");
        Intrinsics.checkParameterIsNotNull(result, (String)"result");
        PsiElement psiElement = (PsiElement)CollectionsKt.firstOrNull(elements);
        if (psiElement == null) {
            return;
        }
        PsiElement firstElement = psiElement;
        if (!SpringCommonUtils.hasSpringFacets(firstElement.getProject())) {
            return;
        }
        for (PsiElement psiElement2 : elements) {
            SpringGroupMergeableLineMarkerInfo markerForUClass;
            UClass uClass;
            UElement uElement = UastUtils.getUParentForIdentifier((PsiElement)psiElement2);
            if (!(uElement instanceof UClass)) {
                uElement = null;
            }
            if ((UClass)uElement == null) {
                continue;
            }
            if (this.getMarkerForUClass(uClass) == null) {
                continue;
            }
            result.add((LineMarkerInfo<?>)markerForUClass);
        }
    }

    private final SpringGroupMergeableLineMarkerInfo getMarkerForUClass(UClass uClass) {
        if (!SpringCommonUtils.isConfigurationOrMeta(uClass.getJavaPsi())) {
            return null;
        }
        PsiElement psiElement = uClass.getSourcePsi();
        if (psiElement == null || (psiElement = psiElement.getContainingFile()) == null) {
            return null;
        }
        PsiElement psiFile = psiElement;
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)psiFile);
        if (module == null) {
            return null;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)module, (String)"ModuleUtilCore.findModul\u2026t(psiFile) ?: return null");
        Module module2 = module;
        SpringFileSet springFileSet = this.getFileset((PsiFile)psiFile, module2);
        if (springFileSet == null) {
            return null;
        }
        SpringFileSet filesetResult = springFileSet;
        UElement uElement = uClass.getUastAnchor();
        if (uElement == null || (uElement = uElement.getSourcePsi()) == null) {
            return null;
        }
        UElement nameIdentifier = uElement;
        TextRange textRange = nameIdentifier.getTextRange();
        Function function = (Function)new ConstantFunction((Object)SpringBundle.message("navigate.to.fileset.configuration", new Object[0]));
        SpringFacet springFacet = filesetResult.getFacet();
        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)springFacet), (String)"filesetResult.facet");
        return new SpringGroupMergeableLineMarkerInfo((PsiElement)nameIdentifier, textRange, SpringApiIcons.Gutter.Spring, 11, (Function<? super PsiElement, String>)function, this.createNavigationHandler(springFacet));
    }

    private final GutterIconNavigationHandler<PsiElement> createNavigationHandler(SpringFacet facet) {
        return (GutterIconNavigationHandler)new GutterIconNavigationHandler<PsiElement>(facet){
            final /* synthetic */ SpringFacet $facet;

            public final void navigate(MouseEvent e, PsiElement elt) {
                ModulesConfigurator.showFacetSettingsDialog((Facet)this.$facet, null);
            }
            {
                this.$facet = springFacet;
            }
        };
    }

    private final SpringFileSet getFileset(PsiFile psiFile, Module module) {
        Ref ref = Ref.create();
        Intrinsics.checkExpressionValueIsNotNull((Object)ref, (String)"Ref.create<SpringFileSet>()");
        Ref filesetResult = ref;
        ModuleUtilCore.visitMeAndDependentModules((Module)module, (ModuleUtilCore.ModuleVisitor)new ModuleUtilCore.ModuleVisitor(module, psiFile, filesetResult){
            final /* synthetic */ Module $module;
            final /* synthetic */ PsiFile $psiFile;
            final /* synthetic */ Ref $filesetResult;

            public final boolean invoke(@NotNull Module depModule) {
                Intrinsics.checkParameterIsNotNull((Object)depModule, (String)"depModule");
                SpringFacet springFacet = SpringFacet.getInstance(this.$module);
                if (springFacet == null) {
                    return true;
                }
                Intrinsics.checkExpressionValueIsNotNull((Object)((Object)springFacet), (String)"SpringFacet.getInstance(module) ?: return true");
                SpringFacet springFacet2 = springFacet;
                VirtualFile virtualFile = this.$psiFile.getVirtualFile();
                for (SpringFileSet fileSet : SpringFileSetService.getInstance().getAllSets(springFacet2)) {
                    if (!fileSet.hasFile(virtualFile)) continue;
                    this.$filesetResult.set((Object)fileSet);
                    return false;
                }
                return true;
            }
            {
                this.$module = module;
                this.$psiFile = psiFile;
                this.$filesetResult = ref;
            }
        });
        return (SpringFileSet)filesetResult.get();
    }
}

