/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.factories.resolvers;

import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiType;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.spring.factories.resolvers.AbstractProxiedTypeResolver;
import com.intellij.spring.model.CommonSpringBean;
import com.intellij.spring.model.xml.beans.SpringBean;
import java.util.Collections;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProxyFactoryBeanTypeResolver
extends AbstractProxiedTypeResolver {
    @NonNls
    private static final String FACTORY_CLASS = "org.springframework.aop.framework.ProxyFactoryBean";
    @NonNls
    private static final String PROXY_INTERFACES_PROPERTY_NAME = "proxyInterfaces";
    @NonNls
    private static final String INTERFACES_PROPERTY_NAME = "interfaces";
    @NonNls
    private static final String AUTODETECT_INTERFACES_PROPERTY_NAME = "autodetectInterfaces";
    @NonNls
    private static final String TARGET_PROPERTY_NAME = "target";
    @NonNls
    private static final String TARGET_NAME_PROPERTY_NAME = "targetName";
    @NonNls
    private static final String TARGET_CLASS_PROPERTY_NAME = "targetClass";

    @Override
    @NotNull
    public Set<String> getObjectType(@Nullable CommonSpringBean context) {
        if (context instanceof SpringBean) {
            SpringBean springBean = (SpringBean)context;
            PsiType type = this.getTargetType(springBean);
            if (type != null && this.isCglibExplicitlyEnabled(springBean)) {
                Set<String> set = Collections.singleton(type.getCanonicalText());
                if (set == null) {
                    ProxyFactoryBeanTypeResolver.$$$reportNull$$$0(0);
                }
                return set;
            }
            Set<String> proxyInterfaceNames = ProxyFactoryBeanTypeResolver.getTypesFromClassArrayProperty(springBean, PROXY_INTERFACES_PROPERTY_NAME);
            if (!proxyInterfaceNames.isEmpty()) {
                Set<String> set = proxyInterfaceNames;
                if (set == null) {
                    ProxyFactoryBeanTypeResolver.$$$reportNull$$$0(1);
                }
                return set;
            }
            Set<String> interfaceNames = ProxyFactoryBeanTypeResolver.getTypesFromClassArrayProperty(springBean, INTERFACES_PROPERTY_NAME);
            if (!interfaceNames.isEmpty()) {
                Set<String> set = interfaceNames;
                if (set == null) {
                    ProxyFactoryBeanTypeResolver.$$$reportNull$$$0(2);
                }
                return set;
            }
            if (type != null) {
                Set<String> targetInterfaceNames = ProxyFactoryBeanTypeResolver.getAllInterfaceNames(type);
                if (!targetInterfaceNames.isEmpty() && this.isAutodetectInterfacesEnabled(springBean)) {
                    Set<String> set = targetInterfaceNames;
                    if (set == null) {
                        ProxyFactoryBeanTypeResolver.$$$reportNull$$$0(3);
                    }
                    return set;
                }
                Set<String> set = Collections.singleton(type.getCanonicalText());
                if (set == null) {
                    ProxyFactoryBeanTypeResolver.$$$reportNull$$$0(4);
                }
                return set;
            }
        }
        Set<String> set = Collections.emptySet();
        if (set == null) {
            ProxyFactoryBeanTypeResolver.$$$reportNull$$$0(5);
        }
        return set;
    }

    @Nullable
    private PsiType getTargetType(@NotNull SpringBean context) {
        PsiClassType fromTargetName;
        PsiType fromTarget;
        if (context == null) {
            ProxyFactoryBeanTypeResolver.$$$reportNull$$$0(6);
        }
        if ((fromTarget = ProxyFactoryBeanTypeResolver.getTypeFromProperty(context, TARGET_PROPERTY_NAME)) != null) {
            return fromTarget;
        }
        String targetName = this.getPropertyValue(context, TARGET_NAME_PROPERTY_NAME);
        if (targetName != null && (fromTargetName = ProxyFactoryBeanTypeResolver.getTypeFromBeanName(context, targetName)) != null) {
            return fromTargetName;
        }
        String targetClassName = this.getPropertyValue(context, TARGET_CLASS_PROPERTY_NAME);
        if (targetClassName != null) {
            Project project = context.getManager().getProject();
            PsiManager psiManager = PsiManager.getInstance((Project)project);
            GlobalSearchScope scope = GlobalSearchScope.allScope((Project)project);
            PsiClass targetClass = JavaPsiFacade.getInstance((Project)psiManager.getProject()).findClass(targetClassName, scope);
            if (targetClass != null) {
                return PsiTypesUtil.getClassType((PsiClass)targetClass);
            }
        }
        return null;
    }

    private boolean isAutodetectInterfacesEnabled(@NotNull SpringBean context) {
        if (context == null) {
            ProxyFactoryBeanTypeResolver.$$$reportNull$$$0(7);
        }
        return !this.isBooleanPropertySetAndFalse(context, AUTODETECT_INTERFACES_PROPERTY_NAME);
    }

    @Override
    public boolean accept(@NotNull String factoryClassName) {
        if (factoryClassName == null) {
            ProxyFactoryBeanTypeResolver.$$$reportNull$$$0(8);
        }
        return FACTORY_CLASS.equals(factoryClassName);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/factories/resolvers/ProxyFactoryBeanTypeResolver";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "factoryClassName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getObjectType";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/factories/resolvers/ProxyFactoryBeanTypeResolver";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getTargetType";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isAutodetectInterfacesEnabled";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

