/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.facet.nodes;

import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.pointers.VirtualFilePointer;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassOwner;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.xml.XmlFile;
import com.intellij.spring.SpringBundle;
import com.intellij.spring.dom.SpringDomUtils;
import com.intellij.spring.facet.SpringConfigurationTabSettings;
import com.intellij.spring.facet.SpringFileSet;
import com.intellij.spring.facet.nodes.AbstractFilesetNode;
import com.intellij.spring.model.utils.SpringCommonUtils;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.treeStructure.SimpleNode;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConfigFileNode
extends AbstractFilesetNode {
    private final VirtualFilePointer myFilePointer;

    ConfigFileNode(@NotNull SpringConfigurationTabSettings settings, @NotNull SpringFileSet fileSet, VirtualFilePointer filePointer, @NotNull SimpleNode parent) {
        if (settings == null) {
            ConfigFileNode.$$$reportNull$$$0(0);
        }
        if (fileSet == null) {
            ConfigFileNode.$$$reportNull$$$0(1);
        }
        if (parent == null) {
            ConfigFileNode.$$$reportNull$$$0(2);
        }
        super(fileSet, settings, parent);
        this.myFilePointer = filePointer;
    }

    protected void doUpdate() {
        VirtualFile file;
        VirtualFile virtualFile = file = this.myFilePointer.isValid() ? this.myFilePointer.getFile() : null;
        if (file == null) {
            this.renderError(SpringBundle.message("config.file.not.found", new Object[0]));
            return;
        }
        Project project = this.getFileSet().getFacet().getModule().getProject();
        if (DumbService.isDumb((Project)project)) {
            this.renderFile(null);
            return;
        }
        PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(file);
        if (psiFile instanceof XmlFile) {
            if (SpringDomUtils.isSpringXml((XmlFile)psiFile)) {
                this.renderFile(null);
            } else {
                this.renderError(SpringBundle.message("config.file.is.not.spring", new Object[0]));
            }
        } else if (psiFile instanceof PsiClassOwner) {
            boolean isInnerClassConfig;
            PsiClass[] classes = ((PsiClassOwner)psiFile).getClasses();
            boolean hasClass = classes.length > 0;
            boolean isMainClassConfig = hasClass && (SpringCommonUtils.isConfigurationOrMeta(classes[0]) || SpringCommonUtils.isComponentOrMeta(classes[0]));
            boolean bl = isInnerClassConfig = isMainClassConfig || hasClass && ContainerUtil.exists((Object[])classes[0].getInnerClasses(), innerClass -> SpringCommonUtils.isConfigurationOrMeta(innerClass));
            if (isMainClassConfig || isInnerClassConfig) {
                this.renderPsiClass(classes[0], SimpleTextAttributes.REGULAR_ATTRIBUTES, SimpleTextAttributes.GRAYED_ATTRIBUTES);
            } else {
                this.renderError(SpringBundle.message("config.file.is.not.spring", new Object[0]));
            }
        } else {
            this.renderFile(null);
        }
        if (psiFile != null) {
            this.setIcon(psiFile.getIcon(0));
        }
    }

    private void renderError(String msg) {
        this.renderFile(SimpleTextAttributes.ERROR_ATTRIBUTES, SimpleTextAttributes.ERROR_ATTRIBUTES, msg);
    }

    private void renderFile(@Nullable String toolTip) {
        this.renderFile(SimpleTextAttributes.REGULAR_ATTRIBUTES, SimpleTextAttributes.GRAYED_ATTRIBUTES, toolTip);
    }

    private void renderFile(SimpleTextAttributes main, SimpleTextAttributes full, @Nullable String toolTip) {
        this.clearColoredText();
        if (!this.myFilePointer.isValid()) {
            this.addColoredFragment(toolTip, toolTip, main);
            return;
        }
        this.addColoredFragment(this.myFilePointer.getFileName(), toolTip, main);
        this.addColoredFragment(" (" + this.getLocation() + ")", toolTip, full);
    }

    private String getLocation() {
        VirtualFile parent;
        VirtualFile file = this.myFilePointer.getFile();
        VirtualFile virtualFile = parent = file != null ? file.getParent() : null;
        if (parent == null) {
            return this.myFilePointer.getPresentableUrl();
        }
        Project project = this.getProject();
        assert (project != null);
        VirtualFile baseDir = project.getBaseDir();
        if (baseDir == null) {
            return this.myFilePointer.getPresentableUrl();
        }
        String relativePath = VfsUtilCore.getRelativePath((VirtualFile)file, (VirtualFile)baseDir);
        return (String)ObjectUtils.notNull((Object)relativePath, (Object)parent.getPresentableUrl());
    }

    private void renderPsiClass(PsiClass psiClass, SimpleTextAttributes main, SimpleTextAttributes full) {
        this.clearColoredText();
        this.addColoredFragment(psiClass.getName(), main);
        this.addColoredFragment(" (" + StringUtil.getPackageName((String)((String)ObjectUtils.assertNotNull((Object)psiClass.getQualifiedName()))) + ")", full);
    }

    @NotNull
    public SimpleNode[] getChildren() {
        if (NO_CHILDREN == null) {
            ConfigFileNode.$$$reportNull$$$0(3);
        }
        return NO_CHILDREN;
    }

    public VirtualFilePointer getFilePointer() {
        return this.myFilePointer;
    }

    public boolean isAlwaysLeaf() {
        return true;
    }

    @Override
    @NotNull
    public Object[] getEqualityObjects() {
        SpringFileSet set = this.getFileSet();
        Object[] objectArray = new Object[]{this.myFilePointer, set, set.getName(), set.getFiles(), set.getDependencyFileSets()};
        if (objectArray == null) {
            ConfigFileNode.$$$reportNull$$$0(4);
        }
        return objectArray;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileSet";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/facet/nodes/ConfigFileNode";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/facet/nodes/ConfigFileNode";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildren";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getEqualityObjects";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

