/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.facet;

import com.intellij.facet.ui.FacetEditorContext;
import com.intellij.facet.ui.FacetEditorTab;
import com.intellij.facet.ui.FacetEditorValidator;
import com.intellij.facet.ui.FacetValidatorsManager;
import com.intellij.icons.AllIcons;
import com.intellij.ide.CommonActionsManager;
import com.intellij.ide.DataManager;
import com.intellij.ide.DefaultTreeExpander;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.TreeExpander;
import com.intellij.ide.util.treeView.AbstractTreeStructure;
import com.intellij.ide.util.treeView.TreeVisitor;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CheckedActionGroup;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.pointers.VirtualFilePointer;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.spring.SpringBundle;
import com.intellij.spring.facet.SpringConfigurationTabSettings;
import com.intellij.spring.facet.SpringFacet;
import com.intellij.spring.facet.SpringFacetConfiguration;
import com.intellij.spring.facet.SpringFileSet;
import com.intellij.spring.facet.SpringFileSetEditorCustomization;
import com.intellij.spring.facet.SpringFileSetImpl;
import com.intellij.spring.facet.SpringFileSetService;
import com.intellij.spring.facet.beans.CustomSetting;
import com.intellij.spring.facet.editor.FileSetEditor;
import com.intellij.spring.facet.nodes.ConfigFileNode;
import com.intellij.spring.facet.nodes.DependencyNode;
import com.intellij.spring.facet.nodes.FileSetNode;
import com.intellij.spring.facet.nodes.FilesetGroupNode;
import com.intellij.spring.facet.searchers.CodeConfigSearcher;
import com.intellij.spring.facet.searchers.XmlConfigSearcher;
import com.intellij.spring.facet.validation.FileSetDependenciesValidator;
import com.intellij.spring.facet.validation.FilesetContainsConfigFilesInTestsSourceValidator;
import com.intellij.spring.facet.validation.UnmappedConfigurationFilesValidator;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.AnActionButtonRunnable;
import com.intellij.ui.AnActionButtonUpdater;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.treeStructure.SimpleNode;
import com.intellij.ui.treeStructure.SimpleTree;
import com.intellij.ui.treeStructure.SimpleTreeBuilder;
import com.intellij.ui.treeStructure.SimpleTreeStructure;
import com.intellij.util.containers.OrderedSet;
import java.awt.Component;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeModel;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class SpringConfigurationTab
extends FacetEditorTab
implements Disposable {
    private final JPanel myMainPanel;
    private final SimpleTree myTree;
    private final SpringConfigurationTabSettings myConfigurationTabSettings;
    private final SpringFacet myFacet;
    private final FacetEditorContext myContext;
    private final FacetValidatorsManager myValidatorsManager;
    private final OrderedSet<SpringFileSet> myBuffer = new OrderedSet();
    private final SimpleTreeBuilder myBuilder;
    private boolean myModified;
    private final SimpleNode myRoot = new SimpleNode(){

        @NotNull
        public SimpleNode[] getChildren() {
            ArrayList<FileSetNode> nodes = new ArrayList<FileSetNode>(SpringConfigurationTab.this.myBuffer.size());
            for (SpringFileSet springFileSet : SpringConfigurationTab.this.myBuffer) {
                if (springFileSet.isRemoved()) continue;
                FileSetNode fileSetNode = new FileSetNode(springFileSet, SpringConfigurationTab.this.myConfigurationTabSettings, this);
                nodes.add(fileSetNode);
            }
            SimpleNode[] simpleNodeArray = nodes.toArray(new SimpleNode[0]);
            if (simpleNodeArray == null) {
                1.$$$reportNull$$$0(0);
            }
            return simpleNodeArray;
        }

        public boolean isAutoExpandNode() {
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/facet/SpringConfigurationTab$1", "getChildren"));
        }
    };

    SpringConfigurationTab(FacetEditorContext context, FacetValidatorsManager validatorsManager) {
        this.myFacet = (SpringFacet)context.getFacet();
        this.myConfigurationTabSettings = SpringConfigurationTabSettings.getInstance(context.getProject());
        this.myContext = context;
        this.myValidatorsManager = validatorsManager;
        SimpleTreeStructure structure = new SimpleTreeStructure(){

            @NotNull
            public Object getRootElement() {
                SimpleNode simpleNode = SpringConfigurationTab.this.myRoot;
                if (simpleNode == null) {
                    2.$$$reportNull$$$0(0);
                }
                return simpleNode;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/facet/SpringConfigurationTab$2", "getRootElement"));
            }
        };
        this.myTree = new SimpleTree();
        this.myTree.setRootVisible(false);
        this.myTree.getEmptyText().setText(SpringBundle.message("config.no.contexts.defined", new Object[0]));
        this.myBuilder = new SimpleTreeBuilder((JTree)this.myTree, (DefaultTreeModel)this.myTree.getModel(), (AbstractTreeStructure)structure, null){};
        this.myBuilder.initRoot();
        ToolbarDecorator decorator = ToolbarDecorator.createDecorator((JTree)this.myTree).setAddAction((AnActionButtonRunnable)new CreateApplicationContextAction()).setRemoveAction((AnActionButtonRunnable)new RemoveSelectedNodesAction()).setRemoveActionUpdater(e -> this.getCurrentFileSet() != null).setEditAction((AnActionButtonRunnable)new EditApplicationContextAction(this.myFacet)).setEditActionUpdater(e -> {
            SpringFileSet fileSet = this.getCurrentFileSet();
            return fileSet != null && !fileSet.isAutodetected();
        }).disableUpDownActions();
        Set<SpringFileSet> allFileSets = SpringFileSetService.getInstance().getAllSets(this.myFacet);
        ActionGroup additionalSettingsActionGroup = this.getAdditionalSettingsActionGroup(allFileSets);
        if (additionalSettingsActionGroup != null) {
            decorator.addExtraAction(AnActionButton.fromAction((AnAction)additionalSettingsActionGroup));
        }
        for (final SpringFileSetEditorCustomization customization : (SpringFileSetEditorCustomization[])SpringFileSetEditorCustomization.EP_NAME.getExtensions()) {
            if (!allFileSets.stream().anyMatch(customization::isApplicable)) continue;
            for (AnAction extraAction : customization.getExtraActions()) {
                AnActionButton.AnActionButtonWrapper extraActionButton = new AnActionButton.AnActionButtonWrapper(extraAction.getTemplatePresentation(), extraAction){

                    public void actionPerformed(@NotNull AnActionEvent e) {
                        if (e == null) {
                            4.$$$reportNull$$$0(0);
                        }
                        SpringFileSet set = SpringConfigurationTab.this.getCurrentFileSet();
                        assert (set != null);
                        assert (set.isAutodetected());
                        DataManager.getInstance().saveInDataContext(e.getDataContext(), SpringFileSetEditorCustomization.EXTRA_ACTION_FILESET, (Object)set);
                        super.actionPerformed(e);
                        int idx = SpringConfigurationTab.this.myBuffer.indexOf((Object)set);
                        SpringConfigurationTab.this.myBuffer.remove((Object)set);
                        ((SpringFacetConfiguration)SpringConfigurationTab.this.myFacet.getConfiguration()).setModified();
                        for (SpringFileSet fileSet : SpringFileSetService.getInstance().getModelProviderSets(SpringConfigurationTab.this.myFacet)) {
                            if (!fileSet.getId().equals(set.getId())) continue;
                            SpringConfigurationTab.this.myBuffer.add(idx, (Object)fileSet);
                            SpringConfigurationTab.this.myModified = true;
                            SpringConfigurationTab.this.myBuilder.queueUpdate().doWhenDone(() -> SpringConfigurationTab.this.selectFileSet(fileSet));
                            break;
                        }
                        SpringConfigurationTab.this.validateFileSetConfiguration();
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/spring/facet/SpringConfigurationTab$4", "actionPerformed"));
                    }
                };
                extraActionButton.addCustomUpdater(new AnActionButtonUpdater(){

                    public boolean isEnabled(@NotNull AnActionEvent e) {
                        SpringFileSet currentFileSet;
                        if (e == null) {
                            5.$$$reportNull$$$0(0);
                        }
                        if ((currentFileSet = SpringConfigurationTab.this.getCurrentFileSet()) == null || !currentFileSet.isAutodetected()) {
                            return false;
                        }
                        return customization.isApplicable(currentFileSet);
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/spring/facet/SpringConfigurationTab$5", "isEnabled"));
                    }
                });
                decorator.addExtraAction((AnActionButton)extraActionButton);
            }
        }
        this.myMainPanel = decorator.createPanel();
        ActionToolbar displaySettingsToolbar = ActionManager.getInstance().createActionToolbar("SpringFacetDisplaySettingsToolbar", this.getDisplaySettingsActionGroup(), false);
        this.myMainPanel.add((Component)displaySettingsToolbar.getComponent(), "East");
        FileSetDependenciesValidator dependenciesValidator = new FileSetDependenciesValidator((Set<SpringFileSet>)this.myBuffer);
        this.myValidatorsManager.registerValidator((FacetEditorValidator)dependenciesValidator, new JComponent[0]);
        UnmappedConfigurationFilesValidator unmappedConfigurationFilesValidator = new UnmappedConfigurationFilesValidator(this.myContext.getModule());
        this.myValidatorsManager.registerValidator((FacetEditorValidator)unmappedConfigurationFilesValidator, new JComponent[0]);
        FilesetContainsConfigFilesInTestsSourceValidator containsTestConfigsValidator = new FilesetContainsConfigFilesInTestsSourceValidator(this.myContext.getModule(), (Set<? extends SpringFileSet>)this.myBuffer);
        this.myValidatorsManager.registerValidator((FacetEditorValidator)containsTestConfigsValidator, new JComponent[0]);
    }

    @NotNull
    private Set<CustomSetting> getCustomSettings() {
        Set<CustomSetting> set = ((SpringFacetConfiguration)this.myFacet.getConfiguration()).getCustomSettings();
        if (set == null) {
            SpringConfigurationTab.$$$reportNull$$$0(0);
        }
        return set;
    }

    @Nullable
    private ActionGroup getAdditionalSettingsActionGroup(Set<SpringFileSet> allFileSets) {
        LinkedHashSet<CustomSetting> allCustomSettings = new LinkedHashSet<CustomSetting>(this.getCustomSettings());
        block0: for (SpringFileSetEditorCustomization customization : (SpringFileSetEditorCustomization[])SpringFileSetEditorCustomization.EP_NAME.getExtensions()) {
            List<CustomSetting> customSettings = customization.getCustomSettings();
            allCustomSettings.removeAll(customSettings);
            for (SpringFileSet set : allFileSets) {
                if (!customization.isApplicable(set)) continue;
                allCustomSettings.addAll(customSettings);
                continue block0;
            }
        }
        MyCheckedActionGroup actionGroup = new MyCheckedActionGroup(new CheckAction[0]);
        for (CustomSetting setting : allCustomSettings) {
            if (!(setting instanceof CustomSetting.BOOLEAN)) continue;
            actionGroup.add((AnAction)new CheckAction((CustomSetting.BOOLEAN)setting));
        }
        if (actionGroup.getChildrenCount() == 0) {
            return null;
        }
        actionGroup.getTemplatePresentation().setText(SpringBundle.message("configuration.tab.additional.settings", new Object[0]));
        actionGroup.getTemplatePresentation().setIcon(AllIcons.General.Settings);
        return actionGroup;
    }

    private ActionGroup getDisplaySettingsActionGroup() {
        DefaultActionGroup group = new DefaultActionGroup();
        group.add((AnAction)new ToggleAction(IdeBundle.message((String)"action.sort.alphabetically", (Object[])new Object[0]), IdeBundle.message((String)"action.sort.alphabetically", (Object[])new Object[0]), AllIcons.ObjectBrowser.Sorted){

            public boolean isSelected(@NotNull AnActionEvent e) {
                if (e == null) {
                    6.$$$reportNull$$$0(0);
                }
                return SpringConfigurationTab.this.myConfigurationTabSettings.isSortAlpha();
            }

            public void setSelected(@NotNull AnActionEvent e, boolean state) {
                if (e == null) {
                    6.$$$reportNull$$$0(1);
                }
                SpringConfigurationTab.this.myConfigurationTabSettings.setSortAlpha(state);
                SpringConfigurationTab.this.myBuilder.queueUpdate();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "e";
                objectArray2[1] = "com/intellij/spring/facet/SpringConfigurationTab$6";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "isSelected";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "setSelected";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        group.addSeparator();
        CommonActionsManager actionManager = CommonActionsManager.getInstance();
        DefaultTreeExpander treeExpander = new DefaultTreeExpander((JTree)this.myTree);
        group.add(actionManager.createExpandAllAction((TreeExpander)treeExpander, (JComponent)this.myTree));
        group.add(actionManager.createCollapseAllAction((TreeExpander)treeExpander, (JComponent)this.myTree));
        return group;
    }

    private void remove() {
        Set nodes = this.myBuilder.getSelectedElements(SimpleNode.class);
        for (SimpleNode node : nodes) {
            SpringFileSet fileSet;
            if (node instanceof DependencyNode) {
                fileSet = SpringConfigurationTab.getFileSetForNode(node);
                fileSet.removeDependency(((DependencyNode)node).getFileSet());
                continue;
            }
            if (node instanceof FileSetNode) {
                fileSet = ((FileSetNode)node).getFileSet();
                int result = Messages.showYesNoDialog((Component)this.myMainPanel, (String)SpringBundle.message("facet.context.remove.message", fileSet.getName()), (String)SpringBundle.message("facet.context.remove.title", new Object[0]), (Icon)Messages.getQuestionIcon());
                if (result != 0) continue;
                if (fileSet.isAutodetected()) {
                    fileSet.setRemoved(true);
                    this.myBuffer.add((Object)fileSet);
                } else {
                    this.myBuffer.remove((Object)fileSet);
                }
                for (SpringFileSet set : this.myBuffer) {
                    set.removeDependency(fileSet);
                }
                continue;
            }
            if (node instanceof FilesetGroupNode) {
                fileSet = SpringConfigurationTab.getFileSetForNode(node);
                if (fileSet.isAutodetected()) continue;
                Set<VirtualFilePointer> filePointers = ((FilesetGroupNode)node).getFilePointers();
                for (VirtualFilePointer filePointer : filePointers) {
                    fileSet.removeFile(filePointer);
                }
                continue;
            }
            if (!(node instanceof ConfigFileNode) || (fileSet = SpringConfigurationTab.getFileSetForNode(node)).isAutodetected()) continue;
            VirtualFilePointer filePointer = ((ConfigFileNode)node).getFilePointer();
            fileSet.removeFile(filePointer);
        }
        this.myModified = true;
        this.myBuilder.queueUpdate().doWhenDone(() -> {
            this.myTree.clearSelection();
            IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> IdeFocusManager.getGlobalInstance().requestFocus((Component)this.myTree, true));
        });
    }

    @NotNull
    private static SpringFileSet getFileSetForNode(SimpleNode node) {
        FileSetNode fileSetNode = SpringConfigurationTab.getFileSetNodeFor(node);
        assert (fileSetNode != null);
        SpringFileSet springFileSet = fileSetNode.getFileSet();
        if (springFileSet == null) {
            SpringConfigurationTab.$$$reportNull$$$0(1);
        }
        return springFileSet;
    }

    @Nullable
    private SpringFileSet getCurrentFileSet() {
        SimpleNode node = this.myTree.getSelectedNode();
        FileSetNode currentFileSetNode = SpringConfigurationTab.getFileSetNodeFor(node);
        return currentFileSetNode == null ? null : currentFileSetNode.getFileSet();
    }

    @Nullable
    private static FileSetNode getFileSetNodeFor(@Nullable SimpleNode node) {
        while (node != null) {
            if (node instanceof FileSetNode) {
                return (FileSetNode)node;
            }
            node = node.getParent();
        }
        return null;
    }

    public String getHelpTopic() {
        return "reference.settings.project.modules.spring.facet";
    }

    @Nls
    public String getDisplayName() {
        return SpringBundle.message("config.display.name", new Object[0]);
    }

    @NotNull
    public JComponent createComponent() {
        JComponent jComponent = DumbService.getInstance((Project)this.myContext.getProject()).wrapGently((JComponent)this.myMainPanel, (Disposable)this);
        if (jComponent == null) {
            SpringConfigurationTab.$$$reportNull$$$0(2);
        }
        return jComponent;
    }

    public boolean isModified() {
        for (CustomSetting setting : this.getCustomSettings()) {
            if (!setting.isModified()) continue;
            return true;
        }
        return this.myModified;
    }

    public void apply() {
        if (this.myFacet.isDisposed()) {
            return;
        }
        this.myFacet.removeFileSets();
        for (SpringFileSet fileSet : this.myBuffer) {
            if (fileSet.isAutodetected() && (!fileSet.isAutodetected() || !fileSet.isRemoved())) continue;
            this.myFacet.addFileSet(fileSet);
        }
        ((SpringFacetConfiguration)this.myFacet.getConfiguration()).setModified();
        for (CustomSetting setting : this.getCustomSettings()) {
            setting.apply();
        }
        this.myModified = false;
        this.validateFileSetConfiguration();
    }

    public void reset() {
        this.myBuffer.clear();
        Set<SpringFileSet> sets = SpringFileSetService.getInstance().getAllSets(this.myFacet);
        for (SpringFileSet fileSet : sets) {
            this.myBuffer.add((Object)new SpringFileSetImpl(fileSet));
        }
        this.myBuilder.queueUpdate();
        this.myTree.setSelectionRow(0);
        for (CustomSetting setting : this.getCustomSettings()) {
            setting.reset();
        }
        this.myModified = false;
    }

    public void disposeUIResources() {
        Disposer.dispose((Disposable)this.myBuilder);
        Disposer.dispose((Disposable)this);
    }

    private void selectFileSet(final SpringFileSet fileSet) {
        this.myBuilder.select(FileSetNode.class, (TreeVisitor)new TreeVisitor<FileSetNode>(){

            public boolean visit(@NotNull FileSetNode node) {
                if (node == null) {
                    7.$$$reportNull$$$0(0);
                }
                return node.getFileSet().getId().equals(fileSet.getId());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/spring/facet/SpringConfigurationTab$7", "visit"));
            }
        }, null, false);
    }

    public void dispose() {
    }

    private void validateFileSetConfiguration() {
        this.myValidatorsManager.validate();
    }

    @NotNull
    private FileSetEditor createFileSetEditor(@NotNull SpringFileSet fileSet) {
        if (fileSet == null) {
            SpringConfigurationTab.$$$reportNull$$$0(3);
        }
        FileSetEditor fileSetEditor = new FileSetEditor(this.myMainPanel, this.myContext.getModule(), fileSet, (Set<SpringFileSet>)this.myBuffer, new XmlConfigSearcher(this.myContext.getModule()), new CodeConfigSearcher(this.myContext.getModule()));
        if (fileSetEditor == null) {
            SpringConfigurationTab.$$$reportNull$$$0(4);
        }
        return fileSetEditor;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 3: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 3: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/facet/SpringConfigurationTab";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileSet";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getCustomSettings";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileSetForNode";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createComponent";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/facet/SpringConfigurationTab";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createFileSetEditor";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createFileSetEditor";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class CheckAction
    extends ToggleAction {
        private final CustomSetting.BOOLEAN myBean;

        private CheckAction(CustomSetting.BOOLEAN bean) {
            super(bean.getDescription());
            this.myBean = bean;
        }

        public CustomSetting.BOOLEAN getBean() {
            return this.myBean;
        }

        public boolean isSelected(@NotNull AnActionEvent e) {
            Boolean value;
            if (e == null) {
                CheckAction.$$$reportNull$$$0(0);
            }
            return (value = this.myBean.getValue()) == null ? this.myBean.getDefaultValue() : value.booleanValue();
        }

        public void setSelected(@NotNull AnActionEvent e, boolean state) {
            if (e == null) {
                CheckAction.$$$reportNull$$$0(1);
            }
            this.myBean.setBooleanValue(state);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "com/intellij/spring/facet/SpringConfigurationTab$CheckAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isSelected";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setSelected";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class MyCheckedActionGroup
    extends DefaultActionGroup
    implements CheckedActionGroup {
        MyCheckedActionGroup(CheckAction ... actions) {
            super((AnAction[])actions);
            this.setPopup(true);
        }
    }

    private class RemoveSelectedNodesAction
    implements AnActionButtonRunnable {
        private RemoveSelectedNodesAction() {
        }

        public void run(AnActionButton button) {
            SpringConfigurationTab.this.remove();
            SpringConfigurationTab.this.validateFileSetConfiguration();
        }
    }

    private class EditApplicationContextAction
    implements AnActionButtonRunnable {
        private final SpringFacet mySpringFacet;

        private EditApplicationContextAction(SpringFacet springFacet) {
            this.mySpringFacet = springFacet;
        }

        public void run(AnActionButton button) {
            SpringFileSet fileSet = SpringConfigurationTab.this.getCurrentFileSet();
            if (fileSet != null) {
                FileSetEditor editor = SpringConfigurationTab.this.createFileSetEditor(fileSet);
                editor.show();
                if (editor.getExitCode() == 0) {
                    SpringConfigurationTab.this.myModified = true;
                    int idx = SpringConfigurationTab.this.myBuffer.indexOf((Object)fileSet);
                    SpringConfigurationTab.this.myBuffer.remove((Object)fileSet);
                    SpringFileSet edited = editor.getEditedFileSet();
                    Disposer.register((Disposable)this.mySpringFacet, (Disposable)edited);
                    SpringConfigurationTab.this.myBuffer.add(idx, (Object)edited);
                    edited.setAutodetected(false);
                    SpringConfigurationTab.this.myBuilder.queueUpdate().doWhenDone(() -> SpringConfigurationTab.this.selectFileSet(edited));
                    SpringConfigurationTab.this.validateFileSetConfiguration();
                }
            }
        }
    }

    private class CreateApplicationContextAction
    implements AnActionButtonRunnable {
        private CreateApplicationContextAction() {
        }

        public void run(AnActionButton button) {
            SpringFileSetService fileSetService = SpringFileSetService.getInstance();
            String uniqueId = fileSetService.getUniqueId((Set<SpringFileSet>)SpringConfigurationTab.this.myBuffer);
            String uniqueName = fileSetService.getUniqueName(SpringBundle.message("facet.context.default.name", new Object[0]), (Set<SpringFileSet>)SpringConfigurationTab.this.myBuffer);
            SpringFileSetImpl fileSet = new SpringFileSetImpl(uniqueId, uniqueName, SpringConfigurationTab.this.myFacet){

                @Override
                public boolean isNew() {
                    return true;
                }
            };
            FileSetEditor editor = SpringConfigurationTab.this.createFileSetEditor(fileSet);
            editor.show();
            if (editor.getExitCode() == 0) {
                SpringFileSet editedFileSet = editor.getEditedFileSet();
                Disposer.register((Disposable)SpringConfigurationTab.this.myFacet, (Disposable)editedFileSet);
                SpringConfigurationTab.this.myBuffer.add((Object)editedFileSet);
                SpringConfigurationTab.this.myModified = true;
                SpringConfigurationTab.this.myBuilder.queueUpdate().doWhenDone(() -> SpringConfigurationTab.this.selectFileSet(fileSet));
                SpringConfigurationTab.this.validateFileSetConfiguration();
            }
        }
    }
}

