/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.dom;

import com.intellij.openapi.util.Iconable;
import com.intellij.spring.dom.PlaceholderDomReferenceInjector;
import com.intellij.spring.dom.SpringCustomNamespaces;
import com.intellij.spring.model.xml.beans.Beans;
import com.intellij.util.xml.DomFileDescription;
import icons.SpringApiIcons;
import javax.swing.Icon;

public class SpringDomFileDescription
extends DomFileDescription<Beans> {
    private static final int CORE_NAMESPACES_STUB_VERSION = 14;
    public static final int CORE_MODEL_VERSION = 0;
    private static final String[] SPRING_NAMESPACES = new String[]{"http://www.springframework.org/schema/beans", "http://www.springframework.org/dtd/spring-beans.dtd", "http://www.springframework.org/dtd/spring-beans-2.0.dtd"};

    public SpringDomFileDescription() {
        super(Beans.class, "beans", new String[0]);
    }

    public boolean hasStubs() {
        return true;
    }

    public int getStubVersion() {
        int customNamespacesStubVersion = 0;
        for (SpringCustomNamespaces customNamespaces : SpringCustomNamespaces.EP_NAME.getExtensionList()) {
            customNamespacesStubVersion += customNamespaces.getStubVersion();
            customNamespacesStubVersion += customNamespaces.getClass().getName().hashCode();
        }
        return 14 + customNamespacesStubVersion;
    }

    public Icon getFileIcon(@Iconable.IconFlags int flags) {
        return SpringApiIcons.SpringConfig;
    }

    protected void initializeFileDescription() {
        this.registerCoreNamespaces();
        for (SpringCustomNamespaces customNamespaces : SpringCustomNamespaces.EP_NAME.getExtensionList()) {
            customNamespaces.getNamespacePolicies().process(this);
        }
        this.registerReferenceInjector(new PlaceholderDomReferenceInjector());
    }

    private void registerCoreNamespaces() {
        this.registerNamespacePolicy("Spring beans namespace key", SPRING_NAMESPACES);
        this.registerNamespacePolicy("Spring JEE namespace key", new String[]{"http://www.springframework.org/schema/jee"});
        this.registerNamespacePolicy("Spring Lang namespace key", new String[]{"http://www.springframework.org/schema/lang"});
        this.registerNamespacePolicy("Spring Util namespace key", new String[]{"http://www.springframework.org/schema/util"});
        this.registerNamespacePolicy("Spring Jms namespace key", new String[]{"http://www.springframework.org/schema/jms"});
        this.registerNamespacePolicy("Spring Context namespace key", new String[]{"http://www.springframework.org/schema/context"});
        this.registerNamespacePolicy("Spring Cache namespace key", new String[]{"http://www.springframework.org/schema/cache"});
        this.registerNamespacePolicy("Spring p-namespace", new String[]{"http://www.springframework.org/schema/p"});
        this.registerNamespacePolicy("Spring c-namespace", new String[]{"http://www.springframework.org/schema/c"});
        this.registerNamespacePolicy("Spring task namespace key", new String[]{"http://www.springframework.org/schema/task"});
        this.registerNamespacePolicy("Spring JDBC namespace key", new String[]{"http://www.springframework.org/schema/jdbc"});
        this.registerNamespacePolicy("Spring TX namespace key", new String[]{"http://www.springframework.org/schema/tx"});
    }
}

