/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.contexts.model.diagram.beans;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.spring.contexts.model.diagram.SpringLocalModelsDataModel;
import com.intellij.spring.contexts.model.diagram.beans.LocalModelGraphElementWrapper;
import com.intellij.spring.contexts.model.diagram.beans.ModuleLocalModelWrapper;
import com.intellij.spring.facet.SpringFacet;
import com.intellij.spring.facet.SpringFileSet;
import com.intellij.spring.facet.SpringFileSetService;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FilesetLocalModelWrapper
extends LocalModelGraphElementWrapper<SpringFileSet> {
    private static final String FILESET_PREFIX = "fileset=";
    public static final String DELIMITER = "/";

    protected FilesetLocalModelWrapper(@NotNull SpringFileSet element) {
        if (element == null) {
            FilesetLocalModelWrapper.$$$reportNull$$$0(0);
        }
        super(element);
    }

    @Override
    public String getTitle() {
        return ((SpringFileSet)this.myElement).getName();
    }

    @Override
    public String getToolTip() {
        return "";
    }

    @Override
    public Icon getIcon() {
        return ((SpringFileSet)this.myElement).getIcon();
    }

    @Override
    public String getQualifiedName() {
        return FILESET_PREFIX + ((SpringFileSet)this.myElement).getFacet().getModule().getName() + DELIMITER + ((SpringFileSet)this.myElement).getName();
    }

    public static LocalModelGraphElementWrapper resolveByFQN(String fqn, Project project) {
        if (fqn.startsWith(FILESET_PREFIX)) {
            String path = fqn.substring(FILESET_PREFIX.length());
            if (path.contains(DELIMITER)) {
                SpringFacet facet;
                String moduleName = path.substring(0, path.indexOf(DELIMITER));
                String filesetName = path.substring(path.indexOf(DELIMITER) + 1);
                Module module = ModuleManager.getInstance((Project)project).findModuleByName(moduleName);
                if (module != null && (facet = SpringFacet.getInstance(module)) != null) {
                    for (SpringFileSet fileSet : SpringFileSetService.getInstance().getAllSets(facet)) {
                        if (!fileSet.getName().equals(filesetName)) continue;
                        return new ModuleLocalModelWrapper(module);
                    }
                }
            }
            throw new IllegalArgumentException(String.format("Wrong fileset FQN '%s'", fqn));
        }
        return null;
    }

    @Nullable
    public static LocalModelGraphElementWrapper create(SpringFileSet fileSet) {
        return fileSet == null ? null : new FilesetLocalModelWrapper(fileSet);
    }

    @Override
    public void accept(@NotNull SpringLocalModelsDataModel.RelatedVisitor visitor) {
        if (visitor == null) {
            FilesetLocalModelWrapper.$$$reportNull$$$0(1);
        }
        visitor.visitFileSet((SpringFileSet)this.myElement);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
        }
        objectArray2[1] = "com/intellij/spring/contexts/model/diagram/beans/FilesetLocalModelWrapper";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "accept";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

