/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.contexts.model;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.spring.SpringModificationTrackersManager;
import com.intellij.spring.contexts.model.ComponentScanPackagesModel;
import com.intellij.spring.model.BeanService;
import com.intellij.spring.model.CommonSpringBean;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.spring.model.utils.SpringProfileUtils;
import com.intellij.spring.model.xml.context.SpringBeansPackagesScan;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public class SpringComponentScanModel<T extends SpringBeansPackagesScan>
extends ComponentScanPackagesModel {
    private final Set<String> myActiveProfiles;
    private volatile CachedValue<Collection<SpringBeanPointer>> myScannedBeans;
    private final T myComponentScan;

    public SpringComponentScanModel(@NotNull Module module, final @NotNull T componentScan, Set<String> activeProfiles) {
        if (module == null) {
            SpringComponentScanModel.$$$reportNull$$$0(0);
        }
        if (componentScan == null) {
            SpringComponentScanModel.$$$reportNull$$$0(1);
        }
        super((NotNullLazyValue<? extends Set<PsiPackage>>)new NotNullLazyValue<Set<PsiPackage>>(){

            @NotNull
            protected Set<PsiPackage> compute() {
                Set<PsiPackage> set = componentScan.getPsiPackages();
                if (set == null) {
                    1.$$$reportNull$$$0(0);
                }
                return set;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/contexts/model/SpringComponentScanModel$1", "compute"));
            }
        }, module);
        this.myComponentScan = componentScan;
        this.myActiveProfiles = activeProfiles;
    }

    @Override
    public Collection<SpringBeanPointer> getLocalBeans() {
        PsiElement psiElement = this.myComponentScan.getIdentifyingPsiElement();
        if (psiElement == null) {
            return Collections.emptySet();
        }
        if (this.myScannedBeans == null) {
            this.myScannedBeans = CachedValuesManager.getManager((Project)this.getModule().getProject()).createCachedValue(() -> {
                Collection<SpringBeanPointer> pointers = this.calculateLocalBeans();
                return CachedValueProvider.Result.create(pointers, (Object[])this.getDependencies(pointers.stream().map(pointer -> pointer.getContainingFile()).collect(Collectors.toSet())));
            }, false);
        }
        return (Collection)this.myScannedBeans.getValue();
    }

    @NotNull
    private Object[] getDependencies(@NotNull Set<PsiFile> containingFiles) {
        if (containingFiles == null) {
            SpringComponentScanModel.$$$reportNull$$$0(2);
        }
        LinkedHashSet dependencies = ContainerUtil.newLinkedHashSet();
        ContainerUtil.addAllNotNull((Collection)dependencies, containingFiles);
        ContainerUtil.addAll((Collection)dependencies, (Object[])SpringModificationTrackersManager.getInstance(this.getModule().getProject()).getOuterModelsDependencies());
        Object[] objectArray = ArrayUtil.toObjectArray((Collection)dependencies);
        if (objectArray == null) {
            SpringComponentScanModel.$$$reportNull$$$0(3);
        }
        return objectArray;
    }

    @Override
    protected Collection<SpringBeanPointer> calculateScannedBeans() {
        Set<CommonSpringBean> elements = this.myComponentScan.getScannedElements(this.getModule());
        List<CommonSpringBean> inActiveProfiles = SpringProfileUtils.filterBeansInActiveProfiles(elements, this.myActiveProfiles);
        return BeanService.getInstance().mapSpringBeans(inActiveProfiles);
    }

    @Override
    @NotNull
    public Set<String> getActiveProfiles() {
        Set<String> set = this.myActiveProfiles;
        if (set == null) {
            SpringComponentScanModel.$$$reportNull$$$0(4);
        }
        return set;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "componentScan";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "containingFiles";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/contexts/model/SpringComponentScanModel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/contexts/model/SpringComponentScanModel";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getDependencies";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getActiveProfiles";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getDependencies";
                break;
            }
            case 3: 
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

