/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.application.yaml;

import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.codeInsight.lookup.LookupElementPresentation;
import com.intellij.codeInsight.lookup.LookupElementRenderer;
import com.intellij.codeInsight.lookup.RealLookupElementPresentation;
import com.intellij.lang.properties.PropertiesHighlighter;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.spring.boot.application.config.SpringBootPlaceholderReference;
import com.intellij.spring.boot.application.yaml.SpringBootApplicationYamlAccessor;
import com.intellij.spring.boot.application.yaml.SpringBootApplicationYamlUtil;
import com.intellij.util.PlatformIcons;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.yaml.psi.YAMLKeyValue;
import org.jetbrains.yaml.psi.YAMLScalar;
import org.jetbrains.yaml.psi.YAMLSequence;
import org.jetbrains.yaml.psi.YAMLValue;

class SpringBootApplicationYamlPlaceholderReference
extends SpringBootPlaceholderReference {
    private static final LookupElementRenderer<LookupElement> RENDERER = new LookupElementRenderer<LookupElement>(){

        public void renderElement(LookupElement element, LookupElementPresentation presentation) {
            YAMLKeyValue yamlKeyValue = (YAMLKeyValue)element.getObject();
            presentation.setIcon(PlatformIcons.PROPERTY_ICON);
            presentation.setItemText(SpringBootApplicationYamlUtil.getQualifiedConfigKeyName(yamlKeyValue));
            TextAttributes attrs = EditorColorsManager.getInstance().getGlobalScheme().getAttributes(PropertiesHighlighter.PROPERTY_VALUE);
            String value = SpringBootApplicationYamlUtil.getValuePresentationText(yamlKeyValue);
            if (presentation instanceof RealLookupElementPresentation) {
                int limit = 500;
                if (value.length() > limit || !((RealLookupElementPresentation)presentation).hasEnoughSpaceFor(value, false)) {
                    if (value.length() > limit) {
                        value = value.substring(0, limit);
                    }
                    while (value.length() > 0 && !((RealLookupElementPresentation)presentation).hasEnoughSpaceFor(value + "...", false)) {
                        value = value.substring(0, value.length() - 1);
                    }
                    value = value + "...";
                }
            }
            presentation.setTailText("=" + value, attrs.getForegroundColor());
        }
    };

    SpringBootApplicationYamlPlaceholderReference(PsiElement element, TextRange range) {
        super(element, range);
    }

    @Nullable
    protected PsiElement resolveExistingKey(String key) {
        SpringBootApplicationYamlAccessor parser = this.getAccessor();
        return parser.findExistingKey(key);
    }

    protected void addExistingKeyVariants(List<LookupElement> result) {
        SpringBootApplicationYamlAccessor accessor = this.getAccessor();
        for (YAMLKeyValue yamlKeyValue : accessor.getAllKeys()) {
            YAMLValue yamlValue = yamlKeyValue.getValue();
            if (!(yamlValue instanceof YAMLScalar) && !(yamlValue instanceof YAMLSequence)) continue;
            String qualifiedKey = SpringBootApplicationYamlUtil.getQualifiedConfigKeyName(yamlKeyValue);
            result.add((LookupElement)LookupElementBuilder.create((Object)yamlKeyValue, (String)qualifiedKey).withRenderer(RENDERER));
        }
    }

    @NotNull
    private SpringBootApplicationYamlAccessor getAccessor() {
        SpringBootApplicationYamlAccessor springBootApplicationYamlAccessor = new SpringBootApplicationYamlAccessor(this.getElement());
        if (springBootApplicationYamlAccessor == null) {
            SpringBootApplicationYamlPlaceholderReference.$$$reportNull$$$0(0);
        }
        return springBootApplicationYamlAccessor;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/boot/application/yaml/SpringBootApplicationYamlPlaceholderReference", "getAccessor"));
    }
}

