/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.android;

import com.android.repository.Revision;
import com.android.sdklib.IAndroidTarget;
import com.android.sdklib.repository.AndroidSdkHandler;
import org.jetbrains.android.util.AndroidCommonUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.android.model.JpsAndroidSdkProperties;
import org.jetbrains.jps.model.JpsSimpleElement;
import org.jetbrains.jps.model.library.sdk.JpsSdk;

public class AndroidPlatform {
    private final JpsSdk<JpsSimpleElement<JpsAndroidSdkProperties>> mySdk;
    private final IAndroidTarget myTarget;
    private final int myPlatformToolsRevision;
    private final int mySdkToolsRevision;
    private final AndroidSdkHandler mySdkHandler;

    public AndroidPlatform(@NotNull JpsSdk<JpsSimpleElement<JpsAndroidSdkProperties>> sdk, @NotNull IAndroidTarget target, @NotNull AndroidSdkHandler sdkHandler) {
        if (sdk == null) {
            AndroidPlatform.$$$reportNull$$$0(0);
        }
        if (target == null) {
            AndroidPlatform.$$$reportNull$$$0(1);
        }
        if (sdkHandler == null) {
            AndroidPlatform.$$$reportNull$$$0(2);
        }
        this.mySdk = sdk;
        this.myTarget = target;
        String homePath = sdk.getHomePath();
        Revision rev = AndroidCommonUtils.parsePackageRevision((String)homePath, (String)"platform-tools");
        this.myPlatformToolsRevision = rev == null ? -1 : rev.getMajor();
        rev = AndroidCommonUtils.parsePackageRevision((String)homePath, (String)"tools");
        this.mySdkToolsRevision = rev == null ? -1 : rev.getMajor();
        this.mySdkHandler = sdkHandler;
    }

    @NotNull
    public JpsSdk<JpsSimpleElement<JpsAndroidSdkProperties>> getSdk() {
        JpsSdk<JpsSimpleElement<JpsAndroidSdkProperties>> jpsSdk = this.mySdk;
        if (jpsSdk == null) {
            AndroidPlatform.$$$reportNull$$$0(3);
        }
        return jpsSdk;
    }

    @NotNull
    public IAndroidTarget getTarget() {
        IAndroidTarget iAndroidTarget = this.myTarget;
        if (iAndroidTarget == null) {
            AndroidPlatform.$$$reportNull$$$0(4);
        }
        return iAndroidTarget;
    }

    public int getPlatformToolsRevision() {
        return this.myPlatformToolsRevision;
    }

    public int getSdkToolsRevision() {
        return this.mySdkToolsRevision;
    }

    public boolean needToAddAnnotationsJarToClasspath() {
        return this.myTarget.getVersion().getApiLevel() <= 15;
    }

    @NotNull
    public AndroidSdkHandler getSdkHandler() {
        AndroidSdkHandler androidSdkHandler = this.mySdkHandler;
        if (androidSdkHandler == null) {
            AndroidPlatform.$$$reportNull$$$0(5);
        }
        return androidSdkHandler;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdk";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdkHandler";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/jps/android/AndroidPlatform";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/jps/android/AndroidPlatform";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getSdk";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getTarget";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getSdkHandler";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

