/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.android;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.android.util.AndroidNativeLibData;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.incremental.storage.ValidityState;

public class AndroidApkBuilderConfigState
implements ValidityState {
    private final String myOutputApkPath;
    private final String myCustomKeystorePath;
    private final List<AndroidNativeLibData> myAdditionalNativeLibs;

    public AndroidApkBuilderConfigState(@NotNull String outputApkPath, @NotNull String customKeystorePath, @NotNull List<AndroidNativeLibData> additionalNativeLibs) {
        if (outputApkPath == null) {
            AndroidApkBuilderConfigState.$$$reportNull$$$0(0);
        }
        if (customKeystorePath == null) {
            AndroidApkBuilderConfigState.$$$reportNull$$$0(1);
        }
        if (additionalNativeLibs == null) {
            AndroidApkBuilderConfigState.$$$reportNull$$$0(2);
        }
        this.myOutputApkPath = outputApkPath;
        this.myCustomKeystorePath = customKeystorePath;
        this.myAdditionalNativeLibs = additionalNativeLibs;
    }

    public AndroidApkBuilderConfigState(DataInput in) throws IOException {
        this.myOutputApkPath = in.readUTF();
        this.myCustomKeystorePath = in.readUTF();
        int additionalNativeLibsCount = in.readInt();
        this.myAdditionalNativeLibs = new ArrayList<AndroidNativeLibData>(additionalNativeLibsCount);
        for (int i = 0; i < additionalNativeLibsCount; ++i) {
            String architecture = in.readUTF();
            String path = in.readUTF();
            String targetFileName = in.readUTF();
            this.myAdditionalNativeLibs.add(new AndroidNativeLibData(architecture, path, targetFileName));
        }
    }

    public boolean equalsTo(ValidityState otherState) {
        if (!(otherState instanceof AndroidApkBuilderConfigState)) {
            return false;
        }
        AndroidApkBuilderConfigState apkBuilderConfigState = (AndroidApkBuilderConfigState)otherState;
        return apkBuilderConfigState.myOutputApkPath.equals(this.myOutputApkPath) && apkBuilderConfigState.myCustomKeystorePath.equals(this.myCustomKeystorePath) && apkBuilderConfigState.myAdditionalNativeLibs.equals(this.myAdditionalNativeLibs);
    }

    public void save(DataOutput out) throws IOException {
        out.writeUTF(this.myOutputApkPath);
        out.writeUTF(this.myCustomKeystorePath);
        out.writeInt(this.myAdditionalNativeLibs.size());
        for (AndroidNativeLibData lib : this.myAdditionalNativeLibs) {
            out.writeUTF(lib.getArchitecture());
            out.writeUTF(lib.getPath());
            out.writeUTF(lib.getTargetFileName());
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "outputApkPath";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "customKeystorePath";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "additionalNativeLibs";
                break;
            }
        }
        objectArray[1] = "org/jetbrains/jps/android/AndroidApkBuilderConfigState";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

