/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.lang.jsp.introduceParameter;

import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateManager;
import com.intellij.codeInsight.template.impl.TemplateImpl;
import com.intellij.codeInsight.template.impl.TemplateSettings;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.jsp.JspDirectiveKind;
import com.intellij.psi.jsp.JspFile;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.xml.XmlTag;
import com.intellij.refactoring.BaseRefactoringProcessor;
import com.intellij.usageView.BaseUsageViewDescriptor;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.UsageViewDescriptor;
import com.intellij.util.ArrayUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class JspIntroduceParameterProcessor
extends BaseRefactoringProcessor {
    protected final JspFile myTagFile;
    private final String myParameterName;
    private final String myParameterValue;
    protected Editor myEditor;

    public JspIntroduceParameterProcessor(JspFile tagFile, Editor editor, String parameterName, String parameterValue) {
        super(tagFile.getProject());
        this.myTagFile = tagFile;
        this.myEditor = editor;
        this.myParameterName = parameterName;
        this.myParameterValue = parameterValue;
    }

    @NotNull
    protected UsageViewDescriptor createUsageViewDescriptor(@NotNull UsageInfo[] usages) {
        if (usages == null) {
            JspIntroduceParameterProcessor.$$$reportNull$$$0(0);
        }
        BaseUsageViewDescriptor baseUsageViewDescriptor = new BaseUsageViewDescriptor(new PsiElement[]{this.myTagFile});
        if (baseUsageViewDescriptor == null) {
            JspIntroduceParameterProcessor.$$$reportNull$$$0(1);
        }
        return baseUsageViewDescriptor;
    }

    @NotNull
    protected UsageInfo[] findUsages() {
        List infos = Collections.synchronizedList(new ArrayList());
        ReferencesSearch.search((PsiElement)this.myTagFile).forEach(psiReference -> {
            if (psiReference.isReferenceTo((PsiElement)this.myTagFile)) {
                infos.add(new UsageInfo(psiReference));
            }
            return true;
        });
        UsageInfo[] usageInfoArray = infos.toArray(UsageInfo.EMPTY_ARRAY);
        if (usageInfoArray == null) {
            JspIntroduceParameterProcessor.$$$reportNull$$$0(2);
        }
        return usageInfoArray;
    }

    protected void performRefactoring(@NotNull UsageInfo[] usages) {
        if (usages == null) {
            JspIntroduceParameterProcessor.$$$reportNull$$$0(3);
        }
        for (UsageInfo usage : usages) {
            PsiElement element = usage.getElement();
            if (!(element instanceof XmlTag)) continue;
            ((XmlTag)element).setAttribute(this.myParameterName, this.myParameterValue);
        }
        ApplicationManager.getApplication().runWriteAction(() -> {
            int attrOffset;
            Document document = this.myEditor.getDocument();
            SelectionModel selectionModel = this.myEditor.getSelectionModel();
            if (selectionModel.hasSelection()) {
                attrOffset = selectionModel.getSelectionStart();
                document.deleteString(selectionModel.getSelectionStart(), selectionModel.getSelectionEnd());
            } else {
                attrOffset = this.myEditor.getCaretModel().getOffset();
            }
            document.insertString(attrOffset, (CharSequence)this.getSubstitution(this.myParameterName));
            PsiDocumentManager.getInstance((Project)this.myProject).commitDocument(document);
            int offset = this.getDeclarationOffset();
            this.myEditor.getCaretModel().moveToOffset(offset);
        });
        TemplateImpl template = this.getTemplate();
        template.setToReformat(true);
        template.setToIndent(true);
        Map<String, String> values = this.getTemplateProperties();
        TemplateManager.getInstance((Project)this.myProject).startTemplate(this.myEditor, (Template)template, true, values, null);
    }

    protected String getSubstitution(String parameterName) {
        return "${" + parameterName + "}";
    }

    protected Map<String, String> getTemplateProperties() {
        HashMap<String, String> values = new HashMap<String, String>();
        values.put("NAME", this.myParameterName);
        return values;
    }

    protected int getDeclarationOffset() {
        XmlTag anchor = (XmlTag)ArrayUtil.getLastElement((Object[])this.myTagFile.getDirectiveTags(JspDirectiveKind.ATTRIBUTE, false));
        if (anchor == null) {
            anchor = (XmlTag)ArrayUtil.getLastElement((Object[])this.myTagFile.getDirectiveTags(JspDirectiveKind.PAGE, false));
        }
        return anchor == null ? 0 : anchor.getTextRange().getEndOffset();
    }

    protected TemplateImpl getTemplate() {
        return TemplateSettings.getInstance().getTemplate("jspa", "JSP");
    }

    @NotNull
    protected String getCommandName() {
        if ("Introduce JSP parameter" == null) {
            JspIntroduceParameterProcessor.$$$reportNull$$$0(4);
        }
        return "Introduce JSP parameter";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usages";
                break;
            }
            case 1: 
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/refactoring/lang/jsp/introduceParameter/JspIntroduceParameterProcessor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/refactoring/lang/jsp/introduceParameter/JspIntroduceParameterProcessor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createUsageViewDescriptor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "findUsages";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommandName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createUsageViewDescriptor";
                break;
            }
            case 1: 
            case 2: 
            case 4: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "performRefactoring";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

