/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.resolve.reference.impl.providers;

import com.intellij.codeInsight.daemon.EmptyResolveMessageProvider;
import com.intellij.codeInsight.daemon.XmlErrorMessages;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.JspPsiUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.impl.source.jsp.JspManager;
import com.intellij.psi.impl.source.jsp.JspManagerImpl;
import com.intellij.psi.impl.source.resolve.reference.impl.CachingReference;
import com.intellij.psi.jsp.JspFile;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.util.Function;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.NullableFunction;
import com.intellij.util.ProcessingContext;
import com.intellij.util.containers.ContainerUtil;
import org.jetbrains.annotations.NotNull;

public class JspUriReferenceProvider
extends PsiReferenceProvider {
    @NotNull
    public PsiReference[] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context) {
        if (element == null) {
            JspUriReferenceProvider.$$$reportNull$$$0(0);
        }
        if (context == null) {
            JspUriReferenceProvider.$$$reportNull$$$0(1);
        }
        if (element instanceof XmlAttributeValue) {
            PsiReference[] psiReferenceArray = new PsiReference[]{new UriReference((XmlAttributeValue)element)};
            if (psiReferenceArray == null) {
                JspUriReferenceProvider.$$$reportNull$$$0(2);
            }
            return psiReferenceArray;
        }
        if (PsiReference.EMPTY_ARRAY == null) {
            JspUriReferenceProvider.$$$reportNull$$$0(3);
        }
        return PsiReference.EMPTY_ARRAY;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/source/resolve/reference/impl/providers/JspUriReferenceProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/source/resolve/reference/impl/providers/JspUriReferenceProvider";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getReferencesByElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getReferencesByElement";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static class UriReference
    extends CachingReference
    implements EmptyResolveMessageProvider {
        private final XmlAttributeValue myElement;

        UriReference(XmlAttributeValue element) {
            this.myElement = element;
        }

        @NotNull
        public PsiElement getElement() {
            XmlAttributeValue xmlAttributeValue = this.myElement;
            if (xmlAttributeValue == null) {
                UriReference.$$$reportNull$$$0(0);
            }
            return xmlAttributeValue;
        }

        @NotNull
        public String getUnresolvedMessagePattern() {
            String string = XmlErrorMessages.message((String)"cannot.resolve.taglib.uri", (Object[])new Object[0]);
            if (string == null) {
                UriReference.$$$reportNull$$$0(1);
            }
            return string;
        }

        @NotNull
        public TextRange getRangeInElement() {
            TextRange textRange = this.myElement.getValueTextRange().shiftRight(-this.myElement.getTextRange().getStartOffset());
            if (textRange == null) {
                UriReference.$$$reportNull$$$0(2);
            }
            return textRange;
        }

        public PsiElement resolveInner() {
            String uri = this.getCanonicalText();
            if (uri.startsWith("urn:jsptagdir:")) {
                return null;
            }
            JspFile jspFile = JspPsiUtil.getJspFile((PsiElement)this.myElement.getContainingFile());
            return JspManager.getInstance((Project)this.myElement.getProject()).getTldFileByUri(uri, jspFile);
        }

        @NotNull
        public String getCanonicalText() {
            String string = this.myElement.getValue();
            if (string == null) {
                UriReference.$$$reportNull$$$0(3);
            }
            return string;
        }

        public PsiElement handleElementRename(@NotNull String newElementName) throws IncorrectOperationException {
            if (newElementName == null) {
                UriReference.$$$reportNull$$$0(4);
            }
            return null;
        }

        public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
            if (element == null) {
                UriReference.$$$reportNull$$$0(5);
            }
            return null;
        }

        @NotNull
        public Object[] getVariants() {
            JspFile jspFile = JspPsiUtil.getJspFile((PsiElement)this.myElement.getContainingFile());
            Object[] possibleTldUris = JspManagerImpl.getInstance(jspFile.getProject()).getPossibleTldUris(jspFile);
            Object[] objectArray = ContainerUtil.mapNotNull((Object[])possibleTldUris, (Function)((NullableFunction)s -> s.startsWith("urn:jsptagdir:") ? null : s)).toArray();
            if (objectArray == null) {
                UriReference.$$$reportNull$$$0(6);
            }
            return objectArray;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 4: 
                case 5: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 4: 
                case 5: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/psi/impl/source/resolve/reference/impl/providers/JspUriReferenceProvider$UriReference";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "newElementName";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getElement";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getUnresolvedMessagePattern";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getRangeInElement";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getCanonicalText";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/psi/impl/source/resolve/reference/impl/providers/JspUriReferenceProvider$UriReference";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getVariants";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "handleElementRename";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "bindToElement";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 4: 
                case 5: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

