/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.formatter.xml;

import com.intellij.formatting.Alignment;
import com.intellij.formatting.Block;
import com.intellij.formatting.ChildAttributes;
import com.intellij.formatting.Indent;
import com.intellij.formatting.Spacing;
import com.intellij.formatting.Wrap;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageFormatting;
import com.intellij.lang.StdLanguages;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JspPsiUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.formatter.common.AbstractBlock;
import com.intellij.psi.formatter.xml.JspTagBlock;
import com.intellij.psi.formatter.xml.JspTextBlock;
import com.intellij.psi.formatter.xml.XmlBlock;
import com.intellij.psi.formatter.xml.XmlFormattingPolicy;
import com.intellij.psi.formatter.xml.XmlTagBlock;
import com.intellij.psi.impl.source.SourceTreeToPsiMap;
import com.intellij.psi.impl.source.jsp.jspXml.JspDeclaration;
import com.intellij.psi.impl.source.jsp.jspXml.JspScriptlet;
import com.intellij.psi.jsp.BaseJspElementType;
import com.intellij.psi.jsp.JspTokenType;
import com.intellij.psi.templateLanguages.OuterLanguageElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.xml.XmlElementType;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlTokenType;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class JspBlock
extends XmlBlock {
    @NonNls
    public static final String JSPX_DECLARATION_TAG_NAME = "jsp:declaration";
    @NonNls
    public static final String JSPX_SCRIPTLET_TAG_NAME = "jsp:scriptlet";
    @NonNls
    protected static final String JSP_TAG_PREFIX = "jsp:";

    public JspBlock(ASTNode node, Wrap wrap, Alignment alignment, XmlFormattingPolicy policy, Indent indent, TextRange textRange) {
        super(node, wrap, alignment, policy, indent, textRange);
    }

    protected XmlBlock createSimpleChild(ASTNode child, Indent indent, Wrap wrap, Alignment alignment) {
        return new JspBlock(child, wrap, alignment, this.myXmlFormattingPolicy, indent, null);
    }

    protected XmlTagBlock createTagBlock(ASTNode child, Indent indent, Wrap wrap, Alignment alignment) {
        return new JspTagBlock(child, wrap, alignment, this.myXmlFormattingPolicy, indent != null ? indent : Indent.getNoneIndent());
    }

    protected Indent getChildDefaultIndent() {
        if (this.myNode.getElementType() == BaseJspElementType.JSP_SCRIPTLET) {
            return Indent.getNoneIndent();
        }
        if (this.myNode.getElementType() == BaseJspElementType.JSP_DECLARATION) {
            return Indent.getNoneIndent();
        }
        if (this.myNode.getElementType() == BaseJspElementType.JSP_EXPRESSION) {
            return Indent.getNoneIndent();
        }
        return super.getChildDefaultIndent();
    }

    @NotNull
    public ChildAttributes getChildAttributes(int newChildIndex) {
        if (this.myNode.getElementType() == BaseJspElementType.JSP_DECLARATION || this.myNode.getElementType() == BaseJspElementType.JSP_SCRIPTLET) {
            List subBlocks = this.getSubBlocks();
            if (subBlocks.size() == 3 && subBlocks.get(1) instanceof JspTextBlock) {
                JspTextBlock jspTextBlock = (JspTextBlock)((Object)subBlocks.get(1));
                if (newChildIndex == 2 && jspTextBlock.isTailIncomplete()) {
                    ChildAttributes childAttributes = ChildAttributes.DELEGATE_TO_PREV_CHILD;
                    if (childAttributes == null) {
                        JspBlock.$$$reportNull$$$0(0);
                    }
                    return childAttributes;
                }
                if (newChildIndex == 1 && jspTextBlock.isHeadIncomplete()) {
                    ChildAttributes childAttributes = ChildAttributes.DELEGATE_TO_NEXT_CHILD;
                    if (childAttributes == null) {
                        JspBlock.$$$reportNull$$$0(1);
                    }
                    return childAttributes;
                }
            }
            ChildAttributes childAttributes = new ChildAttributes(Indent.getNormalIndent(), null);
            if (childAttributes == null) {
                JspBlock.$$$reportNull$$$0(2);
            }
            return childAttributes;
        }
        ChildAttributes childAttributes = super.getChildAttributes(newChildIndex);
        if (childAttributes == null) {
            JspBlock.$$$reportNull$$$0(3);
        }
        return childAttributes;
    }

    public Spacing getSpacing(Block child1, @NotNull Block child2) {
        if (child2 == null) {
            JspBlock.$$$reportNull$$$0(4);
        }
        if (!(child1 instanceof AbstractBlock) || !(child2 instanceof AbstractBlock)) {
            return null;
        }
        ASTNode node1 = ((AbstractBlock)child1).getNode();
        IElementType type1 = node1.getElementType();
        ASTNode node2 = ((AbstractBlock)child2).getNode();
        IElementType type2 = node2.getElementType();
        if (type1 == JspTokenType.JSP_DECLARATION_START || type1 == JspTokenType.JSP_SCRIPTLET_START) {
            return Spacing.createDependentLFSpacing((int)0, (int)1, (TextRange)node2.getTextRange(), (boolean)this.myXmlFormattingPolicy.getShouldKeepLineBreaks(), (int)this.myXmlFormattingPolicy.getKeepBlankLines());
        }
        if (type2 == JspTokenType.JSP_DECLARATION_END || type2 == JspTokenType.JSP_SCRIPTLET_END) {
            return Spacing.createDependentLFSpacing((int)0, (int)1, (TextRange)node1.getTextRange(), (boolean)this.myXmlFormattingPolicy.getShouldKeepLineBreaks(), (int)this.myXmlFormattingPolicy.getKeepBlankLines());
        }
        return super.getSpacing(child1, child2);
    }

    protected boolean isJspxJavaContainingNode(ASTNode child) {
        if (child.getElementType() != XmlElementType.XML_TEXT) {
            return false;
        }
        ASTNode treeParent = child.getTreeParent();
        if (treeParent == null) {
            return false;
        }
        if (treeParent.getElementType() != XmlElementType.XML_TAG) {
            return false;
        }
        PsiElement psiElement = SourceTreeToPsiMap.treeElementToPsi((ASTNode)treeParent);
        String name = ((XmlTag)psiElement).getName();
        if (!Comparing.equal((String)name, (String)JSPX_SCRIPTLET_TAG_NAME) && !Comparing.equal((String)name, (String)JSPX_DECLARATION_TAG_NAME)) {
            return false;
        }
        if (child.getText().trim().isEmpty()) {
            return false;
        }
        return JspTextBlock.findPsiRootAt(child, this.myXmlFormattingPolicy.processJavaTree()) != null;
    }

    protected boolean canWrapTagEnd(XmlTag tag) {
        String name = tag.getName();
        return tag.getSubTags().length > 0 || StringUtil.startsWithIgnoreCase((String)name, (String)JSP_TAG_PREFIX);
    }

    protected XmlTag findXmlTagAt(ASTNode child, int startOffset) {
        return JspTextBlock.findJspTag(child, startOffset);
    }

    protected XmlTag getAnotherTreeTag(ASTNode child) {
        boolean b = !(!this.myXmlFormattingPolicy.processJsp() || JspPsiUtil.getJspFile((PsiElement)this.myNode.getPsi()) == null || !this.isXmlTag(this.myNode) && this.myNode.getElementType() != XmlElementType.HTML_DOCUMENT && !(this.myNode.getPsi() instanceof PsiFile) || child.getElementType() != XmlTokenType.XML_DATA_CHARACTERS && child.getElementType() != BaseJspElementType.JSP_XML_TEXT && !(child.getPsi() instanceof OuterLanguageElement));
        return b ? this.findXmlTagAt(child, child.getStartOffset()) : null;
    }

    protected ASTNode createAnotherTreeNode(List<? super Block> result, ASTNode child, PsiElement tag, Indent indent, Wrap wrap, Alignment alignment) {
        TextRange childRange;
        Indent childIndent = indent;
        if (this.myNode.getElementType() == XmlElementType.HTML_DOCUMENT && tag.getParent() instanceof XmlTag && this.myXmlFormattingPolicy.indentChildrenOf((XmlTag)tag.getParent())) {
            childIndent = Indent.getNormalIndent();
        }
        result.add((Block)this.createAnotherTreeTagBlock(tag, childIndent));
        TextRange tagRange = tag.getTextRange();
        ASTNode currentChild = JspBlock.findChildAfter((ASTNode)child, (int)tagRange.getEndOffset());
        TextRange textRange = childRange = currentChild != null ? currentChild.getTextRange() : null;
        while (currentChild != null && childRange.getEndOffset() > tagRange.getEndOffset()) {
            XmlTag psiElement = this.findXmlTagAt(currentChild, tagRange.getEndOffset());
            if (psiElement != null) {
                if (psiElement instanceof XmlTag && psiElement.getTextRange().getStartOffset() >= childRange.getStartOffset() && this.containsTag((PsiElement)psiElement) && this.doesNotIntersectSubTagsWith((PsiElement)psiElement)) {
                    result.add((Block)this.createAnotherTreeTagBlock((PsiElement)psiElement, childIndent));
                    currentChild = JspBlock.findChildAfter((ASTNode)currentChild, (int)psiElement.getTextRange().getEndOffset());
                    childRange = currentChild != null ? currentChild.getTextRange() : null;
                    tagRange = psiElement.getTextRange();
                    continue;
                }
                result.add((Block)new JspBlock(currentChild, wrap, alignment, this.myXmlFormattingPolicy, indent, new TextRange(tagRange.getEndOffset(), childRange.getEndOffset())));
                return currentChild;
            }
            result.add((Block)new JspBlock(currentChild, wrap, alignment, this.myXmlFormattingPolicy, indent, new TextRange(tagRange.getEndOffset(), childRange.getEndOffset())));
            return currentChild;
        }
        return currentChild;
    }

    protected Block createAnotherTreeTagBlock(PsiElement tag, Indent childIndent) {
        if (this.isXmlTag(tag)) {
            return new JspTagBlock(tag.getNode(), null, null, this.createPolicyFor(), childIndent);
        }
        return new JspBlock(tag.getNode(), null, null, this.createPolicyFor(), childIndent, tag.getTextRange());
    }

    protected boolean useMyFormatter(Language myLanguage, Language childLanguage, PsiElement childPsi) {
        return myLanguage == childLanguage || childLanguage == StdLanguages.JAVA || childLanguage == StdLanguages.HTML || childLanguage == StdLanguages.XHTML || childLanguage == StdLanguages.XML || childLanguage == StdLanguages.JSP || childLanguage == StdLanguages.JSPX || LanguageFormatting.INSTANCE.forContext(childPsi) == null;
    }

    protected void processSimpleChild(ASTNode child, Indent indent, List<? super Block> result, Wrap wrap, Alignment alignment) {
        Pair<PsiElement, Language> root;
        if (this.myXmlFormattingPolicy.processJsp() && (child.getElementType() == BaseJspElementType.JSP_XML_TEXT || child.getPsi() instanceof OuterLanguageElement) && (root = JspTextBlock.findPsiRootAt(child, this.myXmlFormattingPolicy.processJavaTree())) != null) {
            this.createJspTextNode(result, child, indent);
            return;
        }
        super.processSimpleChild(child, indent, result, wrap, alignment);
    }

    protected void createJspTextNode(List<? super Block> localResult, ASTNode child, Indent indent) {
        localResult.add((Block)new JspTextBlock(child, this.myXmlFormattingPolicy, JspTextBlock.findPsiRootAt(child, this.myXmlFormattingPolicy.processJavaTree()), indent));
    }

    protected boolean isXmlTag(PsiElement psi) {
        return psi instanceof XmlTag && !(psi instanceof JspScriptlet) && !(psi instanceof JspDeclaration);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 4: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 4: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/formatter/xml/JspBlock";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "child2";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildAttributes";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/formatter/xml/JspBlock";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getSpacing";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 4: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

