/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jsp.index;

import com.intellij.jsp.index.JspDirectiveProcessor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypes;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.include.FileIncludeInfo;
import com.intellij.psi.impl.include.FileIncludeProvider;
import com.intellij.psi.impl.source.PsiFileImpl;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceSet;
import com.intellij.psi.jsp.JspDirectiveKind;
import com.intellij.psi.jsp.JspUtil;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.Consumer;
import com.intellij.util.indexing.FileContent;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JspIncludeProvider
extends FileIncludeProvider {
    @NotNull
    public String getId() {
        if ("jsp" == null) {
            JspIncludeProvider.$$$reportNull$$$0(0);
        }
        return "jsp";
    }

    public boolean acceptFile(VirtualFile file) {
        FileType fileType = file.getFileType();
        return fileType == StdFileTypes.JSP || fileType == StdFileTypes.JSPX || fileType == StdFileTypes.XHTML;
    }

    public void registerFileTypesUsedForIndexing(@NotNull Consumer<FileType> fileTypeSink) {
        if (fileTypeSink == null) {
            JspIncludeProvider.$$$reportNull$$$0(1);
        }
        fileTypeSink.consume((Object)StdFileTypes.JSP);
        fileTypeSink.consume((Object)StdFileTypes.JSPX);
        fileTypeSink.consume((Object)StdFileTypes.XHTML);
    }

    @NotNull
    public FileIncludeInfo[] getIncludeInfos(FileContent content) {
        Project project = content.getProject();
        if (project == null) {
            project = ProjectManager.getInstance().getDefaultProject();
        }
        PsiManager psiManager = PsiManager.getInstance((Project)project);
        final ArrayList list = new ArrayList();
        new JspDirectiveProcessor(psiManager, !content.getFileType().equals(StdFileTypes.JSP)){

            @Override
            public void processDirective(XmlTag directive, JspDirectiveKind directiveKind, int offset) {
                String value;
                if (directive.getName().endsWith("include") && (value = directive.getAttributeValue("file")) != null) {
                    list.add(new FileIncludeInfo(value, offset));
                }
            }
        }.processDirectives(content.getContentAsText());
        FileIncludeInfo[] fileIncludeInfoArray = list.toArray(FileIncludeInfo.EMPTY);
        if (fileIncludeInfoArray == null) {
            JspIncludeProvider.$$$reportNull$$$0(2);
        }
        return fileIncludeInfoArray;
    }

    @Nullable
    public PsiFileSystemItem resolveIncludedFile(@NotNull FileIncludeInfo info, @NotNull PsiFile context) {
        if (info == null) {
            JspIncludeProvider.$$$reportNull$$$0(3);
        }
        if (context == null) {
            JspIncludeProvider.$$$reportNull$$$0(4);
        }
        PsiFileFactory factory = PsiFileFactory.getInstance((Project)context.getProject());
        PsiFileImpl psiFile = (PsiFileImpl)factory.createFileFromText("dummy.txt", (FileType)FileTypes.PLAIN_TEXT, (CharSequence)info.path);
        psiFile.setOriginalFile(context);
        FileReferenceSet referenceSet = new FileReferenceSet((PsiElement)psiFile){

            protected boolean useIncludingFileAsContext() {
                return false;
            }
        };
        return JspUtil.resolveReferenceSet(referenceSet, context);
    }

    public int getVersion() {
        return 1;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/jsp/index/JspIncludeProvider";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileTypeSink";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getId";
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/jsp/index/JspIncludeProvider";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getIncludeInfos";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "registerFileTypesUsedForIndexing";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "resolveIncludedFile";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

