/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.jsp;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.XmlSuppressableInspectionTool;
import com.intellij.jsp.impl.CustomTagDescriptorBase;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.XmlElementVisitor;
import com.intellij.psi.impl.source.jsp.jspXml.JspScriptlet;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlText;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xml.XmlElementDescriptor;
import com.intellij.xml.util.CheckTagEmptyBodyInspection;
import org.jetbrains.annotations.NotNull;

public class JspTagBodyContentInspection
extends XmlSuppressableInspectionTool {
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            JspTagBodyContentInspection.$$$reportNull$$$0(0);
        }
        XmlElementVisitor xmlElementVisitor = new XmlElementVisitor(){

            public void visitXmlTag(XmlTag tag) {
                XmlElementDescriptor descriptor = tag.getDescriptor();
                if (descriptor instanceof CustomTagDescriptorBase) {
                    int type = descriptor.getContentType();
                    switch (type) {
                        case 0: {
                            if (tag.isEmpty() || ContainerUtil.find((Object[])tag.getValue().getChildren(), tag1 -> {
                                if (tag1 instanceof XmlText && !StringUtil.isEmptyOrSpaces((String)((XmlText)tag1).getValue())) {
                                    return true;
                                }
                                return tag1 instanceof XmlTag && !"http://java.sun.com/JSP/Page".equals(((XmlTag)tag1).getNamespace());
                            }) == null) break;
                            holder.registerProblem((PsiElement)tag, "No content allowed inside tags with 'empty' content type", new LocalQuickFix[]{new CheckTagEmptyBodyInspection.Fix()});
                            break;
                        }
                        case 101: {
                            JspScriptlet[] scriptlets = (JspScriptlet[])PsiTreeUtil.getChildrenOfType((PsiElement)tag, JspScriptlet.class);
                            if (scriptlets == null) break;
                            for (JspScriptlet scriptlet : scriptlets) {
                                holder.registerProblem((PsiElement)scriptlet, "Scripting is not allowed inside tags with 'scriptless' content type", new LocalQuickFix[]{new RemoveScriptletsFix()});
                            }
                            break;
                        }
                    }
                }
            }
        };
        if (xmlElementVisitor == null) {
            JspTagBodyContentInspection.$$$reportNull$$$0(1);
        }
        return xmlElementVisitor;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/jsp/JspTagBodyContentInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/jsp/JspTagBodyContentInspection";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class RemoveScriptletsFix
    implements LocalQuickFix {
        private RemoveScriptletsFix() {
        }

        @NotNull
        public String getFamilyName() {
            if ("Remove scriptlet(s)" == null) {
                RemoveScriptletsFix.$$$reportNull$$$0(0);
            }
            return "Remove scriptlet(s)";
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            if (project == null) {
                RemoveScriptletsFix.$$$reportNull$$$0(1);
            }
            if (descriptor == null) {
                RemoveScriptletsFix.$$$reportNull$$$0(2);
            }
            PsiElement element = descriptor.getPsiElement();
            WriteCommandAction.writeCommandAction((Project)project, (PsiFile[])new PsiFile[]{element.getContainingFile()}).run(() -> {
                JspScriptlet[] scriptlets = (JspScriptlet[])PsiTreeUtil.getChildrenOfType((PsiElement)element.getParent(), JspScriptlet.class);
                assert (scriptlets != null);
                for (JspScriptlet scriptlet : scriptlets) {
                    scriptlet.delete();
                }
            });
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/jsp/JspTagBodyContentInspection$RemoveScriptletsFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/jsp/JspTagBodyContentInspection$RemoveScriptletsFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

