/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.intelliLang.pattern;

import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import java.util.Set;
import org.intellij.plugins.intelliLang.Configuration;
import org.intellij.plugins.intelliLang.util.AnnotateFix;
import org.intellij.plugins.intelliLang.util.AnnotationUtilEx;
import org.intellij.plugins.intelliLang.util.PsiUtilEx;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class PatternOverriddenByNonAnnotatedMethod
extends LocalInspectionTool {
    public boolean isEnabledByDefault() {
        return true;
    }

    @NotNull
    public String getGroupDisplayName() {
        if ("Pattern Validation" == null) {
            PatternOverriddenByNonAnnotatedMethod.$$$reportNull$$$0(0);
        }
        return "Pattern Validation";
    }

    @NotNull
    public String getDisplayName() {
        if ("Non-annotated Method overrides @Pattern Method" == null) {
            PatternOverriddenByNonAnnotatedMethod.$$$reportNull$$$0(1);
        }
        return "Non-annotated Method overrides @Pattern Method";
    }

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            PatternOverriddenByNonAnnotatedMethod.$$$reportNull$$$0(2);
        }
        JavaElementVisitor javaElementVisitor = new JavaElementVisitor(){
            final Pair<String, ? extends Set<String>> annotationName;
            {
                this.annotationName = Configuration.getProjectInstance(holder.getProject()).getAdvancedConfiguration().getPatternAnnotationPair();
            }

            public void visitMethod(PsiMethod method) {
                PsiAnnotation[] annotationFromHierarchy;
                PsiIdentifier psiIdentifier = method.getNameIdentifier();
                if (psiIdentifier == null || !PsiUtilEx.isLanguageAnnotationTarget((PsiModifierListOwner)method)) {
                    return;
                }
                PsiAnnotation[] annotationFrom = AnnotationUtilEx.getAnnotationFrom((PsiModifierListOwner)method, this.annotationName, true, false);
                if (annotationFrom.length == 0 && (annotationFromHierarchy = AnnotationUtilEx.getAnnotationFrom((PsiModifierListOwner)method, this.annotationName, true, true)).length > 0) {
                    String annotationClassname = annotationFromHierarchy[annotationFromHierarchy.length - 1].getQualifiedName();
                    String argList = annotationFromHierarchy[annotationFromHierarchy.length - 1].getParameterList().getText();
                    holder.registerProblem((PsiElement)psiIdentifier, "Non-annotated Method overrides @Pattern Method", new LocalQuickFix[]{new AnnotateFix(annotationClassname, argList)});
                }
            }
        };
        if (javaElementVisitor == null) {
            PatternOverriddenByNonAnnotatedMethod.$$$reportNull$$$0(3);
        }
        return javaElementVisitor;
    }

    @NotNull
    @NonNls
    public String getShortName() {
        if ("PatternOverriddenByNonAnnotatedMethod" == null) {
            PatternOverriddenByNonAnnotatedMethod.$$$reportNull$$$0(4);
        }
        return "PatternOverriddenByNonAnnotatedMethod";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/intellij/plugins/intelliLang/pattern/PatternOverriddenByNonAnnotatedMethod";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getGroupDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "org/intellij/plugins/intelliLang/pattern/PatternOverriddenByNonAnnotatedMethod";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getShortName";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

