/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uiDesigner;

import com.intellij.ProjectTopics;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootEvent;
import com.intellij.openapi.roots.ModuleRootListener;
import com.intellij.openapi.roots.OrderEnumerator;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.impl.jar.JarFileSystemImpl;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.PathUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.lang.UrlClassLoader;
import com.intellij.util.messages.MessageBusConnection;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import java.util.concurrent.ConcurrentMap;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import org.jetbrains.annotations.NotNull;

public final class LoaderFactory {
    private final Project myProject;
    private final ConcurrentMap<Module, ClassLoader> myModule2ClassLoader;
    private ClassLoader myProjectClassLoader = null;
    private final MessageBusConnection myConnection;

    public static LoaderFactory getInstance(Project project) {
        return (LoaderFactory)ServiceManager.getService((Project)project, LoaderFactory.class);
    }

    public LoaderFactory(Project project) {
        this.myProject = project;
        this.myModule2ClassLoader = ContainerUtil.createConcurrentWeakMap();
        this.myConnection = this.myProject.getMessageBus().connect();
        this.myConnection.subscribe(ProjectTopics.PROJECT_ROOTS, (Object)new ModuleRootListener(){

            public void rootsChanged(@NotNull ModuleRootEvent event) {
                if (event == null) {
                    1.$$$reportNull$$$0(0);
                }
                LoaderFactory.this.clearClassLoaderCache();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/uiDesigner/LoaderFactory$1", "rootsChanged"));
            }
        });
        Disposer.register((Disposable)project, (Disposable)new Disposable(){

            public void dispose() {
                LoaderFactory.this.myConnection.disconnect();
                LoaderFactory.this.myModule2ClassLoader.clear();
            }
        });
    }

    @NotNull
    public ClassLoader getLoader(VirtualFile formFile) {
        Module module = ModuleUtil.findModuleForFile((VirtualFile)formFile, (Project)this.myProject);
        if (module == null) {
            ClassLoader classLoader = this.getClass().getClassLoader();
            if (classLoader == null) {
                LoaderFactory.$$$reportNull$$$0(0);
            }
            return classLoader;
        }
        ClassLoader classLoader = this.getLoader(module);
        if (classLoader == null) {
            LoaderFactory.$$$reportNull$$$0(1);
        }
        return classLoader;
    }

    public ClassLoader getLoader(Module module) {
        ClassLoader cachedLoader = (ClassLoader)this.myModule2ClassLoader.get(module);
        if (cachedLoader != null) {
            return cachedLoader;
        }
        String runClasspath = OrderEnumerator.orderEntries((Module)module).recursively().getPathsList().getPathsString();
        ClassLoader classLoader = LoaderFactory.createClassLoader(runClasspath, module.getName());
        this.myModule2ClassLoader.put(module, classLoader);
        return classLoader;
    }

    @NotNull
    public ClassLoader getProjectClassLoader() {
        if (this.myProjectClassLoader == null) {
            String runClasspath = OrderEnumerator.orderEntries((Project)this.myProject).withoutSdk().getPathsList().getPathsString();
            this.myProjectClassLoader = LoaderFactory.createClassLoader(runClasspath, "<project>");
        }
        ClassLoader classLoader = this.myProjectClassLoader;
        if (classLoader == null) {
            LoaderFactory.$$$reportNull$$$0(2);
        }
        return classLoader;
    }

    private static ClassLoader createClassLoader(String runClasspath, String moduleName) {
        ArrayList<URL> urls = new ArrayList<URL>();
        VirtualFileManager manager = VirtualFileManager.getInstance();
        JarFileSystemImpl fileSystem = (JarFileSystemImpl)JarFileSystem.getInstance();
        StringTokenizer tokenizer = new StringTokenizer(runClasspath, File.pathSeparator);
        while (tokenizer.hasMoreTokens()) {
            String s = tokenizer.nextToken();
            try {
                VirtualFile vFile = manager.findFileByUrl(VfsUtil.pathToUrl((String)s));
                File realFile = fileSystem.getMirroredFile(vFile);
                urls.add(realFile != null ? realFile.toURI().toURL() : new File(s).toURI().toURL());
            }
            catch (Exception exception) {}
        }
        try {
            urls.add(new File(PathUtil.getJarPathForClass(Spacer.class)).toURI().toURL());
        }
        catch (MalformedURLException s) {
            // empty catch block
        }
        URL[] _urls = urls.toArray(new URL[0]);
        return new DesignTimeClassLoader(Arrays.asList(_urls), LoaderFactory.class.getClassLoader(), moduleName);
    }

    public void clearClassLoaderCache() {
        UIDefaults uiDefaults = UIManager.getDefaults();
        Iterator it = uiDefaults.keySet().iterator();
        while (it.hasNext()) {
            ClassLoader loader;
            Object key = it.next();
            Object value = uiDefaults.get(key);
            if (!(value instanceof Class) || !((loader = ((Class)value).getClassLoader()) instanceof DesignTimeClassLoader)) continue;
            it.remove();
        }
        this.myModule2ClassLoader.clear();
        this.myProjectClassLoader = null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/uiDesigner/LoaderFactory";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getLoader";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getProjectClassLoader";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static class DesignTimeClassLoader
    extends UrlClassLoader {
        private final String myModuleName;

        DesignTimeClassLoader(List<URL> urls, ClassLoader parent, String moduleName) {
            super(DesignTimeClassLoader.build().urls(urls).parent(parent));
            this.myModuleName = moduleName;
        }

        public String toString() {
            return "DesignTimeClassLoader:" + this.myModuleName;
        }

        static {
            if (DesignTimeClassLoader.registerAsParallelCapable()) {
                DesignTimeClassLoader.markParallelCapable(DesignTimeClassLoader.class);
            }
        }
    }
}

