/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.appengine.facet;

import com.intellij.appengine.facet.AppEngineFacet;
import com.intellij.appengine.facet.AppEngineFacetConfiguration;
import com.intellij.appengine.facet.AppEngineSdkEditor;
import com.intellij.appengine.facet.AppEngineWebIntegration;
import com.intellij.appengine.facet.PersistenceApiComboboxUtil;
import com.intellij.appengine.sdk.impl.AppEngineSdkUtil;
import com.intellij.appengine.util.AppEngineUtil;
import com.intellij.facet.Facet;
import com.intellij.facet.ui.FacetEditorContext;
import com.intellij.facet.ui.FacetEditorTab;
import com.intellij.facet.ui.FacetEditorValidator;
import com.intellij.facet.ui.FacetValidatorsManager;
import com.intellij.facet.ui.ValidationResult;
import com.intellij.ide.presentation.VirtualFilePresentation;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootModel;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.AnActionButtonRunnable;
import com.intellij.ui.GuiUtils;
import com.intellij.ui.JBColor;
import com.intellij.ui.RightAlignedLabelUI;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.components.JBList;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.PlatformIcons;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListModel;
import javax.swing.plaf.LabelUI;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.model.java.JavaModuleSourceRootTypes;

public class AppEngineFacetEditor
extends FacetEditorTab {
    private final AppEngineFacetConfiguration myFacetConfiguration;
    private final FacetEditorContext myContext;
    private JPanel myMainPanel;
    private JPanel mySdkEditorPanel;
    private JCheckBox myRunEnhancerOnMakeCheckBox;
    private JPanel myFilesToEnhancePanel;
    private final JList myFilesList;
    private JComboBox myPersistenceApiComboBox;
    private JPanel myFilesPanel;
    private final AppEngineSdkEditor mySdkEditor;
    private final DefaultListModel myFilesListModel;

    public AppEngineFacetEditor(AppEngineFacetConfiguration facetConfiguration, FacetEditorContext context, FacetValidatorsManager validatorsManager) {
        this.myFacetConfiguration = facetConfiguration;
        this.myContext = context;
        this.$$$setupUI$$$();
        this.mySdkEditor = new AppEngineSdkEditor(this.myContext.getProject());
        validatorsManager.registerValidator(new FacetEditorValidator(){

            @NotNull
            public ValidationResult check() {
                ValidationResult validationResult = AppEngineSdkUtil.checkPath(AppEngineFacetEditor.this.mySdkEditor.getPath());
                if (validationResult == null) {
                    1.$$$reportNull$$$0(0);
                }
                return validationResult;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/appengine/facet/AppEngineFacetEditor$1", "check"));
            }
        }, new JComponent[]{this.mySdkEditor.getComboBox()});
        this.myRunEnhancerOnMakeCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GuiUtils.enableChildren((boolean)AppEngineFacetEditor.this.myRunEnhancerOnMakeCheckBox.isSelected(), (Component[])new Component[]{AppEngineFacetEditor.this.myFilesToEnhancePanel});
                if (AppEngineFacetEditor.this.myRunEnhancerOnMakeCheckBox.isSelected() && AppEngineFacetEditor.this.myFilesListModel.isEmpty()) {
                    AppEngineFacetEditor.this.fillFilesList(AppEngineUtil.getDefaultSourceRootsToEnhance(AppEngineFacetEditor.this.myContext.getRootModel()));
                }
            }
        });
        this.myFilesListModel = new DefaultListModel();
        this.myFilesList = new JBList((ListModel)this.myFilesListModel);
        this.myFilesList.setCellRenderer(new FilesListCellRenderer());
        this.myFilesPanel.add((Component)ToolbarDecorator.createDecorator((JList)this.myFilesList).setAddAction(new AnActionButtonRunnable(){

            public void run(AnActionButton button) {
                AppEngineFacetEditor.this.doAdd();
            }
        }).disableUpDownActions().createPanel(), "Center");
        PersistenceApiComboboxUtil.setComboboxModel(this.myPersistenceApiComboBox, false);
    }

    private void doAdd() {
        VirtualFile[] files;
        FileChooserDescriptor descriptor = new FileChooserDescriptor(true, true, false, false, false, true);
        ModuleRootModel rootModel = this.myContext.getRootModel();
        descriptor.setRoots(rootModel.getSourceRoots(JavaModuleSourceRootTypes.SOURCES));
        for (VirtualFile file : files = FileChooser.chooseFiles((FileChooserDescriptor)descriptor, (Project)this.myContext.getProject(), null)) {
            this.myFilesListModel.addElement(file.getPath());
        }
    }

    @Nls
    public String getDisplayName() {
        return "Google App Engine";
    }

    @NotNull
    public JComponent createComponent() {
        this.mySdkEditorPanel.add("Center", this.mySdkEditor.getMainComponent());
        JPanel jPanel = this.myMainPanel;
        if (jPanel == null) {
            AppEngineFacetEditor.$$$reportNull$$$0(0);
        }
        return jPanel;
    }

    public boolean isModified() {
        return this.myRunEnhancerOnMakeCheckBox.isSelected() != this.myFacetConfiguration.isRunEnhancerOnMake() || !this.mySdkEditor.getPath().equals(this.myFacetConfiguration.getSdkHomePath()) || !this.getConfiguredFiles().equals(this.myFacetConfiguration.getFilesToEnhance()) || PersistenceApiComboboxUtil.getSelectedApi(this.myPersistenceApiComboBox) != this.myFacetConfiguration.getPersistenceApi();
    }

    private List<String> getConfiguredFiles() {
        ArrayList<String> files = new ArrayList<String>();
        for (int i = 0; i < this.myFilesListModel.getSize(); ++i) {
            files.add((String)this.myFilesListModel.getElementAt(i));
        }
        return files;
    }

    public void apply() {
        this.myFacetConfiguration.setSdkHomePath(this.mySdkEditor.getPath());
        this.myFacetConfiguration.setRunEnhancerOnMake(this.myRunEnhancerOnMakeCheckBox.isSelected());
        this.myFacetConfiguration.setFilesToEnhance(this.getConfiguredFiles());
        this.myFacetConfiguration.setPersistenceApi(PersistenceApiComboboxUtil.getSelectedApi(this.myPersistenceApiComboBox));
    }

    public void reset() {
        this.mySdkEditor.setPath(this.myFacetConfiguration.getSdkHomePath());
        if (this.myContext.isNewFacet() && this.myFacetConfiguration.getSdkHomePath().length() == 0) {
            this.mySdkEditor.setDefaultPath();
        }
        this.myFilesListModel.removeAllElements();
        this.fillFilesList(this.myFacetConfiguration.getFilesToEnhance());
        this.myRunEnhancerOnMakeCheckBox.setSelected(this.myFacetConfiguration.isRunEnhancerOnMake());
        this.myPersistenceApiComboBox.setSelectedItem(this.myFacetConfiguration.getPersistenceApi().getDisplayName());
    }

    private void fillFilesList(List<String> paths) {
        for (String path : paths) {
            this.myFilesListModel.addElement(path);
        }
    }

    public void disposeUIResources() {
    }

    public String getHelpTopic() {
        return "Google_App_Engine_Facet";
    }

    public void onFacetInitialized(@NotNull Facet facet) {
        if (facet == null) {
            AppEngineFacetEditor.$$$reportNull$$$0(1);
        }
        AppEngineWebIntegration.getInstance().setupDevServer(((AppEngineFacet)facet).getSdk());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/appengine/facet/AppEngineFacetEditor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facet";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "createComponent";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/appengine/facet/AppEngineFacetEditor";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "onFacetInitialized";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JComboBox jComboBox;
        JPanel jPanel;
        JPanel jPanel2;
        JCheckBox jCheckBox;
        JPanel jPanel3;
        JPanel jPanel4;
        this.myMainPanel = jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(5, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JLabel jLabel = new JLabel();
        jLabel.setText("Path to Google App Engine SDK installation directory:");
        jPanel4.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel4.add((Component)spacer, new GridConstraints(4, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        this.mySdkEditorPanel = jPanel3 = new JPanel();
        jPanel3.setLayout(new BorderLayout(0, 0));
        jPanel4.add((Component)jPanel3, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null, 2));
        this.myRunEnhancerOnMakeCheckBox = jCheckBox = new JCheckBox();
        jCheckBox.setText("Run Enhancer for the following classes and packages on make:");
        jCheckBox.setMnemonic('R');
        jCheckBox.setDisplayedMnemonicIndex(0);
        jPanel4.add((Component)jCheckBox, new GridConstraints(2, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myFilesToEnhancePanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel4.add((Component)jPanel2, new GridConstraints(3, 0, 1, 1, 0, 3, 3, 3, null, null, null, 1));
        this.myFilesPanel = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        jPanel2.add((Component)jPanel, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel5, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myPersistenceApiComboBox = jComboBox = new JComboBox();
        DefaultComboBoxModel defaultComboBoxModel = new DefaultComboBoxModel();
        jComboBox.setModel(defaultComboBoxModel);
        jPanel5.add(jComboBox, new GridConstraints(0, 1, 1, 1, 8, 0, 2, 0, null, null, null));
        JLabel jLabel2 = new JLabel();
        jLabel2.setText("Persistence:");
        jPanel5.add((Component)jLabel2, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }

    private class FilesListCellRenderer
    extends DefaultListCellRenderer {
        private FilesListCellRenderer() {
            this.setUI((LabelUI)new RightAlignedLabelUI());
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Component rendererComponent = super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            if (value instanceof String) {
                String path = (String)value;
                VirtualFile file = LocalFileSystem.getInstance().findFileByPath(path);
                if (file == null) {
                    this.setForeground((Color)JBColor.RED);
                    this.setIcon(null);
                } else {
                    this.setForeground(AppEngineFacetEditor.this.myFilesList.getForeground());
                    this.setIcon(file.isDirectory() ? PlatformIcons.FOLDER_ICON : VirtualFilePresentation.getIcon((VirtualFile)file));
                }
                this.setText(path);
            }
            return rendererComponent;
        }
    }
}

