/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.appengine.converter;

import com.intellij.conversion.CannotConvertException;
import com.intellij.conversion.ConversionContext;
import com.intellij.conversion.ConversionProcessor;
import com.intellij.conversion.ConverterProvider;
import com.intellij.conversion.ModuleSettings;
import com.intellij.conversion.ProjectConverter;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.List;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AppEngineFacetConverterProvider
extends ConverterProvider {
    public AppEngineFacetConverterProvider() {
        super("google-app-engine-facet");
    }

    @NotNull
    public ProjectConverter createConverter(@NotNull ConversionContext context) {
        if (context == null) {
            AppEngineFacetConverterProvider.$$$reportNull$$$0(0);
        }
        ProjectConverter projectConverter = new ProjectConverter(){

            @Nullable
            public ConversionProcessor<ModuleSettings> createModuleFileConverter() {
                return new GoogleAppEngineFacetConversionProcessor();
            }
        };
        if (projectConverter == null) {
            AppEngineFacetConverterProvider.$$$reportNull$$$0(1);
        }
        return projectConverter;
    }

    @NotNull
    public String getConversionDescription() {
        if ("Google App Engine facets will be decoupled from Web facets" == null) {
            AppEngineFacetConverterProvider.$$$reportNull$$$0(2);
        }
        return "Google App Engine facets will be decoupled from Web facets";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/appengine/converter/AppEngineFacetConverterProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/appengine/converter/AppEngineFacetConverterProvider";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createConverter";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getConversionDescription";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createConverter";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class GoogleAppEngineFacetConversionProcessor
    extends ConversionProcessor<ModuleSettings> {
        private GoogleAppEngineFacetConversionProcessor() {
        }

        public boolean isConversionNeeded(ModuleSettings settings) {
            return !GoogleAppEngineFacetConversionProcessor.getAppEngineFacetTags(settings).isEmpty();
        }

        public void process(ModuleSettings settings) throws CannotConvertException {
            List<Element> facetTags = GoogleAppEngineFacetConversionProcessor.getAppEngineFacetTags(settings);
            for (Element tag : facetTags) {
                tag.detach();
            }
            Element facetTag = (Element)ContainerUtil.getFirstItem(facetTags);
            if (facetTag != null) {
                String facetName = facetTag.getAttributeValue("name");
                Element configuration = facetTag.getChild("configuration");
                settings.addFacetElement("google-app-engine", facetName, configuration.clone());
            }
        }

        @NotNull
        private static List<Element> getAppEngineFacetTags(@NotNull ModuleSettings settings) {
            if (settings == null) {
                GoogleAppEngineFacetConversionProcessor.$$$reportNull$$$0(0);
            }
            ArrayList<Element> appEngineFacetTags = new ArrayList<Element>();
            for (Element webFacetTag : settings.getFacetElements("web")) {
                for (Element childFacetTag : webFacetTag.getChildren("facet")) {
                    if (!"google-app-engine".equals(childFacetTag.getAttributeValue("type"))) continue;
                    appEngineFacetTags.add(childFacetTag);
                }
            }
            ArrayList<Element> arrayList = appEngineFacetTags;
            if (arrayList == null) {
                GoogleAppEngineFacetConversionProcessor.$$$reportNull$$$0(1);
            }
            return arrayList;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "settings";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/appengine/converter/AppEngineFacetConverterProvider$GoogleAppEngineFacetConversionProcessor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/appengine/converter/AppEngineFacetConverterProvider$GoogleAppEngineFacetConversionProcessor";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getAppEngineFacetTags";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getAppEngineFacetTags";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

