/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.module.cloud;

import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.framework.addSupport.FrameworkSupportInModuleConfigurable;
import com.intellij.framework.addSupport.FrameworkSupportInModuleProvider;
import com.intellij.ide.util.frameworkSupport.FrameworkSupportModel;
import com.intellij.ide.util.newProjectWizard.FrameworkSupportOptionsComponent;
import com.intellij.ide.util.newProjectWizard.impl.FrameworkSupportModelBase;
import com.intellij.javaee.facet.JavaeeFrameworkSupportInfoCollector;
import com.intellij.javaee.ui.packaging.ArchiveArtifactTemplate;
import com.intellij.javaee.ui.packaging.JavaeeArtifactTypeBase;
import com.intellij.javaee.web.facet.WebFacetType;
import com.intellij.javaee.web.framework.WebFrameworkSupportProvider;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.IdeaModifiableModelsProvider;
import com.intellij.openapi.roots.ModifiableModelsProvider;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.util.Disposer;
import com.intellij.packaging.artifacts.Artifact;
import com.intellij.packaging.artifacts.ArtifactManager;
import com.intellij.packaging.artifacts.ArtifactPointer;
import com.intellij.packaging.artifacts.ArtifactPointerManager;
import com.intellij.packaging.artifacts.ArtifactTemplate;
import com.intellij.packaging.artifacts.ArtifactType;
import com.intellij.packaging.artifacts.ModifiableArtifactModel;
import com.intellij.packaging.elements.PackagingElementResolvingContext;
import com.intellij.packaging.impl.artifacts.ArtifactUtil;
import com.intellij.packaging.impl.artifacts.DefaultPackagingElementResolvingContext;
import com.intellij.remoteServer.ServerType;
import com.intellij.remoteServer.configuration.RemoteServer;
import com.intellij.remoteServer.configuration.deployment.ArtifactDeploymentSource;
import com.intellij.remoteServer.configuration.deployment.DeploymentConfiguration;
import com.intellij.remoteServer.configuration.deployment.DeploymentSource;
import com.intellij.remoteServer.impl.configuration.deployment.ArtifactDeploymentSourceImpl;
import com.intellij.remoteServer.impl.configuration.deployment.ArtifactDeploymentSourceType;
import com.intellij.remoteServer.impl.configuration.deployment.DeployToServerRunConfiguration;
import com.intellij.remoteServer.impl.module.CloudApplicationConfigurable;
import com.intellij.remoteServer.impl.module.CloudApplicationConfiguration;
import com.intellij.remoteServer.impl.module.CloudModuleBuilder;
import com.intellij.remoteServer.impl.module.CloudModuleBuilderContribution;
import com.intellij.remoteServer.util.CloudRunConfigurationUtil;
import java.awt.Component;
import javax.swing.JPanel;
import org.jetbrains.annotations.Nullable;

public class CloudArtifactModuleBuilderContribution
extends CloudModuleBuilderContribution {
    private static final CloudApplicationConfiguration APP_CONFIG_STUB = new CloudApplicationConfiguration(){};
    private FrameworkSupportInModuleConfigurable myWebFrameworkConfigurable;

    public CloudArtifactModuleBuilderContribution(CloudModuleBuilder moduleBuilder, ServerType<?> cloudType) {
        super(moduleBuilder, cloudType);
    }

    public CloudApplicationConfigurable createApplicationConfigurable(@Nullable Project project, Disposable parentDisposable) {
        WebFrameworkSupportProvider webFrameworkSupportProvider = new WebFrameworkSupportProvider();
        FrameworkSupportModelBase webFrameworkModel = this.getModuleBuilder().getFrameworkSupportModel();
        this.myWebFrameworkConfigurable = webFrameworkSupportProvider.createConfigurable((FrameworkSupportModel)webFrameworkModel);
        final JPanel component = new FrameworkSupportOptionsComponent(webFrameworkModel, webFrameworkModel.getLibrariesContainer(), parentDisposable, (FrameworkSupportInModuleProvider)webFrameworkSupportProvider, this.myWebFrameworkConfigurable).getMainPanel();
        Disposer.register((Disposable)parentDisposable, (Disposable)this.myWebFrameworkConfigurable);
        return new CloudApplicationConfigurable(){

            public Component getComponent() {
                return component;
            }

            public void setAccount(RemoteServer<?> account) {
            }

            public CloudApplicationConfiguration createConfiguration() {
                return APP_CONFIG_STUB;
            }

            public void validate() throws ConfigurationException {
            }
        };
    }

    public void preConfigureModule(Module module, ModifiableRootModel model) {
        this.myWebFrameworkConfigurable.addSupport(module, model, (ModifiableModelsProvider)new IdeaModifiableModelsProvider());
    }

    public void configureModule(Module module) {
        ArtifactType archiveArtifactType;
        CloudModuleBuilder moduleBuilder = this.getModuleBuilder();
        JavaeeFrameworkSupportInfoCollector collector = JavaeeFrameworkSupportInfoCollector.getOrCreateCollector((FrameworkSupportModel)moduleBuilder.getFrameworkSupportModel());
        Artifact explodedArtifact = collector.getArtifact(WebFacetType.getInstance().getExplodedArtifactType());
        if (explodedArtifact == null) {
            return;
        }
        Project project = module.getProject();
        ModifiableArtifactModel artifactModel = ArtifactManager.getInstance((Project)project).createModifiableModel();
        Artifact archiveArtifact = ArtifactUtil.addArtifact((ModifiableArtifactModel)artifactModel, (ArtifactType)(archiveArtifactType = WebFacetType.getInstance().getArchiveArtifactType()), (ArtifactTemplate)new ArchiveArtifactTemplate(explodedArtifact, (PackagingElementResolvingContext)new DefaultPackagingElementResolvingContext(project), (JavaeeArtifactTypeBase)archiveArtifactType));
        if (archiveArtifact == null) {
            return;
        }
        artifactModel.commit();
        ArtifactPointer artifactPointer = ArtifactPointerManager.getInstance((Project)module.getProject()).createPointer(archiveArtifact);
        ArtifactDeploymentSourceImpl deploymentSource = new ArtifactDeploymentSourceImpl(artifactPointer);
        DeploymentConfiguration deploymentConfiguration = this.createDeploymentConfiguration((DeploymentSource)deploymentSource);
        DeployToServerRunConfiguration configuration = CloudRunConfigurationUtil.createRunConfiguration((RemoteServer)moduleBuilder.getAccount(), (Module)module, (DeploymentSource)deploymentSource, (DeploymentConfiguration)deploymentConfiguration);
        ((ArtifactDeploymentSourceType)deploymentSource.getType()).setBuildBeforeRunTask((RunConfiguration)configuration, (ArtifactDeploymentSource)deploymentSource);
    }
}

