/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jpa.highlighting;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.codeInspection.IntentionAndQuickFixAction;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.facet.Facet;
import com.intellij.facet.FacetManager;
import com.intellij.facet.FacetType;
import com.intellij.jam.model.util.JamCommonUtil;
import com.intellij.javaee.JavaeePersistenceDescriptorsConstants;
import com.intellij.javaee.model.xml.persistence.Persistence;
import com.intellij.jpa.JpaMessages;
import com.intellij.jpa.facet.JpaFacet;
import com.intellij.jpa.facet.JpaFacetConfiguration;
import com.intellij.jpa.facet.JpaFacetType;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.descriptors.ConfigFile;
import com.intellij.util.xml.DomFileElement;
import com.intellij.util.xml.highlighting.BasicDomElementsInspection;
import com.intellij.util.xml.highlighting.DomElementAnnotationHolder;
import com.intellij.util.xml.highlighting.DomElementAnnotationsManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JpaDomFacetInspection
extends BasicDomElementsInspection<Persistence> {
    public JpaDomFacetInspection() {
        super(Persistence.class, new Class[0]);
    }

    @NotNull
    public String getGroupDisplayName() {
        String string = JpaMessages.message((String)"group.names.jpa.issues", (Object[])new Object[0]);
        if (string == null) {
            JpaDomFacetInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public String getDisplayName() {
        String string = JpaMessages.message((String)"inspection.javaee.persistence.persistence.xml.facet", (Object[])new Object[0]);
        if (string == null) {
            JpaDomFacetInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NotNull
    @NonNls
    public String getShortName() {
        if ("JpaConfigDomFacetInspection" == null) {
            JpaDomFacetInspection.$$$reportNull$$$0(2);
        }
        return "JpaConfigDomFacetInspection";
    }

    @NotNull
    public HighlightDisplayLevel getDefaultLevel() {
        HighlightDisplayLevel highlightDisplayLevel = HighlightDisplayLevel.WARNING;
        if (highlightDisplayLevel == null) {
            JpaDomFacetInspection.$$$reportNull$$$0(3);
        }
        return highlightDisplayLevel;
    }

    public void checkFileElement(DomFileElement<Persistence> element, DomElementAnnotationHolder holder) {
        Module[] modulesToLookAt;
        Module elementModule = element.getModule();
        VirtualFile virtualFile = element.getFile().getVirtualFile();
        assert (virtualFile != null);
        boolean found = false;
        Project project = element.getManager().getProject();
        Module[] moduleArray = modulesToLookAt = elementModule == null ? ModuleManager.getInstance((Project)project).getModules() : JamCommonUtil.getAllDependentModules((Module)elementModule);
        if (modulesToLookAt.length == 0) {
            return;
        }
        List<JpaFacet> facets = JpaDomFacetInspection.collectFacets(modulesToLookAt);
        for (JpaFacet facet : facets) {
            for (ConfigFile configFile : facet.getDescriptors()) {
                if (JavaeePersistenceDescriptorsConstants.PERSISTENCE_XML_META_DATA != configFile.getMetaData() || !virtualFile.equals(configFile.getVirtualFile())) continue;
                found = true;
            }
        }
        if (facets.isEmpty()) {
            holder.createProblem(element, HighlightSeverity.WARNING, JpaMessages.message((String)"warning.cfg.xml.not.in.any.facet", (Object[])new Object[0]), JpaDomFacetInspection.createAddFacetQuickFix(modulesToLookAt));
        } else if (!found) {
            holder.createProblem(element, HighlightSeverity.WARNING, JpaMessages.message((String)"warning.cfg.xml.not.in.any.facet", (Object[])new Object[0]), new LocalQuickFix[]{new AddToFacetConfigurationFix(modulesToLookAt)});
        }
    }

    private static List<JpaFacet> collectFacets(Module[] modulesToLookAt) {
        return ContainerUtil.concat((Object[])modulesToLookAt, module -> FacetManager.getInstance((Module)module).getFacetsByType(JpaFacet.ID));
    }

    public static LocalQuickFix[] createAddFacetQuickFix(Module[] modules) {
        return new LocalQuickFix[]{new AddFacetFix(modules)};
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/jpa/highlighting/JpaDomFacetInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getGroupDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getShortName";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultLevel";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static class AddFacetFix
    extends AddToFacetConfigurationFix {
        AddFacetFix(Module[] modules) {
            super(modules);
        }

        @Override
        @NotNull
        public String getName() {
            String string = JpaMessages.message((String)"name.fix.create.facet.and.add.to.facet.configuration", (Object[])new Object[0]);
            if (string == null) {
                AddFacetFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jpa/highlighting/JpaDomFacetInspection$AddFacetFix", "getName"));
        }
    }

    private static class AddToFacetConfigurationFix
    extends IntentionAndQuickFixAction {
        private final Module[] myModules;

        AddToFacetConfigurationFix(Module[] modules) {
            this.myModules = modules;
        }

        @NotNull
        public String getName() {
            String string = JpaMessages.message((String)"name.fix.add.to.facet.configuration", (Object[])new Object[0]);
            if (string == null) {
                AddToFacetConfigurationFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @NotNull
        public String getFamilyName() {
            String string = JpaMessages.message((String)"jpa.quickfix.family", (Object[])new Object[0]);
            if (string == null) {
                AddToFacetConfigurationFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        public boolean startInWriteAction() {
            return false;
        }

        public void applyFix(@NotNull Project project, PsiFile file, @Nullable Editor editor) {
            if (project == null) {
                AddToFacetConfigurationFix.$$$reportNull$$$0(2);
            }
            this.doFix(project, file.getVirtualFile(), editor);
        }

        private void doFix(Project project, VirtualFile file, Editor editor) {
            String url = file.getUrl();
            List facets = JpaDomFacetInspection.collectFacets(this.myModules);
            if (this.myModules.length == 1 && (facets.isEmpty() || facets.size() == 1)) {
                this.doAddToFacet(this.myModules[0], facets.isEmpty() ? null : (JpaFacet)facets.get(0), url);
            } else {
                ArrayList items = new ArrayList();
                ContainerUtil.addAll(items, (Object[])this.myModules);
                items.addAll(facets);
                for (JpaFacet facet : facets) {
                    items.remove(facet.getModule());
                }
                Collections.sort(items, (o1, o2) -> Comparing.compare((Comparable)((Object)AddToFacetConfigurationFix.getItemName(o1)), (Comparable)((Object)AddToFacetConfigurationFix.getItemName(o2))));
                JBPopupFactory.getInstance().createPopupChooserBuilder(items).setRenderer((ListCellRenderer)new ColoredListCellRenderer<Object>(){

                    protected void customizeCellRenderer(@NotNull JList list, Object o, int index, boolean selected, boolean hasFocus) {
                        if (list == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        this.setIcon(o instanceof Module ? ModuleType.get((Module)((Module)o)).getIcon() : ((Facet)o).getType().getIcon());
                        this.append(AddToFacetConfigurationFix.getItemName(o));
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/intellij/jpa/highlighting/JpaDomFacetInspection$AddToFacetConfigurationFix$1", "customizeCellRenderer"));
                    }
                }).setTitle(JpaMessages.message((String)"popup.title.choose.module.and.facet", (Object[])new Object[0])).setMovable(true).setItemChosenCallback(o -> {
                    Module module = o instanceof Module ? (Module)o : ((Facet)o).getModule();
                    JpaFacet facet = o instanceof Module ? null : (JpaFacet)o;
                    this.doAddToFacet(module, facet, url);
                }).setNamerForFiltering(o -> AddToFacetConfigurationFix.getItemName(o)).createPopup().showCenteredInCurrentWindow(project);
            }
        }

        private static String getItemName(Object o) {
            return o instanceof Module ? ((Module)o).getName() : ((Facet)o).getModule().getName() + "/" + ((Facet)o).getName();
        }

        private void doAddToFacet(@NotNull Module module, @Nullable JpaFacet facet, String url) {
            if (module == null) {
                AddToFacetConfigurationFix.$$$reportNull$$$0(3);
            }
            WriteCommandAction.writeCommandAction((Project)module.getProject()).withName(this.getName()).run(() -> {
                if (module == null) {
                    AddToFacetConfigurationFix.$$$reportNull$$$0(4);
                }
                JpaFacet chosenFacet = facet != null ? facet : (JpaFacet)FacetManager.getInstance((Module)module).addFacet((FacetType)JpaFacetType.getInstance(), JpaFacetType.getInstance().getDefaultFacetName(), null);
                ((JpaFacetConfiguration)chosenFacet.getConfiguration()).getDescriptorsConfiguration().replaceConfigFile(JavaeePersistenceDescriptorsConstants.PERSISTENCE_XML_META_DATA, url);
            });
            DomElementAnnotationsManager.getInstance((Project)module.getProject()).dropAnnotationsCache();
            DaemonCodeAnalyzer.getInstance((Project)module.getProject()).restart();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/jpa/highlighting/JpaDomFacetInspection$AddToFacetConfigurationFix";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "module";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/jpa/highlighting/JpaDomFacetInspection$AddToFacetConfigurationFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "doAddToFacet";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "lambda$doAddToFacet$3";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

