/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jpa.highlighting;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.database.dataSource.DataSourceUiUtil;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.model.DasDataSource;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.LoaderContext;
import com.intellij.jpa.JpaMessages;
import com.intellij.jpa.ORMReferencesUtil;
import com.intellij.jpa.actions.AssignDataSourcesAction;
import com.intellij.jpa.highlighting.JpaHighlightingMessages;
import com.intellij.jpa.highlighting.JpaInspectionUtil;
import com.intellij.jpa.inspections.AbstractJpaInspection;
import com.intellij.openapi.project.Project;
import com.intellij.persistence.PersistenceHelper;
import com.intellij.persistence.facet.PersistenceFacet;
import com.intellij.persistence.model.PersistenceMappings;
import com.intellij.persistence.roles.PersistenceClassRole;
import com.intellij.persistence.roles.PersistenceClassRoleEnum;
import com.intellij.persistence.util.PersistenceUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.util.Processor;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class JpaDataSourceORMInspection
extends AbstractJpaInspection {
    @NonNls
    public static final String SHORT_NAME = "JpaDataSourceORMInspection";

    @NotNull
    public String getDisplayName() {
        String string = JpaMessages.message((String)"inspection.javaee.persistence.orm.display.name", (Object[])new Object[0]);
        if (string == null) {
            JpaDataSourceORMInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    @NonNls
    public String getShortName() {
        if (SHORT_NAME == null) {
            JpaDataSourceORMInspection.$$$reportNull$$$0(1);
        }
        return SHORT_NAME;
    }

    @Override
    protected void checkClassAllRoles(PsiClass aClass, PersistenceClassRole[] roles, ProblemsHolder holder, boolean isOnTheFly) {
        if (ContainerUtil.find((Object[])roles, role -> role.getType() != PersistenceClassRoleEnum.ENTITY_LISTENER) == null) {
            return;
        }
        Processor processor = t -> {
            JpaInspectionUtil.checkMemberAnnotations((PsiModifierListOwner)t, holder, ORMReferencesUtil.DataSourceRelatedReference.class);
            return true;
        };
        JpaInspectionUtil.checkMemberAnnotations((PsiModifierListOwner)aClass, holder, ORMReferencesUtil.DataSourceRelatedReference.class);
        ContainerUtil.process(Arrays.asList(aClass.getFields()), (Processor)processor);
        ContainerUtil.process(Arrays.asList(aClass.getMethods()), (Processor)processor);
    }

    public static LocalQuickFix[] createUnitDataSourceQuickFixes(PersistenceMappings entityMappings) {
        SmartList quickFixes = new SmartList();
        Collection<Object> dataSources = entityMappings == null ? Collections.emptyList() : PersistenceUtil.getDataSources((PersistenceMappings)entityMappings);
        quickFixes.add((Object)new EditUnitDataSourcesQuickFix());
        for (DbDataSource dbDataSource : dataSources) {
            LocalDataSource localDataSource = DbImplUtil.getMaybeLocalDataSource((DasDataSource)dbDataSource);
            if (localDataSource == null || !DbImplUtil.canConnectTo((LocalDataSource)localDataSource)) continue;
            quickFixes.add((Object)new RefreshDataSourceQuickFix(localDataSource));
        }
        return (LocalQuickFix[])quickFixes.toArray((Object[])LocalQuickFix.EMPTY_ARRAY);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/jpa/highlighting/JpaDataSourceORMInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getShortName";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static class EditUnitDataSourcesQuickFix
    implements LocalQuickFix {
        private EditUnitDataSourcesQuickFix() {
        }

        @NotNull
        public String getName() {
            String string = JpaHighlightingMessages.message("fix.edit.unit.datasource.name", new Object[0]);
            if (string == null) {
                EditUnitDataSourcesQuickFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @NotNull
        public String getFamilyName() {
            String string = JpaHighlightingMessages.message("fix.edit.unit.datasource.family.name", new Object[0]);
            if (string == null) {
                EditUnitDataSourcesQuickFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        public boolean startInWriteAction() {
            return false;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            PersistenceFacet facet;
            if (project == null) {
                EditUnitDataSourcesQuickFix.$$$reportNull$$$0(2);
            }
            if (descriptor == null) {
                EditUnitDataSourcesQuickFix.$$$reportNull$$$0(3);
            }
            if ((facet = (PersistenceFacet)PersistenceHelper.getHelper().getSharedModelBrowser().queryPersistenceFacets(descriptor.getPsiElement()).findFirst()) == null) {
                return;
            }
            AssignDataSourcesAction.showUnitDataSourceMappingDialog(facet);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 2: 
                case 3: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 2: 
                case 3: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/jpa/highlighting/JpaDataSourceORMInspection$EditUnitDataSourcesQuickFix";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/jpa/highlighting/JpaDataSourceORMInspection$EditUnitDataSourcesQuickFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 2: 
                case 3: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class RefreshDataSourceQuickFix
    implements LocalQuickFix {
        private final LocalDataSource myDataSource;

        RefreshDataSourceQuickFix(LocalDataSource dataSource) {
            this.myDataSource = dataSource;
        }

        @NotNull
        public String getName() {
            String string = JpaHighlightingMessages.message("fix.refresh.datasource.name", this.myDataSource.getName());
            if (string == null) {
                RefreshDataSourceQuickFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @NotNull
        public String getFamilyName() {
            String string = JpaHighlightingMessages.message("fix.refresh.datasource.family.name", new Object[0]);
            if (string == null) {
                RefreshDataSourceQuickFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        public boolean startInWriteAction() {
            return false;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            if (project == null) {
                RefreshDataSourceQuickFix.$$$reportNull$$$0(2);
            }
            if (descriptor == null) {
                RefreshDataSourceQuickFix.$$$reportNull$$$0(3);
            }
            DataSourceUiUtil.performManualSyncTask((LoaderContext)LoaderContext.loadAll((Project)project, (LocalDataSource)this.myDataSource));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 2: 
                case 3: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 2: 
                case 3: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/jpa/highlighting/JpaDataSourceORMInspection$RefreshDataSourceQuickFix";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/jpa/highlighting/JpaDataSourceORMInspection$RefreshDataSourceQuickFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 2: 
                case 3: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

