/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jpa.engine;

import com.intellij.database.DataBus;
import com.intellij.database.console.client.ScriptingSessionClient;
import com.intellij.database.datagrid.DataAuditor;
import com.intellij.database.datagrid.DataConsumer;
import com.intellij.database.datagrid.DataRequest;
import com.intellij.database.datagrid.GridDataHookUp;
import com.intellij.database.run.AbstractQueryLanguageConsole;
import com.intellij.database.run.ParametersHolder;
import com.intellij.database.run.ScriptingClientDataConsumer;
import com.intellij.database.run.session.BaseSessionView;
import com.intellij.database.run.session.Session;
import com.intellij.database.run.session.SessionStateWatcher;
import com.intellij.database.run.session.SessionToolWindowHelper;
import com.intellij.database.run.session.VisibleSession;
import com.intellij.database.run.ui.ParametersPanel;
import com.intellij.database.script.ScriptModel;
import com.intellij.execution.console.LanguageConsoleImpl;
import com.intellij.execution.console.LanguageConsoleView;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.execution.ui.RunnerLayoutUi;
import com.intellij.execution.ui.layout.PlaceInGrid;
import com.intellij.ide.DataManager;
import com.intellij.jpa.engine.SessionVisibilityController;
import com.intellij.lang.Language;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManager;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Component;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class JpaConsoleAdapter<T>
extends AbstractQueryLanguageConsole<T>
implements VisibleSession<T, JpaConsoleAdapter<T>, AdaptingView<T>> {
    protected static final String ID_CONSOLE = "Input";
    protected final ScriptingClientDataConsumer myDataConsumer;
    protected final ScriptModel.PStorage myPStorage;
    protected final ParametersPanel myParamPanel;
    private final AdaptingView<T> myView;
    private final SessionStateWatcher myWatcher;
    private final ScriptModel<?> myScriptModel;
    private final ParametersHolder myHolder;

    public JpaConsoleAdapter(@NotNull Project project, @NotNull DataBus.Consuming messageBus, @NotNull T target, @NotNull String title, @NotNull Language language) {
        if (project == null) {
            JpaConsoleAdapter.$$$reportNull$$$0(0);
        }
        if (messageBus == null) {
            JpaConsoleAdapter.$$$reportNull$$$0(1);
        }
        if (target == null) {
            JpaConsoleAdapter.$$$reportNull$$$0(2);
        }
        if (title == null) {
            JpaConsoleAdapter.$$$reportNull$$$0(3);
        }
        if (language == null) {
            JpaConsoleAdapter.$$$reportNull$$$0(4);
        }
        super(project, target, messageBus);
        LanguageConsoleImpl console = new LanguageConsoleImpl(project, title, language);
        this.myScriptModel = this.createScriptModel((LanguageConsoleView)console);
        this.myView = this.createSessionView((LanguageConsoleView)console, this.getMessageBus(), this.myScriptModel);
        Disposer.register((Disposable)this, this.myScriptModel);
        Disposer.register((Disposable)this, this.myView);
        this.myWatcher = new SessionStateWatcher((Session)this);
        this.myDataConsumer = this.getView().getDataConsumer();
        this.myHolder = this.getView().getParametersHolder();
        this.myPStorage = this.myHolder.getPStorage();
        this.myParamPanel = this.myHolder.getParamPanel();
        this.getView().getUi().getContentManager().addDataProvider((DataProvider)this);
    }

    public boolean beforeExecuteQueries(@NotNull ScriptModel<?> scriptModel) {
        if (scriptModel == null) {
            JpaConsoleAdapter.$$$reportNull$$$0(5);
        }
        return this.myHolder.beforeExecuteQueries(scriptModel);
    }

    public boolean isIdle() {
        return this.myWatcher.isIdle();
    }

    @NotNull
    public AdaptingView<T> getView() {
        AdaptingView<T> adaptingView = this.myView;
        if (adaptingView == null) {
            JpaConsoleAdapter.$$$reportNull$$$0(6);
        }
        return adaptingView;
    }

    @NotNull
    private AdaptingView<T> createSessionView(@NotNull LanguageConsoleView languageConsole, @NotNull DataBus.Consuming messageBus, @NotNull ScriptModel<?> scriptModel) {
        if (languageConsole == null) {
            JpaConsoleAdapter.$$$reportNull$$$0(7);
        }
        if (messageBus == null) {
            JpaConsoleAdapter.$$$reportNull$$$0(8);
        }
        if (scriptModel == null) {
            JpaConsoleAdapter.$$$reportNull$$$0(9);
        }
        AdaptingView adaptingView = new AdaptingView(languageConsole.getProject(), this, messageBus, languageConsole, scriptModel);
        if (adaptingView == null) {
            JpaConsoleAdapter.$$$reportNull$$$0(10);
        }
        return adaptingView;
    }

    @NotNull
    public ScriptModel<?> getScriptModel() {
        ScriptModel<?> scriptModel = this.myScriptModel;
        if (scriptModel == null) {
            JpaConsoleAdapter.$$$reportNull$$$0(11);
        }
        return scriptModel;
    }

    @NotNull
    public abstract GridDataHookUp<DataConsumer.Row, DataConsumer.Column> createGridDataHookUp(@NotNull Disposable var1);

    @NotNull
    public abstract String getToolWindowId();

    @NotNull
    public abstract Icon getToolWindowIcon();

    protected abstract void buildConsoleUi(boolean var1);

    @NotNull
    protected abstract ScriptModel<?> createScriptModel(@NotNull LanguageConsoleView var1);

    @NotNull
    protected abstract DataAuditor.ConsoleLogger createHistoryLogger(@NotNull LanguageConsoleView var1);

    @NotNull
    protected AnAction initParameterView() {
        AnAction anAction = this.getView().getParametersHolder().initParameterView();
        if (anAction == null) {
            JpaConsoleAdapter.$$$reportNull$$$0(12);
        }
        return anAction;
    }

    @NotNull
    public RunnerLayoutUi getUi() {
        RunnerLayoutUi runnerLayoutUi = this.getView().getUi();
        if (runnerLayoutUi == null) {
            JpaConsoleAdapter.$$$reportNull$$$0(13);
        }
        return runnerLayoutUi;
    }

    @NotNull
    public static <T extends JpaConsoleAdapter> List<T> getActiveSessions(Project project, String toolwindowId) {
        if (!ApplicationManager.getApplication().isDispatchThread()) {
            List list = Collections.emptyList();
            if (list == null) {
                JpaConsoleAdapter.$$$reportNull$$$0(14);
            }
            return list;
        }
        ToolWindow window = ToolWindowManager.getInstance((Project)project).getToolWindow(toolwindowId);
        if (window == null) {
            List list = Collections.emptyList();
            if (list == null) {
                JpaConsoleAdapter.$$$reportNull$$$0(15);
            }
            return list;
        }
        SmartList result = new SmartList();
        for (Content content : window.getContentManager().getContents()) {
            ContainerUtil.addIfNotNull((Collection)result, (Object)((Object)JpaConsoleAdapter.getSession(content)));
        }
        SmartList smartList = result;
        if (smartList == null) {
            JpaConsoleAdapter.$$$reportNull$$$0(16);
        }
        return smartList;
    }

    @NotNull
    private static JpaConsoleAdapter getSession(@NotNull Content content) {
        if (content == null) {
            JpaConsoleAdapter.$$$reportNull$$$0(17);
        }
        DataContext dataContext = DataManager.getInstance().getDataContext((Component)content.getComponent());
        JpaConsoleAdapter jpaConsoleAdapter = (JpaConsoleAdapter)((Object)ObjectUtils.notNull((Object)dataContext.getData(Session.SESSION_KEY)));
        if (jpaConsoleAdapter == null) {
            JpaConsoleAdapter.$$$reportNull$$$0(18);
        }
        return jpaConsoleAdapter;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 18: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 18: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "messageBus";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "language";
                break;
            }
            case 5: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scriptModel";
                break;
            }
            case 6: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/jpa/engine/JpaConsoleAdapter";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "languageConsole";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/jpa/engine/JpaConsoleAdapter";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getView";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "createSessionView";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getScriptModel";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "initParameterView";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getUi";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getActiveSessions";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getSession";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "beforeExecuteQueries";
                break;
            }
            case 6: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 18: {
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "createSessionView";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getSession";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 18: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static class AdaptingView<T>
    extends BaseSessionView<AdaptingView<T>, JpaConsoleAdapter<T>>
    implements ScriptingSessionClient {
        private final ScriptingClientDataConsumer myDataConsumer;
        private final ParametersHolder myParametersHolder;

        AdaptingView(@NotNull Project project, @NotNull JpaConsoleAdapter<T> console, @NotNull DataBus.Consuming messageBus, @NotNull LanguageConsoleView consoleView, @NotNull ScriptModel<?> scriptModel) {
            if (project == null) {
                AdaptingView.$$$reportNull$$$0(0);
            }
            if (console == null) {
                AdaptingView.$$$reportNull$$$0(1);
            }
            if (messageBus == null) {
                AdaptingView.$$$reportNull$$$0(2);
            }
            if (consoleView == null) {
                AdaptingView.$$$reportNull$$$0(3);
            }
            if (scriptModel == null) {
                AdaptingView.$$$reportNull$$$0(4);
            }
            super(project, messageBus, consoleView, new SessionToolWindowHelper(console.getToolWindowId(), console.getToolWindowIcon()), console);
            this.myDataConsumer = ScriptingClientDataConsumer.install((Project)this.getProject(), (ScriptingSessionClient)this);
            SessionVisibilityController controller = new SessionVisibilityController(console);
            this.myParametersHolder = new ParametersHolder(this.getProject(), scriptModel, consoleView, controller);
            Disposer.register((Disposable)this, (Disposable)this.myParametersHolder);
        }

        @NotNull
        public ParametersHolder getParametersHolder() {
            ParametersHolder parametersHolder = this.myParametersHolder;
            if (parametersHolder == null) {
                AdaptingView.$$$reportNull$$$0(5);
            }
            return parametersHolder;
        }

        @NotNull
        protected ContentManager retrieveContentManager(ToolWindow window) {
            for (VisibleSession session : JpaConsoleAdapter.getActiveSessions(this.getProject(), this.getToolWindowHelper().getToolWindowId())) {
                if (session.getView().getConsoleView().getFile() != this.getConsoleView().getFile()) continue;
                LOG.error("Console already created for " + this.getConsoleView().getFile().getName());
            }
            ContentManager contentManager = super.retrieveContentManager(window);
            if (contentManager == null) {
                AdaptingView.$$$reportNull$$$0(6);
            }
            return contentManager;
        }

        @NotNull
        public GridDataHookUp<DataConsumer.Row, DataConsumer.Column> createGridDataHookUp(@NotNull Disposable parent) {
            if (parent == null) {
                AdaptingView.$$$reportNull$$$0(7);
            }
            GridDataHookUp<DataConsumer.Row, DataConsumer.Column> gridDataHookUp = ((JpaConsoleAdapter)this.getSession()).createGridDataHookUp(parent);
            if (gridDataHookUp == null) {
                AdaptingView.$$$reportNull$$$0(8);
            }
            return gridDataHookUp;
        }

        @Nullable
        public Object getData(@NotNull String dataId) {
            Object result;
            if (dataId == null) {
                AdaptingView.$$$reportNull$$$0(9);
            }
            if ((result = super.getData(dataId)) != null) {
                return result;
            }
            if (CommonDataKeys.VIRTUAL_FILE.is(dataId)) {
                LanguageConsoleView console = this.getConsoleView();
                return console.isConsoleEditorEnabled() ? console.getVirtualFile() : null;
            }
            return null;
        }

        @NotNull
        public ScriptingClientDataConsumer getDataConsumer() {
            ScriptingClientDataConsumer scriptingClientDataConsumer = this.myDataConsumer;
            if (scriptingClientDataConsumer == null) {
                AdaptingView.$$$reportNull$$$0(10);
            }
            return scriptingClientDataConsumer;
        }

        protected void buildConsoleUi(boolean focused) {
            ((JpaConsoleAdapter)this.getSession()).buildConsoleUi(focused);
        }

        @NotNull
        protected DataAuditor.ConsoleLogger createHistoryLogger(@NotNull LanguageConsoleView consoleView) {
            if (consoleView == null) {
                AdaptingView.$$$reportNull$$$0(11);
            }
            DataAuditor.ConsoleLogger consoleLogger = ((JpaConsoleAdapter)this.getSession()).createHistoryLogger(consoleView);
            if (consoleLogger == null) {
                AdaptingView.$$$reportNull$$$0(12);
            }
            return consoleLogger;
        }

        public void addRequestToHistory(@NotNull DataRequest.Context context) {
            Object params;
            if (context == null) {
                AdaptingView.$$$reportNull$$$0(13);
            }
            super.addRequestToHistory(context);
            Object object = params = context.request instanceof DataRequest.QueryRequest ? ((DataRequest.QueryRequest)context.request).params : null;
            if (!(params instanceof Map) || ((Map)params).isEmpty()) {
                return;
            }
            StringBuilder sb = new StringBuilder("(");
            boolean first = true;
            for (Map.Entry e : ((Map)params).entrySet()) {
                if (first) {
                    first = false;
                } else {
                    sb.append(", ");
                }
                sb.append(e.getKey()).append("=").append(e.getValue());
            }
            sb.append(")\n");
            this.getConsoleView().print(sb.toString(), ConsoleViewContentType.NORMAL_OUTPUT);
        }

        @NotNull
        public VirtualFile getVirtualFile() {
            VirtualFile virtualFile = this.getConsoleView().getVirtualFile();
            if (virtualFile == null) {
                AdaptingView.$$$reportNull$$$0(14);
            }
            return virtualFile;
        }

        @NotNull
        public PlaceInGrid getResultsPlaceInView() {
            PlaceInGrid placeInGrid = PlaceInGrid.bottom;
            if (placeInGrid == null) {
                AdaptingView.$$$reportNull$$$0(15);
            }
            return placeInGrid;
        }

        @NotNull
        public DataBus.Consuming getMessageBus() {
            DataBus.Consuming consuming = ((JpaConsoleAdapter)this.getSession()).getMessageBus();
            if (consuming == null) {
                AdaptingView.$$$reportNull$$$0(16);
            }
            return consuming;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 5: 
                case 6: 
                case 8: 
                case 10: 
                case 12: 
                case 14: 
                case 15: 
                case 16: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 5: 
                case 6: 
                case 8: 
                case 10: 
                case 12: 
                case 14: 
                case 15: 
                case 16: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "console";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "messageBus";
                    break;
                }
                case 3: 
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "consoleView";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "scriptModel";
                    break;
                }
                case 5: 
                case 6: 
                case 8: 
                case 10: 
                case 12: 
                case 14: 
                case 15: 
                case 16: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/jpa/engine/JpaConsoleAdapter$AdaptingView";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parent";
                    break;
                }
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dataId";
                    break;
                }
                case 13: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/jpa/engine/JpaConsoleAdapter$AdaptingView";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getParametersHolder";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "retrieveContentManager";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createGridDataHookUp";
                    break;
                }
                case 10: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDataConsumer";
                    break;
                }
                case 12: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createHistoryLogger";
                    break;
                }
                case 14: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getVirtualFile";
                    break;
                }
                case 15: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getResultsPlaceInView";
                    break;
                }
                case 16: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getMessageBus";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 5: 
                case 6: 
                case 8: 
                case 10: 
                case 12: 
                case 14: 
                case 15: 
                case 16: {
                    break;
                }
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "createGridDataHookUp";
                    break;
                }
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "getData";
                    break;
                }
                case 11: {
                    objectArray = objectArray;
                    objectArray[2] = "createHistoryLogger";
                    break;
                }
                case 13: {
                    objectArray = objectArray;
                    objectArray[2] = "addRequestToHistory";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 5: 
                case 6: 
                case 8: 
                case 10: 
                case 12: 
                case 14: 
                case 15: 
                case 16: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

