/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.ui.packaging;

import com.intellij.javaee.ui.packaging.JavaeeArtifactTypeBase;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.packaging.artifacts.Artifact;
import com.intellij.packaging.artifacts.ArtifactPointer;
import com.intellij.packaging.artifacts.ArtifactPointerManager;
import com.intellij.packaging.artifacts.ArtifactTemplate;
import com.intellij.packaging.artifacts.ArtifactType;
import com.intellij.packaging.elements.CompositePackagingElement;
import com.intellij.packaging.elements.PackagingElementFactory;
import com.intellij.packaging.elements.PackagingElementResolvingContext;

public class ArchiveArtifactTemplate
extends ArtifactTemplate {
    private final Artifact myArtifact;
    private final PackagingElementResolvingContext myContext;
    private final JavaeeArtifactTypeBase myArchiveArtifactType;

    public ArchiveArtifactTemplate(Artifact artifact, PackagingElementResolvingContext context, JavaeeArtifactTypeBase archiveArtifactType) {
        this.myArtifact = artifact;
        this.myContext = context;
        this.myArchiveArtifactType = archiveArtifactType;
    }

    public String getPresentableName() {
        return "For '" + this.myArtifact.getName() + "'";
    }

    public ArtifactTemplate.NewArtifactConfiguration createArtifact() {
        String explodedName = this.myArtifact.getName();
        String archiveName = StringUtil.trimEnd((String)explodedName, (String)" exploded");
        if (archiveName.equals(explodedName)) {
            archiveName = archiveName + " archive";
        }
        CompositePackagingElement element = this.myArchiveArtifactType.createRootElement(archiveName);
        ArtifactPointer pointer = ArtifactPointerManager.getInstance((Project)this.myContext.getProject()).createPointer(this.myArtifact, this.myContext.getArtifactModel());
        element.addOrFindChild(PackagingElementFactory.getInstance().createArtifactElement(pointer, this.myContext.getProject()));
        return new ArtifactTemplate.NewArtifactConfiguration(element, archiveName, (ArtifactType)this.myArchiveArtifactType);
    }
}

