/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.ui.forms.generator;

import com.intellij.javaee.ui.forms.generator.ComponentFactory;
import com.intellij.javaee.ui.forms.generator.GenerateInfo;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiManager;
import com.intellij.psi.XmlElementVisitor;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomUtil;
import com.intellij.util.xml.reflect.AbstractDomChildrenDescription;
import com.intellij.util.xml.reflect.DomCollectionChildDescription;
import com.intellij.util.xml.reflect.DomFixedChildDescription;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public class FormGenerator {
    private static final String myPkg = "com.intellij.javaee.module.view.ejb.references";

    public static void generateForm(DomElement domElement) throws Exception {
        PsiDirectory directory;
        GenerateInfo generateInfo = FormGenerator.getGenerateInfo(domElement);
        Project project = domElement.getManager().getProject();
        PsiManager psiManager = PsiManager.getInstance((Project)project);
        VirtualFile fileByPath = LocalFileSystem.getInstance().findFileByPath("c:/home/idea/ejb/src/" + myPkg.replace('.', '/'));
        PsiDirectory psiDirectory = directory = fileByPath == null ? null : psiManager.findDirectory(fileByPath);
        if (directory == null) {
            return;
        }
        PsiFile javaFile = PsiFileFactory.getInstance((Project)project).createFileFromText(generateInfo.getComponentClassName() + "" + StdFileTypes.JAVA.getDefaultExtension(), FormGenerator.getComponentClassContent(generateInfo));
        PsiFile formFile = PsiFileFactory.getInstance((Project)project).createFileFromText(generateInfo.getFormFileName() + "" + StdFileTypes.GUI_DESIGNER_FORM.getDefaultExtension(), FormGenerator.getFormContent(project, generateInfo));
        WriteCommandAction.writeCommandAction((Project)project).run(() -> {
            PsiFile oldFile = directory.findFile(javaFile.getName());
            PsiFile oldFormFile = directory.findFile(formFile.getName());
            if (oldFile != null) {
                oldFile.delete();
            }
            if (oldFormFile != null) {
                oldFormFile.delete();
            }
            directory.add((PsiElement)javaFile);
            directory.add((PsiElement)formFile);
        });
    }

    private static String getFormContent(Project project, GenerateInfo generateInfo) throws Exception {
        XmlTag[] subTags;
        String templateContent = FormGenerator.getTemplateContent(myPkg + generateInfo.getComponentClassName(), generateInfo);
        XmlFile xmlFile = (XmlFile)PsiFileFactory.getInstance((Project)project).createFileFromText("foo.xml", templateContent);
        XmlTag gridTag = FormGenerator.getPropertiesGridTag(xmlFile.getDocument().getRootTag());
        if (gridTag != null && (subTags = gridTag.findSubTags("children")).length > 0) {
            FormGenerator.createProperties(subTags[0], generateInfo);
        }
        return xmlFile.getText();
    }

    private static void createProperties(XmlTag subTag, GenerateInfo generateInfo) throws Exception {
        ComponentFactory factory = new ComponentFactory();
        Map<String, Pair<Class, String>> name2Class = generateInfo.getName2Class();
        int rowId = 0;
        for (Map.Entry<String, Pair<Class, String>> entry : name2Class.entrySet()) {
            if (!((Class)entry.getValue().getFirst()).isAssignableFrom(Collection.class)) {
                XmlTag labelXml = factory.createLabelComponent(subTag.getProject(), entry.getKey(), rowId);
                subTag.add((PsiElement)labelXml);
            }
            XmlTag componentXml = factory.createComponent(subTag.getProject(), (Class)entry.getValue().getFirst(), entry.getKey(), rowId);
            subTag.add((PsiElement)componentXml);
            ++rowId;
        }
    }

    private static XmlTag getPropertiesGridTag(XmlTag rootTag) throws Exception {
        final XmlTag[] result = new XmlTag[]{null};
        rootTag.accept((PsiElementVisitor)new XmlElementVisitor(){

            public void visitXmlTag(XmlTag tag) {
                if ("ccccc".equals(tag.getAttributeValue("id"))) {
                    result[0] = tag;
                } else {
                    tag.acceptChildren((PsiElementVisitor)this);
                }
            }
        });
        return result[0];
    }

    private static String getTemplateContent(String fullQualifiedClassName, GenerateInfo generateInfo) {
        String s = ComponentFactory.getTemplateContent("templates/FormTemplate.xml");
        s = StringUtil.replace((String)s, (String)"$CLASS$", (String)fullQualifiedClassName);
        s = StringUtil.replace((String)s, (String)"$ROW_COUNT$", (String)String.valueOf(generateInfo.getName2Class().size()));
        return s;
    }

    private static String getComponentClassContent(GenerateInfo generateInfo) {
        String pckg = "package com.intellij.javaee.module.view.ejb.references;\n\n";
        String imports = "import com.intellij.util.xml.ui.BasicDomElementComponent;\nimport com.intellij.util.xml.DomElement;\nimport javax.swing.*;\n\n";
        String classDeclaration = "public class " + generateInfo.getComponentClassName() + " extends BasicDomElementComponent {\n\n";
        String constructor = "  public " + generateInfo.getComponentClassName() + "(final DomElement domElement) {\n    super(domElement);\n\n    bindProperties();\n  }\n\n";
        String body = "  public JComponent getComponent() {\n    return myRootPane;\n  }\n}";
        StringBuilder content = new StringBuilder();
        content.append(pckg);
        content.append(imports);
        content.append(classDeclaration);
        content.append("  private JPanel myRootPane;\n");
        content.append("  private JPanel myPropertiesPane;\n");
        for (Map.Entry<String, Pair<Class, String>> entry : generateInfo.getName2Class().entrySet()) {
            content.append("  private ");
            content.append((String)entry.getValue().getSecond());
            content.append(" my" + entry.getKey().replaceAll(" ", "") + ";\n");
        }
        content.append("\n");
        content.append(constructor);
        content.append("\n");
        content.append(body);
        return content.toString();
    }

    private static GenerateInfo getGenerateInfo(DomElement domElement) {
        GenerateInfo generateInfo = new GenerateInfo();
        generateInfo.setName(domElement.getPresentation().getTypeName().replaceAll(" ", ""));
        for (AbstractDomChildrenDescription description : domElement.getGenericInfo().getChildrenDescriptions()) {
            if (description instanceof DomFixedChildDescription && DomUtil.isGenericValueType((Type)description.getType())) {
                List values = description.getValues(domElement);
                Class clazz = DomUtil.getGenericValueParameter((Type)description.getType());
                String commonPresentableName = ((DomFixedChildDescription)description).getCommonPresentableName(domElement);
                if (values.size() == 1) {
                    generateInfo.putControlInfo(commonPresentableName, clazz);
                    continue;
                }
                for (int i = 0; i < values.size(); ++i) {
                    generateInfo.putControlInfo(commonPresentableName + i, clazz);
                }
                continue;
            }
            if (!(description instanceof DomCollectionChildDescription)) continue;
            generateInfo.putControlInfo(((DomCollectionChildDescription)description).getCommonPresentableName(domElement), Collection.class);
        }
        return generateInfo;
    }
}

