/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.toolwindow.tree.nodes;

import com.intellij.ide.projectView.PresentationData;
import com.intellij.javaee.toolwindow.tree.nodes.PsiMemberSimpleNode;
import com.intellij.openapi.module.Module;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMember;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.treeStructure.SimpleNode;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AnnotatedMembersNode<T extends PsiMember>
extends PsiMemberSimpleNode<T> {
    private final Module myModule;
    protected PsiMember myMember;

    public AnnotatedMembersNode(@NotNull Module module, @NotNull T member, SimpleNode parent) {
        if (module == null) {
            AnnotatedMembersNode.$$$reportNull$$$0(0);
        }
        if (member == null) {
            AnnotatedMembersNode.$$$reportNull$$$0(1);
        }
        super(parent, member);
        this.myModule = module;
        this.myMember = member;
    }

    protected void update(@NotNull PresentationData presentation) {
        if (presentation == null) {
            AnnotatedMembersNode.$$$reportNull$$$0(2);
        }
        super.update(presentation);
        if (!this.myMember.isValid()) {
            return;
        }
        PsiClass psiClass = this.myMember.getContainingClass();
        presentation.clear();
        presentation.setTooltip(psiClass != null ? psiClass.getQualifiedName() : null);
        presentation.setIcon(this.myMember.getIcon(2));
        presentation.addText(this.getMemberName(), this.getPlainAttributes());
        String qualifiedName = this.getQualifiedName();
        if (qualifiedName != null) {
            presentation.addText(" (" + qualifiedName + ")", SimpleTextAttributes.GRAY_ITALIC_ATTRIBUTES);
        }
    }

    @Nullable
    protected String getQualifiedName() {
        PsiClass psiClass = this.myMember.getContainingClass();
        if (psiClass != null && !this.myMember.equals(psiClass)) {
            return psiClass.getName();
        }
        return null;
    }

    @Nullable
    protected String getMemberName() {
        return this.myMember.getName();
    }

    @NotNull
    public SimpleNode[] getChildren() {
        SimpleNode[] simpleNodeArray = new SimpleNode[]{};
        if (simpleNodeArray == null) {
            AnnotatedMembersNode.$$$reportNull$$$0(3);
        }
        return simpleNodeArray;
    }

    @NotNull
    public Object[] getEqualityObjects() {
        Object[] objectArray = new Object[]{this.myMember};
        if (objectArray == null) {
            AnnotatedMembersNode.$$$reportNull$$$0(4);
        }
        return objectArray;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "member";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presentation";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javaee/toolwindow/tree/nodes/AnnotatedMembersNode";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javaee/toolwindow/tree/nodes/AnnotatedMembersNode";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildren";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getEqualityObjects";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 3: 
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

