/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.run.execution.update;

import com.intellij.openapi.compiler.CompileScope;
import com.intellij.openapi.compiler.ExportableUserDataHolderBase;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtil;
import java.util.ArrayList;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FilteredByFileTypeCompileScope
extends ExportableUserDataHolderBase
implements CompileScope {
    private final CompileScope myDelegate;
    private final FileType[] myExcludedFileTypes;
    private final FileTypeManager myFileTypeManager;

    public FilteredByFileTypeCompileScope(CompileScope delegate, FileType ... excludedFileTypes) {
        this.myDelegate = delegate;
        this.myExcludedFileTypes = excludedFileTypes;
        this.myFileTypeManager = FileTypeManager.getInstance();
    }

    @NotNull
    public VirtualFile[] getFiles(@Nullable FileType fileType, boolean inSourceOnly) {
        VirtualFile[] files = this.myDelegate.getFiles(fileType, inSourceOnly);
        ArrayList<VirtualFile> filtered = new ArrayList<VirtualFile>();
        for (VirtualFile file : files) {
            if (ArrayUtil.contains((Object)file.getFileType(), (Object[])this.myExcludedFileTypes)) continue;
            filtered.add(file);
        }
        VirtualFile[] virtualFileArray = VfsUtil.toVirtualFileArray(filtered);
        if (virtualFileArray == null) {
            FilteredByFileTypeCompileScope.$$$reportNull$$$0(0);
        }
        return virtualFileArray;
    }

    public boolean belongs(String url) {
        String name = url.substring(url.lastIndexOf(47) + 1);
        return !ArrayUtil.contains((Object)this.myFileTypeManager.getFileTypeByFileName(name), (Object[])this.myExcludedFileTypes) && this.myDelegate.belongs(url);
    }

    @NotNull
    public Module[] getAffectedModules() {
        Module[] moduleArray = this.myDelegate.getAffectedModules();
        if (moduleArray == null) {
            FilteredByFileTypeCompileScope.$$$reportNull$$$0(1);
        }
        return moduleArray;
    }

    @NotNull
    public Collection<String> getAffectedUnloadedModules() {
        Collection collection = this.myDelegate.getAffectedUnloadedModules();
        if (collection == null) {
            FilteredByFileTypeCompileScope.$$$reportNull$$$0(2);
        }
        return collection;
    }

    public <T> T getUserData(@NotNull Key<T> key) {
        Object data;
        if (key == null) {
            FilteredByFileTypeCompileScope.$$$reportNull$$$0(3);
        }
        if ((data = this.myDelegate.getUserData(key)) != null) {
            return (T)data;
        }
        return (T)super.getUserData(key);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 3: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 3: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javaee/run/execution/update/FilteredByFileTypeCompileScope";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFiles";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getAffectedModules";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getAffectedUnloadedModules";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javaee/run/execution/update/FilteredByFileTypeCompileScope";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getUserData";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

