/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.process;

import com.intellij.javaee.process.JavaeeProcessRequest;
import com.intellij.javaee.process.JavaeeProcessResponse;
import com.intellij.javaee.process.JavaeeProcessResponseToListener;
import com.intellij.javaee.process.JavaeeProcessResponseToRequest;
import com.intellij.javaee.process.common.DocumentReader;
import com.intellij.javaee.process.common.InputReader;
import com.intellij.javaee.process.common.JavaeeProcessUtilException;
import com.intellij.javaee.process.common.OutputWriter;
import com.intellij.javaee.util.ILogger;
import com.intellij.javaee.util.LoggerWrapper;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.io.socketConnection.RequestResponseExternalizerFactory;
import com.intellij.util.io.socketConnection.RequestWriter;
import com.intellij.util.io.socketConnection.ResponseReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.jetbrains.annotations.NotNull;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;

public class JavaeeProcessExternalizerFactory
extends RequestResponseExternalizerFactory<JavaeeProcessRequest, JavaeeProcessResponse> {
    private static final Logger LOG = Logger.getInstance(JavaeeProcessExternalizerFactory.class);
    private static final ILogger LOGGER = new LoggerWrapper(LOG);

    @NotNull
    public RequestWriter<JavaeeProcessRequest> createRequestWriter(@NotNull OutputStream output) throws IOException {
        if (output == null) {
            JavaeeProcessExternalizerFactory.$$$reportNull$$$0(0);
        }
        final OutputWriter outputWriter = new OutputWriter(output);
        RequestWriter<JavaeeProcessRequest> requestWriter = new RequestWriter<JavaeeProcessRequest>(){

            public void writeRequest(JavaeeProcessRequest request) throws IOException {
                try {
                    Document document = OutputWriter.createDocument();
                    request.save(document);
                    outputWriter.putDocument(document);
                }
                catch (JavaeeProcessUtilException e) {
                    throw new IOException(e);
                }
            }
        };
        if (requestWriter == null) {
            JavaeeProcessExternalizerFactory.$$$reportNull$$$0(1);
        }
        return requestWriter;
    }

    @NotNull
    public ResponseReader<JavaeeProcessResponse> createResponseReader(@NotNull InputStream input) throws IOException {
        if (input == null) {
            JavaeeProcessExternalizerFactory.$$$reportNull$$$0(2);
        }
        final InputReader inputReader = new InputReader(input);
        ResponseReader<JavaeeProcessResponse> responseReader = new ResponseReader<JavaeeProcessResponse>(){

            public JavaeeProcessResponse readResponse() throws IOException, InterruptedException {
                InputSource inputSource;
                while ((inputSource = inputReader.getNextSource()) != null) {
                    try {
                        DocumentReader documentReader = new DocumentReader(inputSource, "response");
                        String cause = documentReader.getTopElement("cause");
                        if ("request".equals(cause)) {
                            return new JavaeeProcessResponseToRequest(documentReader);
                        }
                        if ("listener".equals(cause)) {
                            return new JavaeeProcessResponseToListener(documentReader);
                        }
                        LOG.error("Unknown response cause: " + cause);
                        continue;
                    }
                    catch (JavaeeProcessUtilException e) {
                        LOGGER.errorEx(e);
                        continue;
                    }
                    break;
                }
                return null;
            }
        };
        if (responseReader == null) {
            JavaeeProcessExternalizerFactory.$$$reportNull$$$0(3);
        }
        return responseReader;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "output";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javaee/process/JavaeeProcessExternalizerFactory";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "input";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javaee/process/JavaeeProcessExternalizerFactory";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createRequestWriter";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createResponseReader";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createRequestWriter";
                break;
            }
            case 1: 
            case 3: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createResponseReader";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

