/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.module.view.ejb.nodes;

import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.jam.model.common.CommonModelElement;
import com.intellij.jam.view.tree.JamTreeParameters;
import com.intellij.javaee.ejb.EjbUtil;
import com.intellij.javaee.ejb.OldEjbRolesUtil;
import com.intellij.javaee.ejb.role.EjbMethodRole;
import com.intellij.javaee.ejb.role.EjbMethodRoleEnum;
import com.intellij.javaee.model.common.ejb.CmpField;
import com.intellij.javaee.model.common.ejb.EntityBean;
import com.intellij.javaee.module.view.ejb.nodes.EjbFieldAccessorNodeDescriptor;
import com.intellij.javaee.module.view.nodes.JavaeeNodeDescriptor;
import com.intellij.javaee.module.view.nodes.JavaeeObjectDescriptor;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiFormatUtil;
import com.intellij.util.JavaeeIcons;
import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class CmpFieldNodeDescriptor
extends JavaeeObjectDescriptor<CmpField> {
    private final CmpField myField;

    public CmpFieldNodeDescriptor(CmpField field, JavaeeNodeDescriptor parentDescriptor, Object parameters) {
        super((CommonModelElement)field, (NodeDescriptor)parentDescriptor, parameters);
        this.myField = field;
    }

    @NotNull
    public JavaeeNodeDescriptor[] getChildren() {
        ArrayList<EjbFieldAccessorNodeDescriptor> result = new ArrayList<EjbFieldAccessorNodeDescriptor>();
        if (((JamTreeParameters)this.getParameters()).showMembers()) {
            EntityBean ejb = this.myField.getEntityBean();
            PsiMethod[] fieldAccessors = EjbUtil.getFieldAccessors(ejb, (String)this.myField.getFieldName().getValue(), EjbUtil.findType(this.myField));
            ArrayList<PsiMethod> accessors = new ArrayList<PsiMethod>(Arrays.asList(fieldAccessors));
            for (int i = accessors.size() - 1; i >= 0; --i) {
                PsiMethod method = (PsiMethod)accessors.get(i);
                EjbMethodRole methodRole = OldEjbRolesUtil.getEjbRole(method);
                if (!method.isValid() || methodRole == null) {
                    accessors.remove(i);
                    continue;
                }
                if (methodRole.getType() == EjbMethodRoleEnum.EJB_METHOD_ROLE_CMP_GETTER_DECL || methodRole.getType() == EjbMethodRoleEnum.EJB_METHOD_ROLE_CMP_SETTER_DECL || methodRole.getType() == EjbMethodRoleEnum.EJB_METHOD_ROLE_CMP_GETTER_IMPL || methodRole.getType() == EjbMethodRoleEnum.EJB_METHOD_ROLE_CMP_SETTER_IMPL) continue;
                accessors.remove(i);
            }
            for (PsiMethod method : accessors) {
                result.add(new EjbFieldAccessorNodeDescriptor(method, (JavaeeNodeDescriptor)this, this.getParameters()));
            }
        }
        JavaeeNodeDescriptor[] javaeeNodeDescriptorArray = result.toArray(JavaeeNodeDescriptor.EMPTY_ARRAY);
        if (javaeeNodeDescriptorArray == null) {
            CmpFieldNodeDescriptor.$$$reportNull$$$0(0);
        }
        return javaeeNodeDescriptorArray;
    }

    public int getWeight() {
        return 10;
    }

    public String getNewNodeText() {
        PsiType type = EjbUtil.findType(this.myField);
        int options = 7;
        String fieldName = (String)this.myField.getFieldName().getValue();
        if (fieldName == null) {
            fieldName = "";
        }
        return fieldName + (type == null ? "" : ":" + PsiFormatUtil.formatType((PsiType)type, (int)options, (PsiSubstitutor)PsiSubstitutor.EMPTY));
    }

    public Icon getNewIcon() {
        return EjbUtil.isPK(this.myField) ? JavaeeIcons.EJB_FIELD_PK : JavaeeIcons.EJB_CMP_FIELD_ICON;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javaee/module/view/ejb/nodes/CmpFieldNodeDescriptor", "getChildren"));
    }
}

