/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.module.view;

import com.intellij.facet.Facet;
import com.intellij.facet.FacetTypeId;
import com.intellij.javaee.facet.JavaeeFacet;
import com.intellij.javaee.facet.JavaeeFacetUtil;
import com.intellij.javaee.model.xml.JavaeeDomModelElement;
import com.intellij.javaee.module.view.common.editor.FacetAsVirtualFile;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Factory;
import com.intellij.openapi.util.NullableFactory;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.xml.XmlFile;
import com.intellij.util.ObjectUtils;
import com.intellij.util.xml.DomFileElement;
import com.intellij.util.xml.DomManager;
import com.intellij.util.xml.ui.PerspectiveFileEditor;
import com.intellij.util.xml.ui.PerspectiveFileEditorProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractJavaeeFileEditorProvider<T extends JavaeeDomModelElement, F extends JavaeeFacet>
extends PerspectiveFileEditorProvider {
    private final Class<T> myClass;
    private final FacetTypeId<F> myFacetTypeId;

    protected AbstractJavaeeFileEditorProvider(Class<T> aClass, FacetTypeId<F> facetType) {
        this.myClass = aClass;
        this.myFacetTypeId = facetType;
    }

    @Nullable
    protected abstract T getEditedElement(@NotNull F var1, VirtualFile var2);

    @Nullable
    private T getEditedElement(@NotNull Project project, @NotNull VirtualFile file) {
        Facet facet;
        if (project == null) {
            AbstractJavaeeFileEditorProvider.$$$reportNull$$$0(0);
        }
        if (file == null) {
            AbstractJavaeeFileEditorProvider.$$$reportNull$$$0(1);
        }
        if (!file.isValid() || project.isDisposed()) {
            return null;
        }
        if (file instanceof FacetAsVirtualFile && (facet = ((FacetAsVirtualFile)file).findFacet()) != null && facet.getTypeId().equals(this.myFacetTypeId)) {
            return this.getEditedElement((JavaeeFacet)facet, file);
        }
        facet = JavaeeFacetUtil.getInstance().getJavaeeFacet(file, this.myFacetTypeId, project);
        if (facet == null) {
            return null;
        }
        PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(file);
        if (psiFile instanceof XmlFile) {
            XmlFile xmlFile = (XmlFile)psiFile;
            DomFileElement fileElement = DomManager.getDomManager((Project)project).getFileElement(xmlFile, this.myClass);
            if (fileElement != null) {
                return (T)((JavaeeDomModelElement)fileElement.getRootElement());
            }
        }
        return null;
    }

    public boolean accept(@NotNull Project project, @NotNull VirtualFile file) {
        if (project == null) {
            AbstractJavaeeFileEditorProvider.$$$reportNull$$$0(2);
        }
        if (file == null) {
            AbstractJavaeeFileEditorProvider.$$$reportNull$$$0(3);
        }
        return this.getEditedElement(project, file) != null;
    }

    @NotNull
    protected abstract PerspectiveFileEditor createEditor(@NotNull T var1, @NotNull F var2);

    @NotNull
    public PerspectiveFileEditor createEditor(@NotNull Project project, @NotNull VirtualFile file) {
        if (project == null) {
            AbstractJavaeeFileEditorProvider.$$$reportNull$$$0(4);
        }
        if (file == null) {
            AbstractJavaeeFileEditorProvider.$$$reportNull$$$0(5);
        }
        PerspectiveFileEditor perspectiveFileEditor = this.createEditor((JavaeeDomModelElement)DomManager.getDomManager((Project)project).createStableValue((Factory)((NullableFactory)() -> {
            if (project == null) {
                AbstractJavaeeFileEditorProvider.$$$reportNull$$$0(9);
            }
            if (file == null) {
                AbstractJavaeeFileEditorProvider.$$$reportNull$$$0(10);
            }
            return this.getEditedElement(project, file);
        })), this.getFacet(project, file));
        if (perspectiveFileEditor == null) {
            AbstractJavaeeFileEditorProvider.$$$reportNull$$$0(6);
        }
        return perspectiveFileEditor;
    }

    @NotNull
    private F getFacet(Project project, VirtualFile file) {
        if (file instanceof FacetAsVirtualFile) {
            JavaeeFacet javaeeFacet = (JavaeeFacet)ObjectUtils.assertNotNull((Object)((FacetAsVirtualFile)file).findFacet());
            if (javaeeFacet == null) {
                AbstractJavaeeFileEditorProvider.$$$reportNull$$$0(7);
            }
            return (F)javaeeFacet;
        }
        JavaeeFacet javaeeFacet = (JavaeeFacet)ObjectUtils.assertNotNull((Object)JavaeeFacetUtil.getInstance().getJavaeeFacet(file, this.myFacetTypeId, project));
        if (javaeeFacet == null) {
            AbstractJavaeeFileEditorProvider.$$$reportNull$$$0(8);
        }
        return (F)javaeeFacet;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javaee/module/view/AbstractJavaeeFileEditorProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javaee/module/view/AbstractJavaeeFileEditorProvider";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createEditor";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getFacet";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getEditedElement";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createEditor";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "lambda$createEditor$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

