/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.model.annotations.ejb;

import com.intellij.jam.JamService;
import com.intellij.javaee.ejb.EjbUtil;
import com.intellij.javaee.ejb.NewEjbRoleHolder;
import com.intellij.javaee.ejb.role.EjbClassRole;
import com.intellij.javaee.ejb.role.EjbClassRoleEnum;
import com.intellij.javaee.model.annotations.ejb.ApplicationExceptionImpl;
import com.intellij.javaee.model.annotations.ejb.EjbMethodImpl;
import com.intellij.javaee.model.annotations.ejb.EjbReferenceImpl;
import com.intellij.javaee.model.annotations.ejb.EjbRootElementImpl;
import com.intellij.javaee.model.annotations.ejb.EntityBeanImpl;
import com.intellij.javaee.model.annotations.ejb.InterceptorImpl;
import com.intellij.javaee.model.annotations.ejb.InterceptorMethodImpl;
import com.intellij.javaee.model.annotations.ejb.MessageDrivenBeanImpl;
import com.intellij.javaee.model.annotations.ejb.ResourceImpl;
import com.intellij.javaee.model.annotations.ejb.ServiceRefImpl;
import com.intellij.javaee.model.annotations.ejb.SessionBeanImpl;
import com.intellij.javaee.model.common.ejb.EnterpriseBean;
import com.intellij.javaee.model.common.ejb.EntityBean;
import com.intellij.javaee.model.common.ejb.MessageDrivenBean;
import com.intellij.javaee.model.common.ejb.SessionBean;
import com.intellij.javaee.model.enums.SessionType;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PatternCondition;
import com.intellij.patterns.PsiAnnotationPattern;
import com.intellij.patterns.PsiClassPattern;
import com.intellij.patterns.PsiJavaPatterns;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.semantic.SemContributor;
import com.intellij.semantic.SemKey;
import com.intellij.semantic.SemRegistrar;
import com.intellij.util.ConstantFunction;
import com.intellij.util.NullableFunction;
import com.intellij.util.ProcessingContext;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.GenericValue;
import gnu.trove.THashSet;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public class EjbJamContributor
extends SemContributor {
    public void registerSemProviders(SemRegistrar registrar) {
        ApplicationExceptionImpl.APPLICATION_EXCEPTION_META.register(registrar, (ElementPattern)PsiJavaPatterns.psiClass().withAnnotation("javax.ejb.ApplicationException"));
        SessionBeanImpl.STATEFUL_META.register(registrar, PsiJavaPatterns.or((ElementPattern[])new ElementPattern[]{PsiJavaPatterns.psiClass().withAnnotation("javax.ejb.Stateful"), EjbJamContributor.createEjbClassPattern(SessionBean.class, SessionType.STATEFUL)}));
        SessionBeanImpl.STATELESS_META.register(registrar, PsiJavaPatterns.or((ElementPattern[])new ElementPattern[]{PsiJavaPatterns.psiClass().withAnnotation("javax.ejb.Stateless"), EjbJamContributor.createEjbClassPattern(SessionBean.class, SessionType.STATELESS)}));
        SessionBeanImpl.SINGLETON_META.register(registrar, PsiJavaPatterns.or((ElementPattern[])new ElementPattern[]{PsiJavaPatterns.psiClass().withAnnotation("javax.ejb.Singleton"), EjbJamContributor.createEjbClassPattern(SessionBean.class, SessionType.SINGLETON)}));
        MessageDrivenBeanImpl.MDB_META.register(registrar, PsiJavaPatterns.or((ElementPattern[])new ElementPattern[]{PsiJavaPatterns.psiClass().withAnnotation("javax.ejb.MessageDriven"), EjbJamContributor.createEjbClassPattern(MessageDrivenBean.class, null)}));
        EntityBeanImpl.ENTITY_META.register(registrar, (ElementPattern)EjbJamContributor.createEjbClassPattern(EntityBean.class, null));
        InterceptorImpl.INTERCEPTOR_META.register(registrar, EjbJamContributor.createInterceptorPattern());
        EjbMethodImpl.METHOD_META.register(registrar, PsiJavaPatterns.or((ElementPattern[])new ElementPattern[]{PsiJavaPatterns.psiMethod().withAnnotations(new String[]{"javax.ejb.Remove", "javax.ejb.Init", "javax.interceptor.Interceptors", "javax.interceptor.ExcludeClassInterceptors", "javax.interceptor.ExcludeDefaultInterceptors", "javax.ejb.Timeout", "javax.jws.WebMethod"}), PsiJavaPatterns.psiMethod().with((PatternCondition)new PatternCondition<PsiMethod>("isBusinessMethod"){

            public boolean accepts(@NotNull PsiMethod psiMethod, ProcessingContext context) {
                if (psiMethod == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (psiMethod.isConstructor() || !psiMethod.hasModifierProperty("public") || psiMethod.hasModifierProperty("static")) {
                    return false;
                }
                THashSet businessInterfaces = new THashSet();
                for (EjbClassRole role : NewEjbRoleHolder.getInstance(psiMethod.getProject()).getMergedRoles(psiMethod.getContainingClass())) {
                    EnterpriseBean ejb = role.getEnterpriseBean();
                    if (ejb == null) continue;
                    for (GenericValue value : ejb.getBusinessInterfaces()) {
                        ContainerUtil.addIfNotNull((Collection)businessInterfaces, (Object)value.getValue());
                    }
                }
                return EjbUtil.isInheritedFromBusinessInterface(psiMethod, (Collection<? extends PsiClass>)businessInterfaces);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiMethod", "com/intellij/javaee/model/annotations/ejb/EjbJamContributor$1", "accepts"));
            }
        })}));
        registrar.registerSemElementProvider(JamService.MEMBER_META_KEY.subKey(EjbReferenceImpl.class.getSimpleName() + "sMeta", new SemKey[0]), (ElementPattern)((PsiAnnotationPattern)PsiJavaPatterns.psiAnnotation().withName("javax.ejb.EJB")).inside((ElementPattern)PsiJavaPatterns.psiAnnotation().withName("javax.ejb.EJBs")), (NullableFunction)new ConstantFunction(EjbReferenceImpl.EJB_META));
        EjbReferenceImpl.EJB_META.register(registrar, (ElementPattern)PsiJavaPatterns.psiMember().withAnnotation("javax.ejb.EJB"));
        registrar.registerSemElementProvider(JamService.MEMBER_META_KEY.subKey(ServiceRefImpl.class.getSimpleName() + "sMeta", new SemKey[0]), (ElementPattern)((PsiAnnotationPattern)PsiJavaPatterns.psiAnnotation().withName("javax.xml.ws.WebServiceRef")).inside((ElementPattern)PsiJavaPatterns.psiAnnotation().withName("javax.xml.ws.WebServiceRefs")), (NullableFunction)new ConstantFunction(ServiceRefImpl.SERVICE_META));
        ServiceRefImpl.SERVICE_META.register(registrar, (ElementPattern)PsiJavaPatterns.psiMember().withAnnotation("javax.jws.WebService"));
        registrar.registerSemElementProvider(JamService.MEMBER_META_KEY.subKey(ResourceImpl.class.getSimpleName() + "sMeta", new SemKey[0]), (ElementPattern)((PsiAnnotationPattern)PsiJavaPatterns.psiAnnotation().withName("javax.annotation.Resource")).inside((ElementPattern)PsiJavaPatterns.psiAnnotation().withName("javax.annotation.Resources")), (NullableFunction)new ConstantFunction(ResourceImpl.RESOURCE_META));
        ResourceImpl.RESOURCE_META.register(registrar, (ElementPattern)PsiJavaPatterns.psiMember().withAnnotation("javax.annotation.Resource"));
        InterceptorMethodImpl.METHOD_META.register(registrar, (ElementPattern)PsiJavaPatterns.psiMethod().withAnnotations(new String[]{"javax.annotation.PreDestroy", "javax.annotation.PostConstruct", "javax.ejb.PostActivate", "javax.ejb.PrePassivate", "javax.ejb.PostActivate", "javax.interceptor.AroundInvoke"}));
    }

    private static PsiClassPattern createEjbClassPattern(final Class<? extends EnterpriseBean> beanClass, final SessionType sessionType) {
        return (PsiClassPattern)PsiJavaPatterns.psiClass().with((PatternCondition)new PatternCondition<PsiClass>("xmlEnterpriseBean"){

            public boolean accepts(@NotNull PsiClass psiClass, ProcessingContext context) {
                if (psiClass == null) {
                    2.$$$reportNull$$$0(0);
                }
                for (EjbClassRole role : NewEjbRoleHolder.getInstance(psiClass.getProject()).getXmlRoles(psiClass)) {
                    EnterpriseBean ejb = role.getEnterpriseBean();
                    if (role.getFacet().getAnnotationRoot() == null || role.getType() != EjbClassRoleEnum.EJB_CLASS_ROLE_EJB_CLASS || !psiClass.getManager().areElementsEquivalent((PsiElement)psiClass, (PsiElement)role.getEnterpriseBean().getEjbClass().getValue())) continue;
                    return beanClass.isInstance(ejb) && (sessionType == null || ((SessionBean)ejb).getSessionType().getValue() == sessionType);
                }
                return false;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiClass", "com/intellij/javaee/model/annotations/ejb/EjbJamContributor$2", "accepts"));
            }
        });
    }

    private static ElementPattern<? extends PsiClass> createInterceptorPattern() {
        return PsiJavaPatterns.or((ElementPattern[])new ElementPattern[]{PsiJavaPatterns.psiClass().with((PatternCondition)new PatternCondition<PsiClass>("isInInterceptorsAnnotation"){

            public boolean accepts(@NotNull PsiClass psiClass, ProcessingContext context) {
                if (psiClass == null) {
                    3.$$$reportNull$$$0(0);
                }
                return EjbRootElementImpl.getInterceptorClasses(psiClass.getProject()).contains(psiClass);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiClass", "com/intellij/javaee/model/annotations/ejb/EjbJamContributor$3", "accepts"));
            }
        }), PsiJavaPatterns.psiClass().with((PatternCondition)new PatternCondition<PsiClass>("xmlInterceptor"){

            public boolean accepts(@NotNull PsiClass psiClass, ProcessingContext context) {
                if (psiClass == null) {
                    4.$$$reportNull$$$0(0);
                }
                for (EjbClassRole role : NewEjbRoleHolder.getInstance(psiClass.getProject()).getXmlRoles(psiClass)) {
                    if (role.getFacet().getAnnotationRoot() == null || role.getType() != EjbClassRoleEnum.EJB_CLASS_ROLE_INTERCEPTOR_CLASS) continue;
                    return true;
                }
                return false;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiClass", "com/intellij/javaee/model/annotations/ejb/EjbJamContributor$4", "accepts"));
            }
        })});
    }
}

