/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.ejb.role;

import com.intellij.javaee.ejb.EjbUtil;
import com.intellij.javaee.ejb.facet.EjbFacet;
import com.intellij.javaee.ejb.role.EjbClassRole;
import com.intellij.javaee.ejb.role.EjbDeclMethodRoleImpl;
import com.intellij.javaee.ejb.role.EjbImplMethodRoleImpl;
import com.intellij.javaee.ejb.role.EjbMethodRole;
import com.intellij.javaee.ejb.role.EjbMethodRoleEnum;
import com.intellij.javaee.ejb.role.EjbRoleImpl;
import com.intellij.javaee.model.common.JavaeeModelElement;
import com.intellij.javaee.model.common.ejb.CmpField;
import com.intellij.javaee.model.common.ejb.CmrField;
import com.intellij.javaee.model.common.ejb.EjbCommonModelUtil;
import com.intellij.javaee.model.common.ejb.EnterpriseBean;
import com.intellij.javaee.model.common.ejb.EntityBean;
import com.intellij.openapi.module.Module;
import com.intellij.psi.PsiMethod;
import com.intellij.util.JavaeeIcons;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class EjbMethodRoleImpl
extends EjbRoleImpl
implements EjbMethodRole {
    @NonNls
    protected static final String EJB_CREATE_PREFIX = "ejbCreate";
    @NonNls
    protected static final String EJB_POSTCREATE_PREFIX = "ejbPostCreate";
    @NonNls
    protected static final String EJB_FIND_PREFIX = "ejbFind";
    @NonNls
    protected static final String EJB_SELECT_PREFIX = "ejbSelect";
    @NonNls
    protected static final String EJB_HOME_PREFIX = "ejbHome";
    @NonNls
    protected static final String CREATE_PREFIX = "create";
    @NonNls
    protected static final String FIND_PREFIX = "find";
    @NonNls
    protected static final String REMOVE_PREFIX = "remove";
    @NonNls
    protected static final String GET_PREFIX = "get";
    private final PsiMethod myMethod;
    private final EjbMethodRoleEnum myType;
    private final EjbClassRole myClassRole;

    EjbMethodRoleImpl(PsiMethod method, EjbClassRole classRole, EjbMethodRoleEnum type) {
        super(classRole.getEnterpriseBean());
        this.myMethod = method;
        this.myType = type;
        this.myClassRole = classRole;
    }

    public EjbFacet getFacet() {
        return this.myClassRole.getFacet();
    }

    public Module getModule() {
        return this.myClassRole.getModule();
    }

    public final EjbClassRole getClassRole() {
        return this.myClassRole;
    }

    public final EjbMethodRoleEnum getType() {
        return this.myType;
    }

    final PsiMethod getMethod() {
        return this.myMethod;
    }

    boolean checkPairingMethods() {
        return true;
    }

    public static EjbMethodRoleImpl suggestMethodRole(EjbClassRole classRole, PsiMethod method) {
        switch (classRole.getType()) {
            case EJB_CLASS_ROLE_EJB_CLASS: {
                return EjbMethodRoleImpl.suggestClassRole(classRole, method);
            }
            case EJB_CLASS_ROLE_LOCAL_INTERFACE: 
            case EJB_CLASS_ROLE_REMOTE_INTERFACE: 
            case EJB_CLASS_ROLE_BUSINESS_LOCAL_INTERFACE: 
            case EJB_CLASS_ROLE_BUSINESS_REMOTE_INTERFACE: 
            case EJB_CLASS_ROLE_SERVICE_ENDPOINT_INTERFACE: {
                return EjbMethodRoleImpl.suggestRemoteRole(classRole, method);
            }
            case EJB_CLASS_ROLE_HOME_INTERFACE: 
            case EJB_CLASS_ROLE_LOCAL_HOME_INTERFACE: {
                return EjbMethodRoleImpl.suggestHomeRole(classRole, method);
            }
        }
        return null;
    }

    private static EjbMethodRoleImpl suggestClassRole(EjbClassRole classRole, PsiMethod method) {
        EnterpriseBean ejb = classRole.getEnterpriseBean();
        String methodName = method.getName();
        if (methodName.startsWith(EJB_CREATE_PREFIX)) {
            return new EjbImplMethodRoleImpl(method, classRole, EjbMethodRoleEnum.EJB_METHOD_ROLE_CREATE_IMPL);
        }
        if (methodName.startsWith(EJB_POSTCREATE_PREFIX)) {
            return new EjbImplMethodRoleImpl(method, classRole, EjbMethodRoleEnum.EJB_METHOD_ROLE_POST_CREATE_IMPL);
        }
        if (methodName.startsWith(EJB_FIND_PREFIX)) {
            if (ejb instanceof EntityBean) {
                return new EjbImplMethodRoleImpl(method, classRole, EjbMethodRoleEnum.EJB_METHOD_ROLE_FINDER_IMPL);
            }
        } else if (methodName.startsWith(EJB_SELECT_PREFIX)) {
            if (ejb instanceof EntityBean) {
                return new EjbImplMethodRoleImpl(method, classRole, EjbMethodRoleEnum.EJB_METHOD_ROLE_SELECTOR_IMPL);
            }
        } else {
            List interfaces;
            if (methodName.startsWith(EJB_HOME_PREFIX)) {
                String newName = methodName.substring(EJB_HOME_PREFIX.length());
                if (newName.length() == 0) {
                    return null;
                }
                if ((newName = Character.toLowerCase(newName.charAt(0)) + newName.substring(1)).startsWith(CREATE_PREFIX) || newName.startsWith(FIND_PREFIX) || newName.startsWith(REMOVE_PREFIX)) {
                    return null;
                }
                return new EjbImplMethodRoleImpl(method, classRole, EjbMethodRoleEnum.EJB_METHOD_ROLE_HOME_BUSINESS_METHOD_IMPL);
            }
            if (method.isConstructor()) {
                return null;
            }
            if ((method.hasModifierProperty("public") || method.hasModifierProperty("protected")) && ejb instanceof EntityBean && EjbUtil.isEjbFieldAccessor(method) && !EjbUtil.isEjbVersion1x((JavaeeModelElement)ejb)) {
                String property = EjbUtil.getEjbFieldNameByAccessor(method);
                Object cmpField = EjbUtil.findCmpField((EntityBean)ejb, property);
                if (cmpField != null) {
                    return new EjbImplMethodRoleImpl(method, classRole, methodName.startsWith(GET_PREFIX) ? EjbMethodRoleEnum.EJB_METHOD_ROLE_CMP_GETTER_IMPL : EjbMethodRoleEnum.EJB_METHOD_ROLE_CMP_SETTER_IMPL);
                }
                CmrField cmrField = EjbUtil.findCmrField((EntityBean)ejb, property);
                if (cmrField != null) {
                    return new EjbImplMethodRoleImpl(method, classRole, methodName.startsWith(GET_PREFIX) ? EjbMethodRoleEnum.EJB_METHOD_ROLE_CMR_GETTER_IMPL : EjbMethodRoleEnum.EJB_METHOD_ROLE_CMR_SETTER_IMPL);
                }
            }
            if ((interfaces = EjbCommonModelUtil.getEjbClasses((EnterpriseBean)ejb, (boolean)false, (boolean)false, (boolean)true)).size() > 0 && (method.hasModifierProperty("public") || EjbUtil.isInheritedFromBusinessInterface(method, interfaces))) {
                return new EjbImplMethodRoleImpl(method, classRole, EjbMethodRoleEnum.EJB_METHOD_ROLE_BUSINESS_METHOD_IMPL);
            }
        }
        return null;
    }

    private static EjbMethodRoleImpl suggestRemoteRole(EjbClassRole classRole, PsiMethod method) {
        EnterpriseBean ejb = classRole.getEnterpriseBean();
        if (ejb instanceof EntityBean && EjbUtil.isEjbFieldAccessor(method) && !EjbUtil.isEjbVersion1x((JavaeeModelElement)ejb)) {
            CmpField cmpField = EjbUtil.findCmpField(ejb, method);
            if (cmpField != null) {
                return new EjbDeclMethodRoleImpl(method, classRole, method.getName().startsWith(GET_PREFIX) ? EjbMethodRoleEnum.EJB_METHOD_ROLE_CMP_GETTER_DECL : EjbMethodRoleEnum.EJB_METHOD_ROLE_CMP_SETTER_DECL);
            }
            CmrField cmrField = EjbUtil.findCmrField(ejb, method);
            if (cmrField != null) {
                return new EjbDeclMethodRoleImpl(method, classRole, method.getName().startsWith(GET_PREFIX) ? EjbMethodRoleEnum.EJB_METHOD_ROLE_CMR_GETTER_DECL : EjbMethodRoleEnum.EJB_METHOD_ROLE_CMR_SETTER_DECL);
            }
        }
        return new EjbDeclMethodRoleImpl(method, classRole, EjbMethodRoleEnum.EJB_METHOD_ROLE_BUSINESS_METHOD_DECL);
    }

    private static EjbMethodRoleImpl suggestHomeRole(EjbClassRole classRole, PsiMethod method) {
        String methodName = method.getName();
        if (methodName.startsWith(CREATE_PREFIX)) {
            return new EjbDeclMethodRoleImpl(method, classRole, EjbMethodRoleEnum.EJB_METHOD_ROLE_CREATE_DECL);
        }
        boolean isEntityBean = classRole.getEnterpriseBean() instanceof EntityBean;
        if (methodName.startsWith(FIND_PREFIX)) {
            return isEntityBean ? new EjbDeclMethodRoleImpl(method, classRole, EjbMethodRoleEnum.EJB_METHOD_ROLE_FINDER_DECL) : null;
        }
        return !isEntityBean || !methodName.startsWith(REMOVE_PREFIX) ? new EjbDeclMethodRoleImpl(method, classRole, EjbMethodRoleEnum.EJB_METHOD_ROLE_HOME_BUSINESS_METHOD_DECL) : null;
    }

    public String getTitle() {
        return null;
    }

    public String toString() {
        return this.getTitle();
    }

    public Icon getIcon() {
        return EjbMethodRoleImpl.getIcon(this.getType());
    }

    public static Icon getIcon(@NotNull EjbMethodRoleEnum type) {
        if (type == null) {
            EjbMethodRoleImpl.$$$reportNull$$$0(0);
        }
        switch (type) {
            case EJB_METHOD_ROLE_CREATE_DECL: 
            case EJB_METHOD_ROLE_CREATE_IMPL: 
            case EJB_METHOD_ROLE_POST_CREATE_IMPL: {
                return JavaeeIcons.EJB_CREATE_METHOD_ICON;
            }
            case EJB_METHOD_ROLE_FINDER_DECL: 
            case EJB_METHOD_ROLE_FINDER_IMPL: 
            case EJB_METHOD_ROLE_SELECTOR_IMPL: {
                return JavaeeIcons.EJB_FINDER_METHOD_ICON;
            }
            case EJB_METHOD_ROLE_BUSINESS_METHOD_DECL: 
            case EJB_METHOD_ROLE_HOME_BUSINESS_METHOD_DECL: 
            case EJB_METHOD_ROLE_HOME_BUSINESS_METHOD_IMPL: 
            case EJB_METHOD_ROLE_BUSINESS_METHOD_IMPL: {
                return JavaeeIcons.EJB_BUSINESS_METHOD_ICON;
            }
            case EJB_METHOD_ROLE_CMP_GETTER_DECL: 
            case EJB_METHOD_ROLE_CMP_GETTER_IMPL: 
            case EJB_METHOD_ROLE_CMP_SETTER_DECL: 
            case EJB_METHOD_ROLE_CMP_SETTER_IMPL: {
                return JavaeeIcons.EJB_CMP_FIELD_ICON;
            }
            case EJB_METHOD_ROLE_CMR_GETTER_DECL: 
            case EJB_METHOD_ROLE_CMR_GETTER_IMPL: 
            case EJB_METHOD_ROLE_CMR_SETTER_DECL: 
            case EJB_METHOD_ROLE_CMR_SETTER_IMPL: {
                return JavaeeIcons.EJB_CMR_FIELD_ICON;
            }
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/javaee/ejb/role/EjbMethodRoleImpl", "getIcon"));
    }
}

