/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.ejb.inspections;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInsight.daemon.impl.analysis.annotator.EjbHighlightingMessages;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.jam.JamClassAttributeElement;
import com.intellij.jam.JamElement;
import com.intellij.jam.JamService;
import com.intellij.jam.JamStringAttributeElement;
import com.intellij.javaee.JavaeeUtil;
import com.intellij.javaee.ejb.EjbUtil;
import com.intellij.javaee.ejb.OldEjbRolesUtil;
import com.intellij.javaee.ejb.facet.EjbFacet;
import com.intellij.javaee.ejb.inspections.AbstractEjbInspection;
import com.intellij.javaee.ejb.inspections.EjbHighlightUtil;
import com.intellij.javaee.ejb.role.EjbClassRoleEnum;
import com.intellij.javaee.facet.JavaeeFacetUtil;
import com.intellij.javaee.model.annotations.AnnotationGenericValue;
import com.intellij.javaee.model.annotations.ejb.EjbReferenceImpl;
import com.intellij.javaee.model.annotations.ejb.EnvironmentGroupImpl;
import com.intellij.javaee.model.common.EjbReference;
import com.intellij.javaee.model.common.EnvironmentGroup;
import com.intellij.javaee.model.common.JavaeeReference;
import com.intellij.javaee.model.common.Resource;
import com.intellij.javaee.model.common.ServiceRef;
import com.intellij.javaee.model.common.ejb.EjbCommonModelUtil;
import com.intellij.javaee.model.common.ejb.EjbDescriptorVersion;
import com.intellij.javaee.model.common.ejb.EnterpriseBean;
import com.intellij.javaee.model.common.ejb.SessionBean;
import com.intellij.javaee.model.xml.InjectionTarget;
import com.intellij.javaee.model.xml.ejb.EjbBase;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.util.PropertyUtilBase;
import com.intellij.util.Function;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.GenericDomValue;
import com.intellij.util.xml.GenericValue;
import com.intellij.util.xml.ModelMergerUtil;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class EjbEnvironmentInspection
extends AbstractEjbInspection {
    @Nls
    @NotNull
    public String getDisplayName() {
        String string = EjbHighlightingMessages.message("inspection.name.environment.problems", new Object[0]);
        if (string == null) {
            EjbEnvironmentInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public String getShortName() {
        if ("EjbEnvironmentInspection" == null) {
            EjbEnvironmentInspection.$$$reportNull$$$0(1);
        }
        return "EjbEnvironmentInspection";
    }

    @NotNull
    public HighlightDisplayLevel getDefaultLevel() {
        HighlightDisplayLevel highlightDisplayLevel = HighlightDisplayLevel.ERROR;
        if (highlightDisplayLevel == null) {
            EjbEnvironmentInspection.$$$reportNull$$$0(2);
        }
        return highlightDisplayLevel;
    }

    @Override
    protected boolean acceptClass(PsiClass psiClass) {
        EnvironmentGroup gr = (EnvironmentGroup)JamService.getJamService((Project)psiClass.getProject()).getJamElement(EnvironmentGroupImpl.JAVAEE_ENVIRONMENT_KEY, (PsiElement)psiClass);
        if (gr != null) {
            return true;
        }
        EnumSet<EjbClassRoleEnum> roleTypes = EjbEnvironmentInspection.getRoleTypes(OldEjbRolesUtil.getEjbRoles(psiClass));
        return roleTypes.contains(EjbClassRoleEnum.EJB_CLASS_ROLE_EJB_CLASS) || roleTypes.contains(EjbClassRoleEnum.EJB_CLASS_ROLE_INTERCEPTOR_CLASS);
    }

    @Override
    protected JavaElementVisitor createJavaVisitor(final @NotNull ProblemsHolder holder, boolean onTheFly) {
        if (holder == null) {
            EjbEnvironmentInspection.$$$reportNull$$$0(3);
        }
        return new JavaElementVisitor(){

            public void visitClass(PsiClass aClass) {
                EjbEnvironmentInspection.this.checkDependencyInjection(holder, (PsiMember)aClass);
            }

            public void visitMethod(PsiMethod method) {
                EjbEnvironmentInspection.this.checkDependencyInjection(holder, (PsiMember)method);
            }

            public void visitField(PsiField field) {
                EjbEnvironmentInspection.this.checkDependencyInjection(holder, (PsiMember)field);
            }
        };
    }

    private void checkDependencyInjection(ProblemsHolder holder, PsiMember psiMember) {
        JavaeeReference[] javaeeReferences = OldEjbRolesUtil.getInjectedReferences(psiMember);
        if (javaeeReferences.length == 0) {
            return;
        }
        HashMap<GenericValue<PsiMember>, JavaeeReference> map = new HashMap<GenericValue<PsiMember>, JavaeeReference>(javaeeReferences.length);
        for (JavaeeReference reference : javaeeReferences) {
            ContainerUtil.process((List)reference.getTargetMembers(), (Processor)ModelMergerUtil.createFilteringProcessor(o -> {
                if (o.getValue() == psiMember) {
                    map.put((GenericValue<PsiMember>)o, reference);
                }
                return true;
            }));
        }
        EjbEnvironmentInspection.checkMoreThanOneInjectionIsConfigured(holder, psiMember, map);
        for (JavaeeReference reference : javaeeReferences) {
            for (EjbReferenceImpl annoRef : ModelMergerUtil.getImplementations((Object)reference, EjbReferenceImpl.class)) {
                EjbEnvironmentInspection.checkEjbAnnotation(holder, psiMember, annoRef);
            }
        }
        if (!(psiMember instanceof PsiClass)) {
            boolean isEjb = false;
            boolean isResource = false;
            boolean isLookupResource = false;
            boolean isService = false;
            for (JavaeeReference javaeeReference : javaeeReferences) {
                if (javaeeReference instanceof EjbReference) {
                    isEjb = true;
                    continue;
                }
                if (javaeeReference instanceof Resource) {
                    isResource = true;
                    if (!StringUtil.isNotEmpty((String)((Resource)javaeeReference).getLookup().getStringValue())) continue;
                    isLookupResource = true;
                    continue;
                }
                if (!(javaeeReference instanceof ServiceRef)) continue;
                isService = true;
            }
            EjbEnvironmentInspection.checkDependencyInjectionSignature(holder, psiMember, isEjb, isResource, isService, isLookupResource);
        }
    }

    private static void checkMoreThanOneInjectionIsConfigured(ProblemsHolder holder, PsiMember psiMember, Map<GenericValue<PsiMember>, JavaeeReference> map) {
        THashMap valueMap = new THashMap(1);
        boolean problemFound = false;
        for (GenericValue<PsiMember> o : map.keySet()) {
            Boolean key = o instanceof DomElement ? ((DomElement)o).getParentOfType(EjbBase.class, true) : (o instanceof JamElement ? Boolean.TRUE : null);
            if (key == null) continue;
            Set set = (Set)valueMap.get(key);
            if (set == null) {
                set = new THashSet(1);
                valueMap.put(key, set);
            } else if (!problemFound) {
                problemFound = true;
            }
            set.add(o);
        }
        boolean isClass = psiMember instanceof PsiClass;
        if (!isClass && problemFound) {
            Function function = s -> {
                InjectionTarget injectionTarget = (InjectionTarget)s.getParentOfType(InjectionTarget.class, true);
                return injectionTarget != null ? injectionTarget : s;
            };
            ArrayList quickFixes = new ArrayList();
            Processor processor = value -> {
                final String name = EjbHighlightingMessages.message("text.remove.0", JavaeeUtil.getJavaeeObjectDescription(value, (Function<? super DomElement, ? extends DomElement>)function));
                quickFixes.add(new LocalQuickFix((GenericValue)value, function){
                    final /* synthetic */ GenericValue val$value;
                    final /* synthetic */ Function val$function;
                    {
                        this.val$value = genericValue;
                        this.val$function = function;
                    }

                    @NotNull
                    public String getName() {
                        String string = name;
                        if (string == null) {
                            2.$$$reportNull$$$0(0);
                        }
                        return string;
                    }

                    @NotNull
                    public String getFamilyName() {
                        String string = EjbHighlightingMessages.message("intention.family.remove.dependency.injection.settings", new Object[0]);
                        if (string == null) {
                            2.$$$reportNull$$$0(1);
                        }
                        return string;
                    }

                    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
                        if (project == null) {
                            2.$$$reportNull$$$0(2);
                        }
                        if (descriptor == null) {
                            2.$$$reportNull$$$0(3);
                        }
                        if (this.val$value instanceof AnnotationGenericValue) {
                            PsiAnnotation psiAnnotation = ((AnnotationGenericValue)this.val$value).getIdentifyingAnnotation();
                            if (psiAnnotation != null) {
                                psiAnnotation.delete();
                            }
                        } else if (this.val$value instanceof GenericDomValue) {
                            DomElement domValue = (DomElement)this.val$function.fun((Object)((GenericDomValue)this.val$value));
                            domValue.undefine();
                        }
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        RuntimeException runtimeException;
                        Object[] objectArray;
                        Object[] objectArray2;
                        int n2;
                        String string;
                        switch (n) {
                            default: {
                                string = "@NotNull method %s.%s must not return null";
                                break;
                            }
                            case 2: 
                            case 3: {
                                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                                break;
                            }
                        }
                        switch (n) {
                            default: {
                                n2 = 2;
                                break;
                            }
                            case 2: 
                            case 3: {
                                n2 = 3;
                                break;
                            }
                        }
                        Object[] objectArray3 = new Object[n2];
                        switch (n) {
                            default: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "com/intellij/javaee/ejb/inspections/EjbEnvironmentInspection$2";
                                break;
                            }
                            case 2: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "project";
                                break;
                            }
                            case 3: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "descriptor";
                                break;
                            }
                        }
                        switch (n) {
                            default: {
                                objectArray = objectArray2;
                                objectArray2[1] = "getName";
                                break;
                            }
                            case 1: {
                                objectArray = objectArray2;
                                objectArray2[1] = "getFamilyName";
                                break;
                            }
                            case 2: 
                            case 3: {
                                objectArray = objectArray2;
                                objectArray2[1] = "com/intellij/javaee/ejb/inspections/EjbEnvironmentInspection$2";
                                break;
                            }
                        }
                        switch (n) {
                            default: {
                                break;
                            }
                            case 2: 
                            case 3: {
                                objectArray = objectArray;
                                objectArray[2] = "applyFix";
                                break;
                            }
                        }
                        String string2 = String.format(string, objectArray);
                        switch (n) {
                            default: {
                                runtimeException = new IllegalStateException(string2);
                                break;
                            }
                            case 2: 
                            case 3: {
                                runtimeException = new IllegalArgumentException(string2);
                                break;
                            }
                        }
                        throw runtimeException;
                    }
                });
                return true;
            };
            for (Object key : valueMap.keySet()) {
                Set set = (Set)valueMap.get(key);
                if (set.size() <= 1) continue;
                ContainerUtil.process((Iterable)set, (Processor)processor);
            }
            boolean isMethod = psiMember instanceof PsiMethod;
            holder.registerProblem((PsiElement)(isMethod ? ((PsiMethod)psiMember).getNameIdentifier() : ((PsiField)psiMember).getNameIdentifier()), EjbHighlightingMessages.message(isMethod ? "more.than.one.dependency.injection.configured.for.method" : "more.than.one.dependency.injection.configured.for.field", psiMember.getName()), quickFixes.toArray(LocalQuickFix.EMPTY_ARRAY));
        }
    }

    private static void checkDependencyInjectionSignature(ProblemsHolder holder, PsiMember psiMember, boolean isEjb, boolean isResource, boolean isService, boolean isLookupResource) {
        String typeName;
        Set<String> allowedTypes;
        PsiTypeElement typeElement;
        if (psiMember instanceof PsiField) {
            PsiField psiField = (PsiField)psiMember;
            typeElement = psiField.getTypeElement();
            EjbHighlightUtil.checkFieldModifier(holder, psiField, "final", false);
            EjbHighlightUtil.checkFieldModifier(holder, psiField, "static", false);
        } else if (psiMember instanceof PsiMethod) {
            PsiParameter[] parameters;
            PsiMethod method = (PsiMethod)psiMember;
            PsiIdentifier psiIdentifier = method.getNameIdentifier();
            EjbHighlightUtil.checkMethodModifier(holder, method, "final", false);
            if (!PropertyUtilBase.isSimplePropertySetter((PsiMethod)method)) {
                holder.registerProblem((PsiElement)psiIdentifier, EjbHighlightingMessages.message("injected.property.method.should.be.setter", method.getName()), new LocalQuickFix[0]);
            }
            typeElement = (parameters = method.getParameterList().getParameters()).length > 0 ? parameters[0].getTypeElement() : null;
        } else {
            assert (false) : psiMember;
            return;
        }
        if (typeElement == null) {
            if (!isEjb && !isResource && isService) {
                // empty if block
            }
        } else if (isResource && !isLookupResource && !(allowedTypes = EjbUtil.getAllowedResourceTypeNames(psiMember.getContainingClass())).contains(typeName = typeElement.getType().getCanonicalText())) {
            holder.registerProblem((PsiElement)typeElement, EjbHighlightingMessages.message("injected.property.invalid.type", typeName), new LocalQuickFix[0]);
        }
    }

    private static void checkEjbAnnotation(ProblemsHolder holder, PsiMember psiMember, EjbReferenceImpl ref) {
        PsiAnnotation annoAnchor;
        PsiFile containingFile = psiMember.getContainingFile();
        PsiAnnotation psiAnnotation = (PsiAnnotation)ref.getAnnotationRef().getPsiElement();
        if (psiAnnotation == null || psiAnnotation.getContainingFile() != containingFile) {
            return;
        }
        JamStringAttributeElement<EnterpriseBean> beanNameValue = ref.getEjbLink();
        JamClassAttributeElement beanInterfaceValue = ref.getBeanInterface();
        PsiClass beanInterface = beanInterfaceValue.getValue();
        String beanName = beanNameValue.getStringValue();
        List<EnterpriseBean> list = EjbUtil.findEjbsByLink(JavaeeFacetUtil.getInstance().getJavaeeFacet((PsiElement)psiMember, EjbFacet.ID), beanInterface, beanName);
        Object object = annoAnchor = psiAnnotation.getParameterList().getTextLength() > 0 ? psiAnnotation.getParameterList() : psiAnnotation;
        if (list.isEmpty()) {
            holder.registerProblem((PsiElement)annoAnchor, EjbHighlightingMessages.message("ejb.reference.not.found", beanName == null ? "" : beanName, beanInterface == null ? "" : beanInterface.getName()), new LocalQuickFix[0]);
        } else if (list.size() == 1) {
            EnterpriseBean ejb = list.get(0);
            String ejbName = (String)ejb.getEjbName().getValue();
            List ejbHomeInterfaces = EjbCommonModelUtil.getEjbClasses((EnterpriseBean)ejb, (boolean)false, (boolean)true, (boolean)false);
            List ejbInterfaces = EjbCommonModelUtil.getEjbClasses((EnterpriseBean)ejb, (boolean)false, (boolean)false, (boolean)true);
            if (beanInterface != null) {
                PsiAnnotation anchor = beanInterfaceValue.getPsiElement() != null && beanInterfaceValue.getPsiElement().getContainingFile() == containingFile ? beanInterfaceValue.getPsiElement() : annoAnchor;
                ArrayList<LocalQuickFix> quickFixes = new ArrayList<LocalQuickFix>();
                PsiElementFactory factory = JavaPsiFacade.getInstance((Project)psiMember.getProject()).getElementFactory();
                EjbDescriptorVersion ejbVersion = ejb.getEjbVersion();
                if (EjbDescriptorVersion.EJB_VERSION_3_0.compareTo((Enum)ejbVersion) <= 0) {
                    for (PsiClass anInterface : ejbInterfaces) {
                        quickFixes.add(EjbEnvironmentInspection.createEJBReferenceTypeFix((PsiElement)anchor, (PsiElement)factory.createTypeElement((PsiType)factory.createType(anInterface))));
                    }
                }
                for (PsiClass homeInterface : ejbHomeInterfaces) {
                    quickFixes.add(EjbEnvironmentInspection.createEJBReferenceTypeFix((PsiElement)anchor, (PsiElement)factory.createTypeElement((PsiType)factory.createType(homeInterface))));
                }
                if (beanInterface == ejb.getEjbClass().getValue()) {
                    if (EjbDescriptorVersion.EJB_VERSION_3_0.compareTo((Enum)ejbVersion) > 0) {
                        holder.registerProblem((PsiElement)anchor, EjbHighlightingMessages.message("ejb.reference.no.interface.view.wrong.version", ejbVersion.getValue()), quickFixes.toArray(LocalQuickFix.EMPTY_ARRAY));
                    } else if (!(ejb instanceof SessionBean)) {
                        holder.registerProblem((PsiElement)anchor, EjbHighlightingMessages.message("ejb.reference.no.interface.view.wrong.type", ejbVersion.getValue()), new LocalQuickFix[0]);
                    }
                } else if (!ejbHomeInterfaces.contains(beanInterface) && !ejbInterfaces.contains(beanInterface)) {
                    holder.registerProblem((PsiElement)anchor, EjbHighlightingMessages.message("ejb.reference.ejb.interface.not.found", ejbName, beanInterface.getName()), quickFixes.toArray(LocalQuickFix.EMPTY_ARRAY));
                }
            }
            if (beanName != null && beanName.length() > 0 && !beanName.equals(ejbName)) {
                holder.registerProblem((PsiElement)beanNameValue.getPsiElement(), EjbHighlightingMessages.message("ejb.reference.bad.beanname", ejbName, beanName), new LocalQuickFix[0]);
            }
        } else {
            holder.registerProblem((PsiElement)annoAnchor, EjbHighlightingMessages.message("ejb.reference.beaninterface.parameter.should.be.specified", new Object[0]), new LocalQuickFix[0]);
        }
    }

    private static LocalQuickFix createEJBReferenceTypeFix(final PsiElement psiElement, final PsiElement replaceElement) {
        final String name = EjbHighlightingMessages.message("intention.family.ejb.reference.type.fix.0", replaceElement.getText());
        return new LocalQuickFix(){

            @NotNull
            public String getName() {
                String string = name;
                if (string == null) {
                    3.$$$reportNull$$$0(0);
                }
                return string;
            }

            @NotNull
            public String getFamilyName() {
                String string = EjbHighlightingMessages.message("intention.family.ejb.reference.type.fix", new Object[0]);
                if (string == null) {
                    3.$$$reportNull$$$0(1);
                }
                return string;
            }

            public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
                if (project == null) {
                    3.$$$reportNull$$$0(2);
                }
                if (descriptor == null) {
                    3.$$$reportNull$$$0(3);
                }
                psiElement.replace(replaceElement);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                    case 2: 
                    case 3: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 2;
                        break;
                    }
                    case 2: 
                    case 3: {
                        n2 = 3;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/javaee/ejb/inspections/EjbEnvironmentInspection$3";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "project";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "descriptor";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getName";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getFamilyName";
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/javaee/ejb/inspections/EjbEnvironmentInspection$3";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray = objectArray;
                        objectArray[2] = "applyFix";
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                    case 2: 
                    case 3: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 3: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 3: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javaee/ejb/inspections/EjbEnvironmentInspection";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getShortName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultLevel";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javaee/ejb/inspections/EjbEnvironmentInspection";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createJavaVisitor";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

